package com.xiaomai.cases.lunar.reserve;

import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import com.xiaomai.client.DataUserInfo;
import com.xiaomai.enums.ApiModule;
import com.xiaomai.enums.RequestType;
import com.xiaomai.enums.Terminal;
import com.xiaomai.utils.XMBaseTest;
import org.springframework.stereotype.Component;

/**
 * @BelongsProject: xm-sportstest
 * @BelongsPackage: com.xiaomai.cases.lunar.reserve
 * @Author: xuyamei
 * @CreateTime: 2024-06-25  16:15
 * @Description: 预约接口
 * @Version: 1.0
 */
@Component("reserveCTools")
public class ReserveCTools extends XMBaseTest {
    public void setUP(String apiName, DataUserInfo... userInfo) {
        dataApi.setApiModule(ApiModule.Lunar_Reserve)
                .setApiName(apiName)
                .setTerminal(Terminal.minApp);
        super.beforeDataRequest(userInfo);
    }

    /**
     * @description:查询课表
     * @author: xuyamei
     * @date:  2024/6/25 16:34
     * @param memberId
     * @param scheduleStartTime
     * @param scheduleEndTime
     * @return: com.alibaba.fastjson.JSONObject
     **/
    public JSONArray memberTimetable(String memberId,Long scheduleStartTime,Long scheduleEndTime){
        setUP("API_memberTimetable");

        JSONObject body = new JSONObject();
        body.put("brandId", dataApi.getLoginInfo().getBrandId());
        body.put("studioId", dataApi.getLoginInfo().getStudioId());
        body.put("startDate", scheduleStartTime);
        body.put("endDate",scheduleEndTime);
        body.put("courseChooseEnum","ALL");
        body.put("memberId",memberId);
        dataApi.doRequest(RequestType.JSON,dataparams,body.toString(),dataheadrs).assetsSuccess(true);
        return dataApi.getBodyInJSON().getJSONObject("result").getJSONArray("timetableGroups").getJSONObject(0).getJSONArray("timetableList");
    }



    public String memberReserveAdd(String areaId,String chiefCoachId,String benefitId,String assistantCoachId,String memberId,int reserveMemberNum,String scheduleId,long scheduleStartTime,boolean success,DataUserInfo...dataUserInfos){
        setUP("API_memberReserve_add",dataUserInfos);

        JSONObject body = new JSONObject();
        JSONArray areaIds = new JSONArray(); // 场地,私教约课会用到
        if (!areaId.equals("")){
            areaIds.add(areaId);
        }
        body.put("areaIds",areaIds);
        JSONArray coachIds = new JSONArray(); // 助教Ids
        if (!assistantCoachId.equals("")){
            coachIds.add(assistantCoachId);
        }
        body.put("assistantCoachIds",coachIds);
        body.put("benefitId",benefitId); //会员卡权益Id
        body.put("brandId", dataApi.getLoginInfo().getBrandId());
        body.put("chiefCoachId", chiefCoachId); // 主教id
        body.put("memberId", memberId); // 会员id
        body.put("operatorId", dataApi.getLoginInfo().getAdminId()); // 操作人id
        body.put("studioId", dataApi.getLoginInfo().getStudioId());
        body.put("planCheckBalance", 1); // 计划扣除额度
        body.put("reserveMemberNum", reserveMemberNum); // 预约人数
        body.put("scheduleId", scheduleId); // 课次id
        body.put("scheduleStartTime", scheduleStartTime); // 课次id
        dataApi.doRequest(RequestType.JSON,dataparams,body.toString(),dataheadrs).assetsSuccess(success);
        if (success){
            return dataApi.getBodyInJSON().getJSONObject("result").getString("reserveId");
        }
        return dataApi.getBodyInJSON().toString();


    }

    /**
     * @description:查询会员可用于约课的会员卡
     * @author: xuyamei
     * @date:  2024/6/23 12:38
     * @param courseId:课程id
     * @param courseType：课程类型  GROUP_CLASS
     * @param accountType：账户类型 MEMBER
     * @param memberId 会员id
     * @param reserveDate：约课时间
     * @return: com.alibaba.fastjson.JSONArray
     **/
    public JSONArray listUserReservableBenefit(String courseId,String courseType,String accountType,String memberId,long reserveDate){
        setUP("API_listUserReservableBenefit");

        JSONObject jsonObject = new JSONObject();
        jsonObject.put("courseId", courseId);
        jsonObject.put("courseType", courseType);
        jsonObject.put("accountType", accountType);
        jsonObject.put("memberId", memberId);
        jsonObject.put("reserveDate", reserveDate);
        jsonObject.put("studioId", dataApi.getLoginInfo().getStudioId());

        dataApi.doRequest(RequestType.JSON, dataparams, jsonObject.toJSONString(), dataheadrs).assetsSuccess(true);
        return dataApi.getBodyInJSON().getJSONArray("result");
    }

    /**
     * @description:小程序查询课次详情
     * @author: xuyamei
     * @date:  2024/6/25 18:23
     * @param scheduleId
     * @return: com.alibaba.fastjson.JSONObject
     **/
    public JSONObject getMemberScheduleItemDetail(String scheduleId,String memberId){
        setUP("API_getMemberScheduleItemDetail");

        JSONObject jsonObject = new JSONObject();
        jsonObject.put("scheduleId", scheduleId);
        jsonObject.put("memberId", memberId);
        jsonObject.put("studioId", dataApi.getLoginInfo().getStudioId());

        dataApi.doRequest(RequestType.JSON, dataparams, jsonObject.toJSONString(), dataheadrs).assetsSuccess(true);
        return dataApi.getBodyInJSON().getJSONObject("result");
    }

    /**
     * @description:小程序查询预约记录列表
     * @author: xuyamei
     * @date:  2024/6/25 18:29
     * @param signInStateSet :预约状态 UN_SIGNED：已预约未签到 、QUEUE_PROCESS：排队中 、 "SIGNED"：签到、 "LEAVE"：请假 、取消预约 "QUEUE_CANCEL"：排队取消、RESERVE_CANCEL：预约取消
     * @param signState：签到状态
     * @param scheduleStartDate ：课次开始时间
     * @param scheduleEndDate：课次结束时间
     * @param memberId ：会员id
     * @param courseType ：课程类型 GROUP_CLASS：团课、PERSONAL：私教、TRAINING_CAMP：训练营
     * @return: com.alibaba.fastjson.JSONArray
     **/
    public JSONArray getPageByMember(String signInStateSet,String signState,Long scheduleStartDate,Long scheduleEndDate,String memberId,String courseType){
        setUP("API_getPageByMember");
        JSONObject body = new JSONObject();
        body.put("current",0);
        body.put("size",20);
        // 这里根据预约状态，则signInStateSet传值（SIGNED、LEAVE、UN_SIGNED），否则传reserveStateSet
        if (!signInStateSet.equals("") && signInStateSet.equals("SIGNED") || signInStateSet.equals("LEAVE") || signInStateSet.equals("UN_SIGNED")){
            JSONArray signInStateSetArr = new JSONArray();
            signInStateSetArr.add(signInStateSet);
            body.put("signInStateSet",signInStateSetArr);
        }else {
            JSONArray reserveStateSet = new JSONArray();
            reserveStateSet.add(signInStateSet);
            body.put("reserveStateSet",reserveStateSet);
        }


        if (!signState.equals("")){
            body.put("signInState",signState);
        }

        if (scheduleStartDate != null){
            body.put("scheduleStartDate",scheduleStartDate);
            body.put("scheduleEndDate",scheduleEndDate);
        }
        body.put("memberId",memberId);
        body.put("courseType",courseType);
        body.put("studioId", dataApi.getLoginInfo().getStudioId());

        dataApi.doRequest(RequestType.JSON,dataparams,body.toString(),dataheadrs).assetsSuccess(true);
        return dataApi.getBodyInJSON().getJSONObject("result").getJSONArray("records");
    }


    /**
     * @description:小程序根据id获取预约记录详情
     * @author: xuyamei
     * @date:  2024/6/25 19:25
     * @param reserveId 预约记录id
     * @param dataUserInfos
     * @return: com.alibaba.fastjson.JSONObject
     **/
    public JSONObject getDetailById(String reserveId,DataUserInfo...dataUserInfos) {
        setUP("API_getDetailById");

        JSONObject body = new JSONObject();
        body.put("reserveId",reserveId);

        dataApi.doRequest(RequestType.JSON,dataparams,body.toString(),dataheadrs).assetsSuccess(true);
        return dataApi.getBodyInJSON().getJSONObject("result");
    }



    /**
     * @description:小程序取消约课、排队
     * @author: xuyamei
     * @date:  2024/6/26 10:32
     * @param reserveId 预约id
     * @param memberId 会员id
     * @param success 正常传true
     * @return: void
     **/
    public void cancelMemberReserve(String reserveId,String memberId,boolean success) {
        setUP("API_cancelMemberReserve");

        JSONArray reserveIds = new JSONArray();
        reserveIds.add(reserveId);
        JSONObject body = new JSONObject();
        body.put("reserveIds",reserveIds);
        body.put("memberId",memberId);

        dataApi.doRequest(RequestType.JSON,dataparams,body.toString(),dataheadrs).assetsSuccess(success);
    }



    /**
     * @description:小程序排队
     * @author: xuyamei
     * @date:  2024/6/26 11:20
     * @param areaId ：场地
     * @param chiefCoachId 教练id
     * @param memberId 会员id
     * @param benefitId 权益id
     * @param assistantCoachId 助教id
     * @param reserveMemberNum 预约人数
     * @param scheduleId 课次id
     * @param scheduleStartTime 上课开始时间
     * @param success 正常传true
     * @return: java.lang.String
     **/
    public String addToQueue(String areaId,String chiefCoachId,String memberId,String benefitId,String assistantCoachId,int reserveMemberNum,String scheduleId,long scheduleStartTime,boolean success){
        setUP("API_addToQueue");

        JSONObject body = new JSONObject();
        JSONArray areaIds = new JSONArray(); // 场地,私教约课会用到
        if (!areaId.equals("")){
            areaIds.add(areaId);
        }
        body.put("areaIds",areaIds);
        JSONArray coachIds = new JSONArray(); // 助教Ids
        if (!assistantCoachId.equals("")){
            coachIds.add(assistantCoachId);
        }
        body.put("assistantCoachIds",coachIds);
        body.put("benefitId",benefitId); //会员卡权益Id
        body.put("brandId", dataApi.getLoginInfo().getBrandId());
        body.put("chiefCoachId", chiefCoachId); // 主教id
        body.put("memberId", memberId); // 会员id
        body.put("studioId", dataApi.getLoginInfo().getStudioId());
        body.put("planCheckBalance", 1); // 计划扣除额度
        body.put("reserveMemberNum", reserveMemberNum); // 预约人数
        body.put("scheduleId", scheduleId); // 课次id
        body.put("scheduleStartTime", scheduleStartTime); // 课次id
        dataApi.doRequest(RequestType.JSON,dataparams,body.toString(),dataheadrs).assetsSuccess(success);
        if (success){
            return dataApi.getBodyInJSON().getJSONObject("result").getString("reserveId");
        }
        return dataApi.getBodyInJSON().toString();
    }

    /**
     * @description:小程序手动签到
     * @author: xuyamei
     * @date:  2024/6/26 15:51
     * @param success 正常传true
     * @param reserveId 预约id
     * @param memberId 会员id
     * @return: java.lang.String
     **/
    public String signIn(boolean success,String reserveId,String memberId) {
        setUP("API_signIn");

        JSONObject body = new JSONObject();
        body.put("reserveId",reserveId);
        body.put("memberId",memberId);
        dataApi.doRequest(RequestType.JSON,dataparams,body.toString(),dataheadrs).assetsSuccess(success);

        return dataApi.getBodyInJSON().getString("message");
    }

    /**
     * @description: 扫码签到
     * @author: xuyamei
     * @date:  2024/6/26 15:54
     * @param success 正常传true
     * @param scheduleId 课次id
     * @param memberId 会员id
     * @return:
     **/
    public String signInByScanCode(boolean success,String scheduleId,String memberId) {
        setUP("API_signInByScanCode");

        JSONObject body = new JSONObject();
        body.put("scheduleId",scheduleId);
        body.put("memberId",memberId);
        dataApi.doRequest(RequestType.JSON,dataparams,body.toString(),dataheadrs).assetsSuccess(success);

        return dataApi.getBodyInJSON().getString("message");
    }

    /**
     * @description:签到前校验
     * @author: xuyamei
     * @date:  2024/6/26 15:58
     * @param success 正常传true
     * @param scheduleId 课次id
     * @param memberId 会员id
     * @return: java.lang.String
     **/
    public String queryPreSignInCheck(boolean success,String scheduleId,String memberId){
        setUP("API_queryPreSignInCheck");

        JSONObject body = new JSONObject();
        body.put("scheduleId",scheduleId);
        body.put("memberId",memberId);
        dataApi.doRequest(RequestType.JSON,dataparams,body.toString(),dataheadrs).assetsSuccess(success);
        return dataApi.getBodyInJSON().getJSONObject("result").getString("preSignInCheck");
    }

    /**
     * @description:小程序获取团课预约规则
     * @author: xuyamei
     * @date:  2024/6/26 16:04
     * @return: com.alibaba.fastjson.JSONObject
     **/
    public JSONObject getGroupBookingRules(){
        setUP("API_getGroupBookingRules");
        String body = "{\"studioId\":\""+dataApi.getLoginInfo().getStudioId()+"\"}";
        dataApi.doRequest(RequestType.JSON,dataparams,body,dataheadrs).assetsSuccess(true);
        return dataApi.getBodyInJSON().getJSONObject("result");

    }

}
