package com.xiaomai.cases.polar.course;

import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import com.xiaomai.basetest.BaseTestImpl;
import com.xiaomai.enums.ApiModule;
import com.xiaomai.enums.LoginAccount;
import com.xiaomai.enums.RequestType;
import com.xiaomai.enums.Terminal;
import com.xiaomai.utils.TimeUtils;
import org.testng.annotations.BeforeClass;
import org.testng.annotations.Test;

/**
 * @BelongsProject: xm-sportstest
 * @BelongsPackage: com.xiaomai.cases.polar.course
 * @Author: xuyamei
 * @CreateTime: 2024-04-25  11:43
 * @Description: 创建特定日期可约
 * @Version: 1.0
 */
public class TestCreateSpecialDate extends BaseTestImpl {
    @BeforeClass
    public void beforeTest() {
        setTestInfo(ApiModule.Polar_Admin, "API_createSpecialDate", LoginAccount.GYM_PROD, Terminal.B, "xym");
        super.beforeTest();
    }

    @Test
    public void testCreateSpecialDate() {
        JSONObject body = new JSONObject();
        body.put("brandId", xmAppApi.getLoginInfo().getBrandId());
        body.put("studioId", xmAppApi.getLoginInfo().getStudioId());
        body.put("coachId", "1762382404818898946");
        // 特定时间
        JSONObject specialTimeInfoRequest = new JSONObject();
        specialTimeInfoRequest.put("dutyType", "OFF_DUTY");

        JSONArray specialTimeInfoRequestArray = new JSONArray();
        specialTimeInfoRequestArray.add(TimeUtils.getBeforeDayDate(3));
        specialTimeInfoRequest.put("selectedDates", specialTimeInfoRequestArray);

        body.put("specialTimeInfoRequest", specialTimeInfoRequest);

        xmAppApi.doRequest(RequestType.JSON,params,body.toString(),headers).assetsSuccess(true);

    }
}
