package com.xiaomai.cases.lunar.order;

import com.alibaba.fastjson.JSONObject;
import com.xiaomai.basetest.BaseTestImpl;
import com.xiaomai.cases.polar.finance.order.OrderTools;
import com.xiaomai.cases.polar.memberCard.CardTools;
import com.xiaomai.client.DataUserInfo;
import com.xiaomai.enums.ApiModule;
import com.xiaomai.enums.LoginAccount;
import com.xiaomai.enums.RequestType;
import com.xiaomai.enums.Terminal;
import com.xiaomai.utils.TimeUtils;
import org.testng.Assert;
import org.testng.annotations.BeforeMethod;
import org.testng.annotations.Test;

import java.math.BigDecimal;

public class TestListByVoucherId extends BaseTestImpl {


    String cardId;

    OrderTools orderTools=new OrderTools();

    CardTools cardTools=new CardTools();

    @BeforeMethod
    @Override
    public void beforeTest(){
        setTestInfo(ApiModule.Lunar_Order,"API_listByVoucherId", LoginAccount.GYM_MINIAPPC, Terminal.minApp,"yff");
        super.beforeTest();
    }


    @Test(description = "C端获取订单支付记录")
    public void testListByVoucherId() {

        //切换B端购买实付金额>0的订单，否则0元单，看不了订单-支付记录.而且memberId只能用B/C通用的一个会员：1805435813468483586-GYM_MINIAPPC

        DataUserInfo dataUserInfo = new DataUserInfo();
        dataUserInfo.setTerminal(Terminal.B);
        dataUserInfo.setLoginUser(LoginAccount.GYM_PROD);

        //获取会员卡信息
        //获取会员卡列表,没有则新建一个
        int cardTotal = Integer.parseInt(orderTools.fetchPageOfMemberCard("次卡").getJSONObject("result").getString("total"));
        if (cardTotal == 0) {
            cardId = cardTools.memberCardCreate("次卡-创建订单会员卡"+ TimeUtils.getCurrentTime()).getString("result");
        }
        JSONObject memberCard=orderTools.fetchPageOfMemberCard("次卡");
        cardId=memberCard.getJSONObject("result").getJSONArray("records").getJSONObject(0).getString("id");
        BigDecimal quantity= new BigDecimal(memberCard.getJSONObject("result").getJSONArray("records").getJSONObject(0).getString("balance"));
        float price= Float.parseFloat(memberCard.getJSONObject("result").getJSONArray("records").getJSONObject(0).getString("price"));
        int validPeriod= Integer.parseInt(memberCard.getJSONObject("result").getJSONArray("records").getJSONObject(0).getString("validPeriod"));

        try {
            Thread.sleep(1000);
        } catch (InterruptedException e) {
            throw new RuntimeException(e);
        }

        //获取签单要用的卡快照id
        String latestSnapshotId=orderTools.fetchDetailById(cardId,xmAppApi.getLoginInfo().getBrandId(),xmAppApi.getLoginInfo().getStudioId(),xmAppApi.getLoginInfo().getAdminId()).getJSONObject("result").getString("latestSnapshotId");

        try {
            Thread.sleep(1000);
        } catch (InterruptedException e) {
            throw new RuntimeException(e);
        }

        //检查会员对该卡是否超出购买上限
        boolean limitResult=orderTools.checkAllowPurchase("MEMBER_CARD",cardId,"1805435813468483586","1",xmAppApi.getLoginInfo().getBrandId(),xmAppApi.getLoginInfo().getStudioId(),xmAppApi.getLoginInfo().getAdminId()).getBoolean("success");

        try {
            Thread.sleep(1000);
        } catch (InterruptedException e) {
            throw new RuntimeException(e);
        }

        if(limitResult == true) {

            //创建订单
            JSONObject orderResult = orderTools.signOrder(cardId, latestSnapshotId, quantity, price, validPeriod, latestSnapshotId, price / 2, "PURCHASE",
                    "MEMBER_CARD", "1805435813468483586", price - price / 2, price - price / 2, "1", dataUserInfo);
            String success = orderResult.getString("success");
            String getDetailId = orderResult.getString("result");
            Assert.assertEquals(success, "true", "创建签单订单失败");

            try {
                Thread.sleep(3000);
            } catch (InterruptedException e) {
                throw new RuntimeException(e);
            }

            //获取B端订单详情
            JSONObject getDetailResult = orderTools.getDetail(getDetailId, dataUserInfo);
            String id = getDetailResult.getJSONObject("result").getString("id");//订单ID
            String businessNo = getDetailResult.getJSONObject("result").getString("businessNo");//订单号


            try {
                Thread.sleep(1000);
            } catch (InterruptedException e) {
                throw new RuntimeException(e);
            }

            //切换C端看B端创建的非0元单的支付记录
            DataUserInfo info = new DataUserInfo();
            info.setTerminal(Terminal.minApp);
            info.setLoginUser(LoginAccount.GYM_MINIAPPC);

            //获取订单详情-支付记录
            JSONObject ListByVoucherId = new JSONObject();
            ListByVoucherId.put("id", id);

            xmAppApi.doRequest(RequestType.JSON, params, ListByVoucherId.toString(), headers).assetsSuccess(true);
            JSONObject ListByVoucherIdResponse = xmAppApi.getBodyInJSON();
            String ListByVoucherIdSuccess = ListByVoucherIdResponse.getString("success");
            String ListByVoucherIdVoucherBusinessNo = ListByVoucherIdResponse.getJSONArray("result").getJSONObject(0).getString("businessNo");//订单号
            Assert.assertEquals(ListByVoucherIdSuccess, "true", "C端获取B端创建非0元单的订单详情-支付记录失败");
            Assert.assertEquals(ListByVoucherIdVoucherBusinessNo.equals(businessNo), true, "C端获取订单详情-支付记录失败的订单与B端创建订单非一个订单");


        }

    }

}
