package com.xiaomai.cases.polar.data.salesData;

import com.alibaba.fastjson.JSONObject;
import com.xiaomai.enums.ApiModule;
import com.xiaomai.enums.LoginAccount;
import com.xiaomai.enums.RequestType;
import com.xiaomai.enums.Terminal;
import com.xiaomai.utils.TimeUtils;
import com.xiaomai.utils.XMBaseTest;
import org.testng.Assert;
import org.testng.annotations.BeforeMethod;
import org.testng.annotations.DataProvider;
import org.testng.annotations.Test;


public class TestTrend extends XMBaseTest {
    @BeforeMethod
    public void beforeTest(){
        xmAppApi.setApiModule(ApiModule.Polar_Data)
                .setApiName("API_saleDataTrend")
                .setLoginUser(LoginAccount.GYM_PROD)
                .setTerminal(Terminal.B);

        dal.setCase_owner("yff")
                .setCase_name(Thread.currentThread().getStackTrace()[1].getFileName().split("\\.")[0]);
        super.beforeTest();
    }
    @DataProvider
    public Object[][] dataProvider(){
        return new Object[][]{

                {"DAY","NEW_MEMBER_CLUE_COUNT",TimeUtils.getTodayEndTime(),TimeUtils.getTodayTime()},//新增会员数,今天
                {"MONTH","SIGN_ORDER_ACTUAL_AMOUNT",TimeUtils.getMonthLastDay(),TimeUtils.getMonthFristDay()},//签单实收金额,本月

        };
    }

    @Test(description = "销售数据-趋势图",dataProvider = "dataProvider")
    public void testTrend(String dateType,String metric,long endTime,long startTime){

        JSONObject trend=new JSONObject();
        trend.put("dateType",dateType);
        trend.put("endTime", endTime);
        trend.put("startTime", startTime);
        trend.put("metric",metric);
        trend.put("brandId",xmAppApi.getLoginInfo().getBrandId());
        trend.put("studioId",xmAppApi.getLoginInfo().getStudioId());
        trend.put("operatorId",xmAppApi.getLoginInfo().getAdminId());

        xmAppApi.doRequest(RequestType.JSON,params,trend.toJSONString(),headers).assetsSuccess(true);
        String trendResult=xmAppApi.getBodyInJSON().getString("success");
        Assert.assertEquals(trendResult,"true","获取销售数据-趋势图失败");


    }

    @DataProvider
    public Object[][] dataProvider1(){
        return new Object[][]{
                {"WEEK","NEW_MEMBER_CLUE_COUNT",TimeUtils.getWeekLastTime(),TimeUtils.getWeekFirstTime()},//新增会员数，本周
                {"WEEK","SIGN_ORDER_ACTUAL_AMOUNT",TimeUtils.getWeekLastTime(),TimeUtils.getWeekFirstTime()},//签单实收金额，本周
        };
    }

    @Test(description = "销售数据-趋势图",dataProvider = "dataProvider1")
    public void testTrend1(String dateType, String metric, String endTime, String startTime){

        JSONObject trend=new JSONObject();
        trend.put("dateType",dateType);
        trend.put("endTime", endTime);
        trend.put("startTime", startTime);
        trend.put("metric",metric);
        trend.put("brandId",xmAppApi.getLoginInfo().getBrandId());
        trend.put("studioId",xmAppApi.getLoginInfo().getStudioId());
        trend.put("operatorId",xmAppApi.getLoginInfo().getAdminId());

        xmAppApi.doRequest(RequestType.JSON,params,trend.toJSONString(),headers).assetsSuccess(true);
        String trendResult=xmAppApi.getBodyInJSON().getString("success");
        Assert.assertEquals(trendResult,"true","获取销售数据-趋势图失败");


    }
}
