package com.xiaomai.cases.polar.entry;

import com.alibaba.fastjson.JSONObject;
import com.xiaomai.cases.polar.admin.AdminTools;
import com.xiaomai.cases.polar.experienceCard.ExperienceCardTools;
import com.xiaomai.cases.polar.finance.order.OrderTools;
import com.xiaomai.cases.polar.member.Tools;
import com.xiaomai.cases.polar.memberCard.CardTools;
import com.xiaomai.enums.ApiModule;
import com.xiaomai.enums.LoginAccount;
import com.xiaomai.enums.RequestType;
import com.xiaomai.enums.Terminal;
import com.xiaomai.utils.RandomStringUtil;
import com.xiaomai.utils.XMBaseTest;
import com.xiaomai.utils.XMJSONPath;
import org.testng.Assert;
import org.testng.annotations.BeforeMethod;
import org.testng.annotations.Test;

import java.math.BigDecimal;

/**
 * @Author zxy
 * @Description
 * @Date 2024/11/6 15:15
 */
public class TestManual extends XMBaseTest {
    EntryTool entryTool = new EntryTool();
    OrderTools orderTools = new OrderTools();
    Tools tools = new Tools();
    CardTools cardTools = new CardTools();
    ExperienceCardTools experienceCardTools = new ExperienceCardTools();
    AdminTools adminTools=new AdminTools();
    String memberId;
    String memberCardId;
    String title;
    BigDecimal quantity; //可用次数
    float price; //价格
    int validPeriod; //有效期
    String latestSnapshotId;//最近的快照ID
    BigDecimal entryQuantity;//入场权益
    float entryPrice;//入场权益价格

    @BeforeMethod
    public void beforeTest(){

        xmAppApi.setApiModule(ApiModule.Polar_MemberEntry)
                .setApiName("API_manual")
                .setLoginUser(LoginAccount.GYM_PROD)
                .setTerminal(Terminal.B);

        dal.setCase_owner("zyx")
                .setCase_name(Thread.currentThread().getStackTrace()[1].getFileName().split("\\.")[0]);
        super.beforeTest();
    }

    @Test(description = "手动添加入场记录-临时入场")
    public void testManual(){
        memberId = tools.search("NORMAL","NORMAL").getJSONObject("result").getJSONArray("records").getJSONObject(0).getString("id");
        JSONObject object = new JSONObject();
        object.put("entryVoucherType","TEMP");
        object.put("memberId",memberId);
        object.put("entryVoucherId",-1);
        object.put("remark","自动化脚本手动添加入场记录备注");
        object.put("studioId",xmAppApi.getLoginInfo().getStudioId());
        object.put("brandId",xmAppApi.getLoginInfo().getBrandId());
        object.put("operatorId",xmAppApi.getLoginInfo().getAdminId());

        xmAppApi.doRequest(RequestType.JSON,params,object.toString(),headers).assetsSuccess(true);

        String id = XMJSONPath.readPath(xmAppApi.getBodyInJSON(),"$.result");
        Assert.assertEquals(entryTool.memberEntryPage("TEMP").getJSONObject("result").getJSONArray("records").getJSONObject(0).getString("id"),id);

        JSONObject res = entryTool.getMemberEntry(id).getJSONObject("result");
        Assert.assertEquals(res.getString("memberId"),memberId);
        Assert.assertEquals(res.getString("entryType"),"TEMP");
        Assert.assertEquals(res.getString("entryMethod"),"MANUAL");
        Assert.assertEquals(res.getString("entryVoucherType"),"TEMP");
        Assert.assertEquals(res.getString("operatorId"),xmAppApi.getLoginInfo().getAdminId());
    }

    @Test(description = "手动添加入场记录-体验卡入场")
    public void testManual_1(){
        //获取要添加入场记录的会员
        memberId = tools.search("NORMAL","NORMAL").getJSONObject("result").getJSONArray("records").getJSONObject(0).getString("id");

        //先搜索下体验卡列表有没有可用的数据，有数据才会执行下面的点代码,无数据则新建一个
        cardTools.doMemberCardcommonSearch("课程次数入场次数","EXPERIENCE_CARD");
        int listDatas = XMJSONPath.getJSONArrayByReadPath(dataApi.getApi_response(), "$.result.records").size();
        if (listDatas > 0) {
            memberCardId = XMJSONPath.readPath(dataApi.getApi_response(), "$.result[0].id");
        } else {
            for (int i = 0; i < 3; i++) {
                title = "课程次数入场次数" + RandomStringUtil.randomString(3) + "-自动化创建";
                //check是否存在同名的体验卡，不存在则新建
                Boolean duplicate = experienceCardTools.checkTitleDuplicate(title, "EXPERIENCE_CARD").getBoolean("result");
                if (duplicate == false) {
                    try {
                        Thread.sleep(3000);
                    } catch (InterruptedException e) {
                        e.printStackTrace();
                    }
                    memberCardId = experienceCardTools.create("EXPERIENCE_CARD", title, "全部", "YES", "课程次数入场次数",false).getString("result");
                    break;
                }
            }
        }
        //获取体验卡详情
        cardTools.fetchDetailById(memberCardId);
        quantity= new BigDecimal(XMJSONPath.readPath(dataApi.getApi_response(),"$.result.benefitList[0].balance"));
        entryQuantity = new BigDecimal(XMJSONPath.readPath(dataApi.getApi_response(),"$.result.benefitList[1].balance"));
        price=Float.valueOf(XMJSONPath.readPath(dataApi.getApi_response(), "$.result.benefitList[0].price"));
        entryPrice = Float.valueOf(XMJSONPath.readPath(dataApi.getApi_response(), "$.result.benefitList[1].price"));
        validPeriod=Integer.valueOf(XMJSONPath.readPath(dataApi.getApi_response(), "$.result.validPeriod"));
        latestSnapshotId=XMJSONPath.readPath(dataApi.getApi_response(), "$.result.latestSnapshotId");

        //会员购买体验卡
        orderTools.signOrder1(memberCardId,latestSnapshotId,quantity,entryQuantity,price,entryPrice,validPeriod,latestSnapshotId,0,"FIRST_USED","EXPERIENCE_CARD", memberId,price+entryPrice,price+entryPrice,"1");

        //获取该会员可入场的的体验卡
        String entryVoucherId = entryTool.listUserVenueEntryCard("EXPERIENCE",memberId).getJSONArray("result").getJSONObject(0).getString("id");

        //计算入场消耗额度
        Double value = Double.valueOf(entryTool.calQuantity(entryVoucherId,"EXPERIENCE_CARD",memberId).getString("result"));
        Assert.assertEquals(value,1.00);

        //添加入场记录
        JSONObject object = new JSONObject();
        object.put("entryVoucherType","EXPERIENCE_CARD");
        object.put("memberId",memberId);
        object.put("entryVoucherId",entryVoucherId);
        object.put("remark","自动化脚本手动添加入场记录备注-体验卡");
        object.put("studioId",xmAppApi.getLoginInfo().getStudioId());
        object.put("brandId",xmAppApi.getLoginInfo().getBrandId());
        object.put("operatorId",xmAppApi.getLoginInfo().getAdminId());

        xmAppApi.doRequest(RequestType.JSON,params,object.toString(),headers).assetsSuccess(true);

        String id = XMJSONPath.readPath(xmAppApi.getBodyInJSON(),"$.result");
        Assert.assertEquals(entryTool.memberEntryPage("MEMBER").getJSONObject("result").getJSONArray("records").getJSONObject(0).getString("id"),id);

        JSONObject res = entryTool.getMemberEntry(id).getJSONObject("result");
        Assert.assertEquals(res.getString("memberId"),memberId);
        Assert.assertEquals(res.getString("entryType"),"MEMBER");
        Assert.assertEquals(res.getString("entryMethod"),"MANUAL");
        Assert.assertEquals(res.getString("entryVoucherType"),"EXPERIENCE_CARD");
        Assert.assertEquals(res.getString("entryVoucherId"),entryVoucherId);
        Assert.assertEquals(res.getString("operatorId"),xmAppApi.getLoginInfo().getAdminId());


        //获取入场的体验卡剩余的剩余入场权益
        cardTools.getUserMemberCardList(memberId,"EXPERIENCE");
        String memberAccountCardId = "";
        memberAccountCardId = XMJSONPath.readPath(dataApi.getApi_response(), "$.result[0].id");

        //获取体验卡售卖记录详情
        JSONObject res1 = cardTools.memberCardFindDetailById(memberAccountCardId);
        BigDecimal entryQuantity1 = new BigDecimal(XMJSONPath.readPath(res1, "$.result.venueBenefit.leftPurchaseBalance"));
        Float entryPrice1 = Float.valueOf(XMJSONPath.readPath(res1, "$.result.venueBenefit.leftBenefitAmount"));

        String ownerName=adminTools.getStudioAdmin(xmAppApi.getLoginInfo().getAdminId()).getJSONObject("result").getString("nickName");

        //操作退卡
        orderTools.refundOrder1(xmAppApi.getLoginInfo().getAdminId(),ownerName,2, 1,entryVoucherId, quantity, entryQuantity1,price, entryPrice1,"EXPERIENCE_CARD", memberId, "1",0,new BigDecimal(price+entryPrice1),new BigDecimal(price+entryPrice1));

    }
}
