package com.xiaomai.cases.polar.finance.salary;

import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import com.xiaomai.basetest.BaseTestImpl;
import com.xiaomai.enums.ApiModule;
import com.xiaomai.enums.LoginAccount;
import com.xiaomai.enums.RequestType;
import com.xiaomai.enums.Terminal;
import com.xiaomai.utils.TimeUtils;
import org.testng.Assert;
import org.testng.annotations.BeforeMethod;
import org.testng.annotations.DataProvider;
import org.testng.annotations.Test;

/**
 * @BelongsProject: xm-sportstest
 * @BelongsPackage: com.xiaomai.cases.polar.finance.salary
 * @Author: xuyamei
 * @CreateTime: 2024-11-07  10:29
 * @Description: 新建工资模版
 * @Version: 1.0
 */
public class TestSettleTemplateCreateOrUpdate extends BaseTestImpl {
    SalaryTools salaryTools = new SalaryTools();
    private String id;
    @BeforeMethod
    @Override
    public void beforeTest(){
        setTestInfo(ApiModule.Polar_Salary,"API_settleTemplate_create", LoginAccount.GYM_PROD, Terminal.B,"xym");
        super.beforeTest();
    }


    @DataProvider
    public Object[][] dataProvider(){
        // 上课绩效工资+所有课程类型统一计算：主教练、助教统一计算   按上课次数无梯度计算
        String coachRule1 = "{\"method\": \"UNIFIED\",\"rules\": {\"ALL\": [{\"dimension\": \"SCHED_COUNT\",\"gradientType\": \"NONE\",\"amount\": 200,\"role\": \"COACH\"}]}}";
        // 上课绩效工资+所有课程类型统一计算：主教练、助教统一计算   按上课次数梯度超额累计计算
        String coachRule2 = "{\"method\":\"UNIFIED\",\"rules\":{\"ALL\":[{\"role\":\"COACH\",\"dimension\":\"SCHED_COUNT\",\"gradientType\":\"OVER_ACCUMULATE\",\"gradientList\":[{\"bottom\":0,\"amount\":100},{\"bottom\":2,\"amount\":200},{\"bottom\":3,\"amount\":300},{\"bottom\":4,\"amount\":400},{\"bottom\":5,\"amount\":500},{\"bottom\":6,\"amount\":600}]}]}}";
        // 上课绩效工资+所有课程类型统一计算：主教练、助教统一计算   按上课次数梯度全额累计计算
        String coachRule3 = "{\"method\":\"UNIFIED\",\"rules\":{\"ALL\":[{\"role\":\"COACH\",\"dimension\":\"SCHED_COUNT\",\"gradientType\":\"FULL_ACCUMULATE\",\"gradientList\":[{\"bottom\":0,\"amount\":100},{\"bottom\":2,\"amount\":200},{\"bottom\":3,\"amount\":300},{\"bottom\":4,\"amount\":400},{\"bottom\":5,\"amount\":500},{\"bottom\":6,\"amount\":600}]}]}}";

        // 上课绩效工资+所有课程类型统一计算：主教练、助教统一计算   按上课次数无梯度计算
        String coachRule4 = "{\"method\": \"UNIFIED\",\"rules\": {\"ALL\": [{\"dimension\": \"HEAD_COUNT\",\"gradientType\": \"NONE\",\"amount\": 200,\"role\": \"COACH\"}]}}";
        // 上课绩效工资+所有课程类型统一计算：主教练、助教统一计算   按上课次数梯度超额累计计算
        String coachRule5 = "{\"method\":\"UNIFIED\",\"rules\":{\"ALL\":[{\"role\":\"COACH\",\"dimension\":\"HEAD_COUNT\",\"gradientType\":\"OVER_ACCUMULATE\",\"gradientList\":[{\"bottom\":0,\"amount\":100},{\"bottom\":2,\"amount\":200},{\"bottom\":3,\"amount\":300},{\"bottom\":4,\"amount\":400},{\"bottom\":5,\"amount\":500},{\"bottom\":6,\"amount\":600}]}]}}";
        // 上课绩效工资+所有课程类型统一计算：主教练、助教统一计算   按上课人数梯度全额累计计算
        String coachRule6 = "{\"method\":\"UNIFIED\",\"rules\":{\"ALL\":[{\"role\":\"COACH\",\"dimension\":\"HEAD_COUNT\",\"gradientType\":\"FULL_ACCUMULATE\",\"gradientList\":[{\"bottom\":0,\"amount\":100},{\"bottom\":2,\"amount\":200},{\"bottom\":3,\"amount\":300},{\"bottom\":4,\"amount\":400},{\"bottom\":5,\"amount\":500},{\"bottom\":6,\"amount\":600}]}]}}";

        // 上课绩效工资+所有课程类型统一计算：主教练、助教统一计算   按课消金额无梯度计算
        String coachRule7 = "{\"method\": \"UNIFIED\",\"rules\": {\"ALL\": [{\"dimension\": \"CHECK_BALANCE\",\"gradientType\": \"NONE\",\"amount\": 0.11,\"role\": \"COACH\"}]}}";
        // 上课绩效工资+所有课程类型统一计算：主教练、助教统一计算   按课消金额梯度超额累计计算
        String coachRule8 = " {\"method\": \"UNIFIED\",\"rules\": {\"ALL\": [{\"role\": \"COACH\",\"dimension\": \"CHECK_BALANCE\",\"gradientType\": \"OVER_ACCUMULATE\",\"gradientList\": [{\"bottom\": 0,\"amount\": 0.1}, {\"bottom\": 2000,\"amount\": 0.2}, {\"bottom\": 3000,\"amount\": 0.3}, {\"bottom\": 4000,\"amount\": 0.4}, {\"bottom\": 5000,\"amount\": 0.5}, {\"bottom\": 6000,\"amount\": 0.6}]}]}}";
        // 上课绩效工资+所有课程类型统一计算：主教练、助教统一计算   按课消金额梯度全额累计计算
        String coachRule9 = " {\"method\": \"UNIFIED\",\"rules\": {\"ALL\": [{\"role\": \"COACH\",\"dimension\": \"CHECK_BALANCE\",\"gradientType\": \"FULL_ACCUMULATE\",\"gradientList\": [{\"bottom\": 0,\"amount\": 0.1}, {\"bottom\": 2000,\"amount\": 0.2}, {\"bottom\": 3000,\"amount\": 0.3}, {\"bottom\": 4000,\"amount\": 0.4}, {\"bottom\": 5000,\"amount\": 0.5}, {\"bottom\": 6000,\"amount\": 0.6}]}]}}";

        // 上课绩效工资+所有类型统一计算：主教和助教分开计算，主教按照上课次数，无梯度计算  助教按照上课人数无梯度计算
        String coachRule10 = "{\"method\": \"UNIFIED\",\"rules\": {\"ALL\": [{\"dimension\": \"SCHED_COUNT\",\"gradientType\": \"NONE\",\"amount\": 20,\"role\": \"CHIEF\"}, {\"dimension\":\"HEAD_COUNT\",\"gradientType\": \"NONE\",\"amount\": 30,\"role\": \"ASSISTANT\"}]}}";
        // 上课绩效工资+所有类型统一计算：主教和助教分开计算，主教按照课消金额全额累计  助教按照上课人数超额累计计算
        String coachRule11 = "{\"method\":\"UNIFIED\",\"rules\":{\"ALL\":[{\"role\":\"CHIEF\",\"dimension\":\"CHECK_BALANCE\",\"gradientType\":\"FULL_ACCUMULATE\",\"gradientList\":[{\"amount\":0.1001,\"bottom\":0},{\"amount\":0.2001,\"bottom\":1000}]},{\"role\":\"ASSISTANT\",\"dimension\":\"HEAD_COUNT\",\"gradientType\":\"OVER_ACCUMULATE\",\"gradientList\":[{\"amount\":255,\"bottom\":0},{\"amount\":355,\"bottom\":10}]}]}}";

        // 上课绩效工资+不同课程类型分开计算： 主教和助教统一计算, 团课按照上课次数无梯度、私教按上课人数超额累计计算、训练营按课消金额，全额累计结算
        String coachRule12 = "{\"method\":\"SEPARATE\",\"rules\":{\"GROUP_CLASS\":[{\"dimension\":\"SCHED_COUNT\",\"gradientType\":\"NONE\",\"amount\":200,\"role\":\"COACH\"}],\"PERSONAL\":[{\"dimension\":\"HEAD_COUNT\",\"gradientType\":\"OVER_ACCUMULATE\",\"role\":\"COACH\",\"gradientList\":[{\"amount\":50,\"bottom\":0},{\"amount\":100,\"bottom\":1},{\"amount\":150,\"bottom\":2}]}],\"TRAINING_CAMP\":[{\"dimension\":\"CHECK_BALANCE\",\"gradientType\":\"FULL_ACCUMULATE\",\"role\":\"COACH\",\"gradientList\":[{\"amount\":0.1,\"bottom\":0},{\"amount\":0.2,\"bottom\":1000},{\"amount\":0.3,\"bottom\":3008}]}]}}";

        // 销售绩效工资+所有商品类型统一计算：按照销售金额无梯度计算
        String saleRule1 = "{\"method\":\"UNIFIED\",\"rules\":{\"ALL\":{\"gradientType\":\"NONE\",\"amount\":0.02}}}";

        // 销售绩效工资+所有商品类型统一计算：按照销售金额超额计算
        String saleRule2 = "{\"method\":\"UNIFIED\",\"rules\":{\"ALL\":{\"gradientType\":\"OVER_ACCUMULATE\",\"gradientList\":[{\"bottom\":0,\"amount\":0.1},{\"bottom\":1000,\"amount\":0.2},{\"bottom\":2000,\"amount\":0.25},{\"bottom\":3000,\"amount\":0.3},{\"bottom\":4000,\"amount\":0.4},{\"bottom\":5000,\"amount\":0.5},{\"bottom\":6000,\"amount\":0.6},{\"bottom\":7000,\"amount\":0.7},{\"bottom\":8000,\"amount\":0.8},{\"bottom\":9000,\"amount\":0.9}]}}}";
        // 销售绩效工资+所有商品类型统一计算：按照销售金额全额累计计算
        String saleRule3 = "{\"method\":\"UNIFIED\",\"rules\":{\"ALL\":{\"gradientType\":\"FULL_ACCUMULATE\",\"gradientList\":[{\"bottom\":0,\"amount\":0.1},{\"bottom\":1000,\"amount\":0.2},{\"bottom\":2000,\"amount\":0.25},{\"bottom\":3000,\"amount\":0.3},{\"bottom\":4000,\"amount\":0.4},{\"bottom\":5000,\"amount\":0.5},{\"bottom\":6000,\"amount\":0.6},{\"bottom\":7000,\"amount\":0.7},{\"bottom\":8000,\"amount\":0.8},{\"bottom\":9000,\"amount\":0.9}]}}}";
        // 销售绩效工资+不同商品类型分开计算：会员卡无梯度、体验卡超额累计、储值卡全额累计计算、训练营物体度
        String saleRule4 = "{\"method\":\"SEPARATE\",\"rules\":{\"MEMBER_CARD\":{\"gradientType\":\"NONE\",\"amount\":0.02},\"EXPERIENCE_CARD\":{\"gradientType\":\"OVER_ACCUMULATE\",\"gradientList\":[{\"amount\":0.1,\"bottom\":0},{\"amount\":0.2,\"bottom\":2000},{\"amount\":0.21,\"bottom\":3000},{\"amount\":0.22,\"bottom\":4000},{\"amount\":0.23,\"bottom\":5000},{\"amount\":0.24,\"bottom\":6000},{\"amount\":0.25,\"bottom\":7000},{\"amount\":0.26,\"bottom\":8000},{\"amount\":0.27,\"bottom\":9000},{\"amount\":0.28,\"bottom\":10000}]},\"DEPOSIT_CARD\":{\"gradientType\":\"FULL_ACCUMULATE\",\"gradientList\":[{\"amount\":0.1,\"bottom\":0},{\"amount\":0.15,\"bottom\":1500},{\"amount\":0.25,\"bottom\":2500},{\"amount\":0.35,\"bottom\":3500},{\"amount\":0.45,\"bottom\":4500},{\"amount\":0.5,\"bottom\":5000}]},\"TRAINING_CAMP\":{\"gradientType\":\"NONE\",\"amount\":0.1}}}";


        return new Object[][]{
                {JSONObject.parseObject(coachRule1),JSONObject.parseObject(saleRule1),true},
                {JSONObject.parseObject(coachRule2),JSONObject.parseObject(saleRule2),true},
                {JSONObject.parseObject(coachRule3),JSONObject.parseObject(saleRule3),true},
                {JSONObject.parseObject(coachRule4),JSONObject.parseObject(saleRule4),true},
                {JSONObject.parseObject(coachRule5),JSONObject.parseObject(saleRule1),true},
                {JSONObject.parseObject(coachRule6),JSONObject.parseObject(saleRule2),true},
                {JSONObject.parseObject(coachRule7),JSONObject.parseObject(saleRule3),true},
                {JSONObject.parseObject(coachRule8),JSONObject.parseObject(saleRule4),true},
                {JSONObject.parseObject(coachRule9),JSONObject.parseObject(saleRule4),false},
                {JSONObject.parseObject(coachRule10),JSONObject.parseObject(saleRule1),true},
                {JSONObject.parseObject(coachRule11),JSONObject.parseObject(saleRule2),true},
                {JSONObject.parseObject(coachRule12),JSONObject.parseObject(saleRule3),false},
        };
    }


    @Test(dataProvider = "dataProvider")
    public void testSettleTemplateCreate(JSONObject coachSettleRule,JSONObject saleSettleRule,boolean flag) throws InterruptedException {
        // 新建模版时先查询员工是否有工资模版，有则删除
        JSONArray pageOfTemplate = salaryTools.fetchPageOfTemplate(xmAppApi.getLoginInfo().getAdminId());
        if (pageOfTemplate.size() > 0){
            salaryTools.deleteTemplate(pageOfTemplate.getJSONObject(0).getString("id"));
        }
        Thread.sleep(2500);


        JSONArray adminIds = new JSONArray();
        adminIds.add(xmAppApi.getLoginInfo().getAdminId());
        String title = "工资结算模版"+ TimeUtils.getCurrentTime();
        JSONObject jsonObject = new JSONObject();
        jsonObject.put("brandId",xmAppApi.getLoginInfo().getBrandId());
        jsonObject.put("studioId",xmAppApi.getLoginInfo().getStudioId());
        jsonObject.put("operatorId",xmAppApi.getLoginInfo().getAdminId());
        jsonObject.put("adminIds",adminIds);
        jsonObject.put("title",title);
        jsonObject.put("id","");

        JSONArray settleItemList = new JSONArray();

        for (int i = 0; i < 3; i++) {
            JSONObject settleItem = new JSONObject();
            switch (i) {
                case 0: // 底薪
                    settleItem.put("settleItemId", "1");
                    settleItem.put("settleItemTitle", "底薪");
                    settleItem.put("adjustType", "PLUS");
                    settleItem.put("settleRuleType", "FIXED_AMOUNT"); // 固定金额
                    settleItem.put("fixedAmount", 123.01);
                    settleItemList.add(settleItem);
                    break;
                case 1:
                    if (!coachSettleRule.toString().equals("")) {
                        settleItem.put("settleItemId", "2");
                        settleItem.put("settleItemTitle", "上课绩效工资");
                        settleItem.put("adjustType", "PLUS");
                        settleItem.put("settleRuleType", "COACH_PERFORMANCE"); //上课绩效工资
                        settleItem.put("coachSettleRule", coachSettleRule);
                        settleItemList.add(settleItem);
                    }
                    break;
                case 2:
                    if (!saleSettleRule.toString().equals("")) {
                        settleItem.put("settleItemId", "3");
                        settleItem.put("settleItemTitle", "销售绩效工资");
                        settleItem.put("adjustType", "PLUS");
                        settleItem.put("settleRuleType", "SALE_PERFORMANCE"); //销售绩效工资
                        settleItem.put("saleSettleRule", saleSettleRule);
                        settleItemList.add(settleItem);
                    }
                    break;

            }

        }
        jsonObject.put("settleItemList",settleItemList);
        xmAppApi.doRequest(RequestType.JSON,params,jsonObject.toJSONString(),headers).assetsSuccess(true);

        id = xmAppApi.getBodyInJSON().getJSONObject("result").getString("templateId");
        Thread.sleep(1000);
        // check 1：工资模版有该条数据
        pageOfTemplate = salaryTools.fetchPageOfTemplate(xmAppApi.getLoginInfo().getAdminId());
        Assert.assertEquals(id,pageOfTemplate.getJSONObject(0).getString("id"),"创建工资结算模版失败");
        // check 2：工资详情页面的数据与新建的内容一致
        JSONObject detail = salaryTools.findDetailById(id);
        String resultTitle = detail.getString("title");
        Assert.assertEquals(resultTitle,title,"新建的工资模版名称与详情不一致");

        String resultAdminIds = detail.getJSONArray("adminIds").toString();
        Assert.assertEquals(resultAdminIds,adminIds.toString(),"新建的工资模版适用员工与详情不一致");

        JSONArray resultSettleItemList = detail.getJSONArray("settleItemList");// 返回的工资条项目参数
        JSONArray expectSettleItemList = jsonObject.getJSONArray("settleItemList"); // 传参的工资条项目参数
        JSONObject json1 = new JSONObject();
        json1.put("settleItemId", resultSettleItemList);
        JSONObject json2 = new JSONObject();
        json2.put("settleItemId", expectSettleItemList);
        if (flag){ // 分开计算后端返回的顺序与前端不一致，所以分开计算不校验
            Assert.assertEquals(json1.toString(),json2.toString(),"新建的工资模版结算项目与详情不一致");
        }

    }

    @Test(dataProvider = "dataProvider",priority = 1)
    public void testUpdateSettleTemplate(JSONObject coachSettleRule,JSONObject saleSettleRule,boolean flag) throws InterruptedException {

        JSONArray adminIds = new JSONArray();
        adminIds.add(xmAppApi.getLoginInfo().getAdminId());
        // 查询未设置工资模版的员工
        JSONArray staffList = salaryTools.fetchStaff(false,"",id);
        String adminId = staffList.size() >2 ? staffList.getJSONObject(1).getString("id") : "";
        if (!adminId.equals("")){
            adminIds.add(adminId);
        }

        String title = "编辑工资结算模版"+TimeUtils.getCurrentTime();
        JSONObject jsonObject = new JSONObject();
        jsonObject.put("brandId",xmAppApi.getLoginInfo().getBrandId());
        jsonObject.put("studioId",xmAppApi.getLoginInfo().getStudioId());
        jsonObject.put("operatorId",xmAppApi.getLoginInfo().getAdminId());
        jsonObject.put("adminIds",adminIds);
        jsonObject.put("title",title);
        jsonObject.put("id",id);

        JSONArray settleItemList = new JSONArray();

        for (int i = 0; i < 3; i++) {
            JSONObject settleItem = new JSONObject();
            switch (i) {
                case 0: // 底薪
                    settleItem.put("settleItemId", "1");
                    settleItem.put("settleItemTitle", "底薪");
                    settleItem.put("adjustType", "PLUS");
                    settleItem.put("settleRuleType", "FIXED_AMOUNT"); // 固定金额
                    settleItem.put("fixedAmount", 9770.01);
                    settleItemList.add(settleItem);
                    break;
                case 1:
                    if (!coachSettleRule.toString().equals("")) {
                        settleItem.put("settleItemId", "2");
                        settleItem.put("settleItemTitle", "上课绩效工资");
                        settleItem.put("adjustType", "PLUS");
                        settleItem.put("settleRuleType", "COACH_PERFORMANCE"); //上课绩效工资
                        settleItem.put("coachSettleRule", coachSettleRule);
                        settleItemList.add(settleItem);
                    }
                    break;
                case 2:
                    if (!saleSettleRule.toString().equals("")) {
                        settleItem.put("settleItemId", "3");
                        settleItem.put("settleItemTitle", "销售绩效工资");
                        settleItem.put("adjustType", "PLUS");
                        settleItem.put("settleRuleType", "SALE_PERFORMANCE"); //销售绩效工资
                        settleItem.put("saleSettleRule", saleSettleRule);
                        settleItemList.add(settleItem);
                    }
                    break;

            }

        }
        jsonObject.put("settleItemList",settleItemList);
        salaryTools.updateTemplate(jsonObject);
        Thread.sleep(1000);

        // check 1：工资详情页面的数据与新建的内容一致
        JSONObject detail = salaryTools.findDetailById(id);
        String resultTitle = detail.getString("title");
        Assert.assertEquals(resultTitle,title,"编辑工资模版名称与详情不一致");

        String resultAdminIds = detail.getJSONArray("adminIds").toString();
        Assert.assertEquals(resultAdminIds,adminIds.toString(),"编辑工资模版适用员工与详情不一致");


        JSONArray resultSettleItemList = detail.getJSONArray("settleItemList"); // 返回的工资条项目参数
        JSONArray expectSettleItemList = jsonObject.getJSONArray("settleItemList");// 传参的工资条项目参数
        System.out.println(resultSettleItemList);
        System.out.println(expectSettleItemList);
        JSONObject json1 = new JSONObject();
        json1.put("settleItemId", resultSettleItemList);
        JSONObject json2 = new JSONObject();
        json2.put("settleItemId", expectSettleItemList);
        if (flag){ // 分开计算后端返回的顺序与前端不一致，所以分开计算不校验
            Assert.assertEquals(json1.toString(),json2.toString(),"编辑的工资模版结算项目与详情不一致");
        }
    }

//    @Test(priority = 2)
//    public void testDeleteTemplate() {
//        salaryTools.deleteTemplate(id);
//        try {
//            Thread.sleep(2500);
//        } catch (InterruptedException e) {
//            throw new RuntimeException(e);
//        }
//        // check 1：工资模版有该条数据
//        JSONArray pageOfTemplate = salaryTools.fetchPageOfTemplate(xmAppApi.getLoginInfo().getAdminId());
//        Assert.assertTrue(pageOfTemplate.size()==0,"工资模版删除失败");
//
//    }
}
