package com.xiaomai.cases.polar.reserve.personal;

import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import com.xiaomai.basetest.BaseTestImpl;
import com.xiaomai.cases.polar.reserve.ReserveTools;
import com.xiaomai.enums.ApiModule;
import com.xiaomai.enums.LoginAccount;
import com.xiaomai.enums.Terminal;
import org.testng.Assert;
import org.testng.annotations.BeforeClass;
import org.testng.annotations.Test;

import javax.annotation.Resource;
import java.util.Arrays;

/**
 * @BelongsProject: xm-sportstest
 * @BelongsPackage: com.xiaomai.cases.lunar.reserve
 * @Author: xuyamei
 * @CreateTime: 2024-07-08  14:47
 * @Description: 设置常规可约时间
 * @Version: 1.0
 */
public class TestCreateNormalDate extends BaseTestImpl {
    @Resource(name = "reserveTools")
    ReserveTools reserveTools;

    @BeforeClass
    @Override
    public void beforeTest(){
        setTestInfo(ApiModule.Polar_Reserve,"API_createNormalDate", LoginAccount.GYM_PROD, Terminal.B,"xym");
        super.beforeTest();
    }


    @Test(description = "设置周一至周日 统一一个时间点")
    public void testCreateNormalDate(){
        // 设置可约时间
        JSONArray normalTimeInfoRequests = new JSONArray();
        JSONObject infoRequests = new JSONObject();
        JSONArray timePeriodInfos = new JSONArray();
        // 三个时段 5:00-12:00 12:00-18:00 18:00-23:00
        int[] minuteOffset = {300,720,1080};
        int[] spanMinutes = {420,360,300};

        for (int i = 0; i < 3; i++){
            JSONObject timeInfo = new JSONObject();
            timeInfo.put("minuteOffset",minuteOffset[i]);
            timeInfo.put("spanMinutes",spanMinutes[i]);
            timePeriodInfos.add(timeInfo);
        }
        infoRequests.put("timePeriodInfos",timePeriodInfos);

        // 每星期
        String[] weekdays = {"MONDAY", "TUESDAY", "WEDNESDAY", "THURSDAY", "FRIDAY", "SATURDAY", "SUNDAY"};
        infoRequests.put("weekdays",weekdays);
        normalTimeInfoRequests.add(infoRequests);
        // 设置常规可约时间
        reserveTools.createNormalDate(xmAppApi.getLoginInfo().getAdminId(),normalTimeInfoRequests);

        JSONArray personalCoachTime = reserveTools.getPersonalCoachTime(xmAppApi.getLoginInfo().getAdminId(),"normalTimeVOS");
        // 校验每周重复的可约时间
        Assert.assertEquals(timePeriodInfos.toString(),personalCoachTime.getJSONObject(0).getJSONArray("timePeriodInfos").toString(),"每周重复的可约时间请求结果与实际结果不一样");
        JSONArray weekDays = new JSONArray(Arrays.asList(weekdays));
        Assert.assertEquals(weekDays.toString(),personalCoachTime.getJSONObject(0).getJSONArray("weekdays").toString(),"每周重复的周请求结果与实际结果不一样");
    }

    @Test(description = "周一至周日分开设置 ")
    public void testCreateNormalDate1(){
        // 设置可约时间
        JSONArray normalTimeInfoRequests = new JSONArray();
        String[] weekdays = {"MONDAY", "TUESDAY", "WEDNESDAY", "THURSDAY", "FRIDAY", "SATURDAY", "SUNDAY"};

        for (int j = 0; j <weekdays.length;j++){
            JSONObject infoRequests = new JSONObject();
            JSONArray timePeriodInfos = new JSONArray();
            // 三个时段 5:00-12:00 12:00-18:00 18:00-23:00
            int[] minuteOffset = {300,720,1080};
            int[] spanMinutes = {420,360,300};

            for (int i = 0; i < 3; i++){
                JSONObject timeInfo = new JSONObject();
                timeInfo.put("minuteOffset",minuteOffset[i]);
                timeInfo.put("spanMinutes",spanMinutes[i]);
                timePeriodInfos.add(timeInfo);
            }
            infoRequests.put("timePeriodInfos",timePeriodInfos);

            JSONArray arr = new JSONArray();
            arr.add(weekdays[j]);
            // 每星期
            infoRequests.put("weekdays",arr);
            normalTimeInfoRequests.add(infoRequests);
        }

        // 设置常规可约时间
        reserveTools.createNormalDate(xmAppApi.getLoginInfo().getAdminId(),normalTimeInfoRequests);
        try {
            Thread.sleep(1000);
        } catch (InterruptedException e) {
            throw new RuntimeException(e);
        }

        JSONArray personalCoachTime = reserveTools.getPersonalCoachTime(xmAppApi.getLoginInfo().getAdminId(),"normalTimeVOS");
        for (int i = 0; i < personalCoachTime.size(); i++){
            // 校验每周重复的可约时间
            Assert.assertEquals(normalTimeInfoRequests.getJSONObject(i).getJSONArray("timePeriodInfos").toString(),personalCoachTime.getJSONObject(i).getJSONArray("timePeriodInfos").toString(),"每周重复的可约时间请求结果与实际结果不一样");
            Assert.assertEquals(normalTimeInfoRequests.getJSONObject(i).getJSONArray("weekdays").toString(),personalCoachTime.getJSONObject(i).getJSONArray("weekdays").toString(),"每周重复的周请求结果与实际结果不一样");

        }
    }

}
