package com.xiaomai.cases.polar.memberCard;

import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import com.xiaomai.client.DataUserInfo;
import com.xiaomai.enums.ApiModule;
import com.xiaomai.enums.RequestType;
import com.xiaomai.enums.Terminal;
import com.xiaomai.utils.RandomStringUtil;
import com.xiaomai.utils.XMBaseTest;

import java.util.ArrayList;
import java.util.List;

public class CardTools extends XMBaseTest {

    /**
     * @param
     * @description:创建会员卡
     * @author: yangjian
     **/
    public JSONObject memberCardCreate(String title, DataUserInfo...dataUserInfos) {

        dataApi.setApiModule(ApiModule.Polar_Card)
                .setApiName("API_tenantMemberCard_create")
                .setTerminal(Terminal.B);
        super.beforeDataRequest(dataUserInfos);

        JSONArray activatePatternList=new JSONArray();
        activatePatternList.add("PURCHASE");
        activatePatternList.add("SPECIFIC_DATE");
        activatePatternList.add("FIRST_USED");

        List benefitList = new ArrayList();
        //List itemList = new ArrayList();
        //itemList.add("");
        JSONObject Object = new JSONObject();
        Object.put("identifier", xmAppApi.getLoginInfo().getUser());
        Object.put("benefitType", "BALANCE");
        Object.put("targetScope", "GROUP_CLASS_COURSE");
        Object.put("balance", "30");
        Object.put("reserveLimitType", "UN_LIMIT");
        Object.put("reserveLimitNumber", 0);
        Object.put("defaultConsumeBalance", 1);
        //Object.put("itemList", itemList);
        Object.put("targetType", "COURSE");
        benefitList.add(Object);





        JSONObject jsonObject = new JSONObject();
        jsonObject.put("surfaceUrl","https://image.xiaomaiketang.com/xm/internal/HpRiJpFnTC.png");//会员卡封面图片
        jsonObject.put("surfaceCornerMark","自动化标签");
        jsonObject.put("title",title );//会员卡名称 不能重复要加东西 "次卡-自动化会员卡"+RandomStringUtil.randomString(3)
        jsonObject.put("validPeriod", "3");//有效期-3天
        jsonObject.put("activatePatternList", activatePatternList);//三种生效方式
        jsonObject.put("sharePeopleLimit", "2");//共享人数
        jsonObject.put("benefitList", benefitList);//使用权益
        jsonObject.put("price", "1");//价格
        jsonObject.put("underlinePrice", "10");//划线价
        jsonObject.put("purchaseNumberLimit", "-1");//购买数量限制
        jsonObject.put("xcxSaleStatus", "YES");//小程序是否售卖
        jsonObject.put("creatorId", xmAppApi.getLoginInfo().getAdminId());
        jsonObject.put("shelfState", "YES");//卡启用状态
        jsonObject.put("brandId", xmAppApi.getLoginInfo().getBrandId());
        jsonObject.put("studioId", xmAppApi.getLoginInfo().getStudioId());
        jsonObject.put("description", "{\"items\":[{\"content\":\"自动化创建的卡\",\"aspect\":\"\",\"type\":\"TEXT\"}]}");
        jsonObject.put("operatorId", xmAppApi.getLoginInfo().getAdminId());




        dataApi.doRequest(RequestType.JSON, dataparams, jsonObject.toJSONString(), dataheadrs).assetsSuccess(true);
        JSONObject response=dataApi.getBodyInJSON();
        return response;
    }

/**
 * @param
 * @description:会员卡列表
 * @author: yangjian
 **/
public JSONObject fetchPageOfMemberCard(DataUserInfo...dataUserInfos) {

    dataApi.setApiModule(ApiModule.Polar_Card)
            .setApiName("API_fetchPageOfMemberCard")
            .setTerminal(Terminal.B);
    super.beforeDataRequest(dataUserInfos);

    JSONObject jsonObject = new JSONObject();
    //jsonObject.put("shelfState",shelfState);//启用状态
    //jsonObject.put("xcxSaleStatus",xcxSaleStatus);//售卖状态
    jsonObject.put("current",0);
    jsonObject.put("size",20);
    jsonObject.put("studioId", xmAppApi.getLoginInfo().getStudioId());
    jsonObject.put("brandId", xmAppApi.getLoginInfo().getBrandId());
    jsonObject.put("operatorId", xmAppApi.getLoginInfo().getAdminId());
    dataApi.doRequest(RequestType.JSON, dataparams, jsonObject.toJSONString(), dataheadrs).assetsSuccess(true);
    JSONObject response=dataApi.getBodyInJSON();
    return response;
}

/**
 * @param
 * @description:会员卡搜索
 * @author: yangjian
 **/
public JSONObject testMemberCardcommonSearch(String title, DataUserInfo...dataUserInfos) {

    dataApi.setApiModule(ApiModule.Polar_Card)
            .setApiName("API_commonSearch")
            .setTerminal(Terminal.B);
    super.beforeDataRequest(dataUserInfos);

    JSONObject jsonObject = new JSONObject();
    jsonObject.put("brandId",xmAppApi.getLoginInfo().getBrandId());
    jsonObject.put("studioId",xmAppApi.getLoginInfo().getStudioId());
    jsonObject.put("title",title);//搜索的卡名
    jsonObject.put("operatorId",xmAppApi.getLoginInfo().getAdminId());
    dataApi.doRequest(RequestType.JSON, dataparams, jsonObject.toJSONString(), dataheadrs).assetsSuccess(true);
    JSONObject response=dataApi.getBodyInJSON();
    return response;
}


/**
 * @param
 * @description:会员卡售卖记录
 * @author: yangjian
 **/
public JSONObject membercardsearch( DataUserInfo...dataUserInfos) {

    dataApi.setApiModule(ApiModule.Polar_Card)
            .setApiName("API_membercard_search")
            .setTerminal(Terminal.B);
    super.beforeDataRequest(dataUserInfos);

    JSONObject jsonObject = new JSONObject();

    jsonObject.put("current",0);
    jsonObject.put("size",20);
    jsonObject.put("studioId", xmAppApi.getLoginInfo().getStudioId());
    jsonObject.put("brandId", xmAppApi.getLoginInfo().getBrandId());
    jsonObject.put("operatorId", xmAppApi.getLoginInfo().getAdminId());

    dataApi.doRequest(RequestType.JSON, dataparams, jsonObject.toJSONString(), dataheadrs).assetsSuccess(true);
    JSONObject response=dataApi.getBodyInJSON();
    return response;
}

    /**
     * @param
     * @description:搜索会员卡售卖记录
     * @author: yangjian
     **/

    public JSONObject commonSearch( String content ,DataUserInfo...dataUserInfos) {

        dataApi.setApiModule(ApiModule.Polar_Clue)
                .setApiName("API_commonSearch")
                .setTerminal(Terminal.B);
        super.beforeDataRequest(dataUserInfos);

        JSONObject jsonObject = new JSONObject();

        jsonObject.put("content",content);
        jsonObject.put("studioId", xmAppApi.getLoginInfo().getStudioId());
        jsonObject.put("brandId", xmAppApi.getLoginInfo().getBrandId());
        jsonObject.put("operatorId", xmAppApi.getLoginInfo().getAdminId());

        dataApi.doRequest(RequestType.JSON, dataparams, jsonObject.toJSONString(), dataheadrs).assetsSuccess(true);
        JSONObject response=dataApi.getBodyInJSON();
        return response;
    }

    /**
     * @param
     * @description:会员卡详情
     * @author: yangjian
     **/
    public JSONObject fetchDetailById( String id ,DataUserInfo...dataUserInfos) {

        dataApi.setApiModule(ApiModule.Polar_Card)
                .setApiName("API_fetchDetailById")
                .setTerminal(Terminal.B);
        super.beforeDataRequest(dataUserInfos);

        JSONObject jsonObject = new JSONObject();

        jsonObject.put("id",id);
        jsonObject.put("studioId", xmAppApi.getLoginInfo().getStudioId());
        jsonObject.put("brandId", xmAppApi.getLoginInfo().getBrandId());
        jsonObject.put("operatorId", xmAppApi.getLoginInfo().getAdminId());

        dataApi.doRequest(RequestType.JSON, dataparams, jsonObject.toJSONString(), dataheadrs).assetsSuccess(true);
        JSONObject response=dataApi.getBodyInJSON();
        return response;
    }

        /**
         * @param
         * @description:会员卡售卖记录详情
         * @author: yangjian
         **/
        public JSONObject membercardfindDetailById( String id ,DataUserInfo...dataUserInfos) {

            dataApi.setApiModule(ApiModule.Polar_Card)
                    .setApiName("API_membercard_findDetailById")
                    .setTerminal(Terminal.B);
            super.beforeDataRequest(dataUserInfos);

            JSONObject jsonObject = new JSONObject();

            jsonObject.put("id", id);
            jsonObject.put("studioId", xmAppApi.getLoginInfo().getStudioId());
            jsonObject.put("brandId", xmAppApi.getLoginInfo().getBrandId());
            jsonObject.put("operatorId", xmAppApi.getLoginInfo().getAdminId());

            dataApi.doRequest(RequestType.JSON, dataparams, jsonObject.toJSONString(), dataheadrs).assetsSuccess(true);
            JSONObject response = dataApi.getBodyInJSON();
            return response;
        }









    }
