package com.xiaomai.cases.lunar.goods;

import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import com.xiaomai.client.DataUserInfo;
import com.xiaomai.enums.ApiModule;
import com.xiaomai.enums.RequestType;
import com.xiaomai.enums.Terminal;
import com.xiaomai.utils.XMBaseTest;

public class GoodCTools extends XMBaseTest {

    /**
     * @param
     * @description:C端获取物品列表
     * @author: yff
     **/

    public JSONObject pageXcxHomeGoods_C(DataUserInfo...userInfos){
        dataApi.setApiModule(ApiModule.Lunar_Goods)
                .setApiName("API_pageXcxHomeGoods_C")
                .setTerminal(Terminal.C);

        super.beforeDataRequest(userInfos);

        JSONObject jsonObject = new JSONObject();

        jsonObject.put("current", 0);
        jsonObject.put("size", 20);
        jsonObject.put("studioId", dataApi.getLoginInfo().getStudioId());
        JSONArray jsonArray=new JSONArray();
        jsonObject.put("ids",jsonArray);

        dataApi.doRequest(RequestType.JSON,dataparams,jsonObject.toString(),dataheadrs).assetsSuccess(true);
        return dataApi.getBodyInJSON();
    }

    /**
     * @param
     * @description:获取C端的物品详情
     * @param id：物品ID
     * @author: yff
     **/

    public JSONObject getDetail_goods_C(String id, DataUserInfo...userInfos){
        dataApi.setApiModule(ApiModule.Lunar_Goods)
                .setApiName("API_getDetail_goods_C")
                .setTerminal(Terminal.C);

        super.beforeDataRequest(userInfos);

        JSONObject jsonObject = new JSONObject();

        jsonObject.put("id",id);

        dataApi.doRequest(RequestType.JSON,dataparams,jsonObject.toString(),dataheadrs).assetsSuccess(true);
        return dataApi.getBodyInJSON();
    }

}
