package com.xiaomai.cases.polar.coupon;

import com.alibaba.fastjson.JSONObject;
import com.xiaomai.basetest.BaseTestImpl;
import com.xiaomai.cases.polar.member.Tools;
import com.xiaomai.cases.polar.training.TrainingTools;
import com.xiaomai.enums.ApiModule;
import com.xiaomai.enums.LoginAccount;
import com.xiaomai.enums.RequestType;
import com.xiaomai.enums.Terminal;
import com.xiaomai.utils.RandomStringUtil;
import com.xiaomai.utils.XMJSONPath;
import org.testng.Assert;
import org.testng.annotations.BeforeClass;
import org.testng.annotations.Test;

import javax.annotation.Resource;
import java.util.ArrayList;
import java.util.List;

/**
 * 测试定向发放优惠券
 *
 * @author adu
 * data 2024/7/27 17:16
 */

public class TestBatchSendCouponToMember extends BaseTestImpl {
    @Resource(name = "couponTools")
    CouponTools couponTools;
    String memberId = "";
    @Resource(name = "tools")
    Tools tools;

    @Resource(name = "trainingTools")
    TrainingTools trainingTools;
    String title = "";
    String couponId = "";

    @BeforeClass
    public void beforeTest() {
        setTestInfo(ApiModule.Polar_Coupon, "API_batchSendCoupon", LoginAccount.ADU_PROD, Terminal.B, "adu");
        super.beforeTest();
    }

    @Test(description = "定向发放优惠券 to 会员")
    public void testBatchSendCouponToMember() throws InterruptedException {
        //1.创建1个新的优惠券
        List<String> memberStatusLimits = new ArrayList<>();
        memberStatusLimits.add("POTENTIAL");
        memberStatusLimits.add("NORMAL");
        memberStatusLimits.add("HISTORY");
        title = "有门槛限领适用全部" + RandomStringUtil.randomString(3);
        couponId = couponTools.createCoupon("THRESHOLD", "FIXED", memberStatusLimits, title, true,
                "CERTAIN", 2, "RELATIVE", title + "优惠方式选择金额，满10元可以减10元，领取后1天内有效");
        //2.创建成功后，列表增加一条刚新建的优惠券，搜索可领取优惠券
        couponTools.getStudioCouponList("", "CLAIMABLE");
        Long goalData = XMJSONPath.getJSONArrayByReadPath(dataApi.getApi_response(), "$.result.records").toJavaList(JSONObject.class).stream().filter(e ->
                e.getString("id").equals(couponId)).count();
        Assert.assertTrue(goalData == 1, "刚创建的优惠券在列表中搜索，后端没返回数据");

        //3.查看优惠券详情，check 优惠券的总数量，剩余数量，已发放数量
        couponTools.getCouponDetail(couponId);
        int quantityBefore = Integer.valueOf(XMJSONPath.readPath(dataApi.getApi_response(), "$.result.quantity"));
        int inventoryBefore = Integer.valueOf(XMJSONPath.readPath(dataApi.getApi_response(), "$.result.inventory"));
        int receivedBefore = Integer.valueOf(XMJSONPath.readPath(dataApi.getApi_response(), "$.result.received"));

        //4.操作定向发放优惠券
        //搜索目标会员
        String phone = "17682302508";
        memberId = trainingTools.searchTargerMember(phone);
        if (memberId.isEmpty()) {
            memberId = tools.create("测试机吴彦祖", phone).getString("result");
        }
        JSONObject body = new JSONObject();
        List<String> receiverIds = new ArrayList<>();
        receiverIds.add(memberId);
        body.put("operatorId", xmAppApi.getLoginInfo().getAdminId());
        body.put("studioId", xmAppApi.getLoginInfo().getStudioId());
        body.put("brandId", xmAppApi.getLoginInfo().getBrandId());
        body.put("couponId", couponId);
        body.put("receiverIds", receiverIds);
        xmAppApi.doRequest(RequestType.JSON, params, body.toString(), headers).assetsSuccess(true);
        String taskId = XMJSONPath.readPath(xmAppApi.getApi_response(), "$.result");

        //check任务中心生成一条任务
        Thread.sleep(2000);
        couponTools.getStudioBatchTaskPage();
        Long goalTask = XMJSONPath.getJSONArrayByReadPath(dataApi.getApi_response(), "$.result.records").toJavaList(JSONObject.class).stream().filter(e ->
                e.getString("id").equals(taskId)).count();
        Assert.assertTrue(goalTask == 1, "刚操作的定向发放优惠券给学员，在任务中心查看，后端没返回目标数据");

        XMJSONPath.getJSONArrayByReadPath(dataApi.getApi_response(), "$.result.records").toJavaList(JSONObject.class).stream().filter(e ->
                e.getString("id").equals(taskId)).forEach(object ->
                Assert.assertTrue(object.getInteger("totalNumber") == 1 && object.getInteger("failNumber") == 0 &&
                        object.getInteger("successNumber") == 1));

        //查看详情
        couponTools.getCouponDetail(couponId);
        Assert.assertTrue(Integer.valueOf(XMJSONPath.readPath(dataApi.getApi_response(), "$.result.quantity"))==quantityBefore,"优惠券发放给会员后，总数量变化了，应该不变");
        Assert.assertTrue(Integer.valueOf(XMJSONPath.readPath(dataApi.getApi_response(), "$.result.inventory"))+1==inventoryBefore,"优惠券发放给会员后，剩余库存没减少");
        Assert.assertTrue(Integer.valueOf(XMJSONPath.readPath(dataApi.getApi_response(), "$.result.received"))-1==receivedBefore,"优惠券发放给会员后，已发放数据不对");





    }
}

    