package com.xiaomai.cases.polar.training;

import com.alibaba.fastjson.JSONObject;
import com.xiaomai.cases.polar.finance.order.OrderTools;
import com.xiaomai.cases.polar.member.Tools;
import com.xiaomai.cases.polar.schedule.camp.SelectTargetTrainingCampAndGetInfo;
import com.xiaomai.enums.ApiModule;
import com.xiaomai.enums.LoginAccount;
import com.xiaomai.enums.RequestType;
import com.xiaomai.enums.Terminal;
import com.xiaomai.utils.XMJSONPath;
import org.testng.Assert;
import org.testng.annotations.*;

import javax.annotation.Resource;
import java.util.ArrayList;
import java.util.List;

/**
 * 查看训练营报名记录
 *
 * @author adu
 * data 2024/7/22 17:46
 */

public class TestSearchTrainingAccountRecordsList extends SelectTargetTrainingCampAndGetInfo {
    String memberId = "";
    String orderId = "";

    @Resource(name = "orderTools")
    OrderTools orderTools;
    @Resource(name = "trainingTools")
    TrainingTools trainingTools;
    @Resource(name = "tools")
    Tools tools;

    @BeforeClass
    @Override
    public void beforeTest() {
        setTestInfo(ApiModule.Polar_Training, "API_searchTrainingAccountRecordsList", LoginAccount.ADU_PROD, Terminal.B, "adu");
        super.beforeTest();
        //搜索目标会员
        String phone = "10058121569";
        memberId = trainingTools.searchTargerMember(phone);
        if (memberId.isEmpty()) {
            memberId = tools.create("自动化报名训练营的潜在学员", phone).getString("result");
        }
        //给会员报名
        trainingTools.doSignCampOrder(memberId, this.price, this.campId);
        orderId = XMJSONPath.readPath(dataApi.getApi_response(), "$.result");

    }

    @DataProvider(name = "filterTrainingAccountRecordsByCondition")
    public Object[][] dataProvider() {
        // 报名记录状态：生效中["NORMAL"]，已结束 ["EXPIRED"]，已用尽["USED_UP"]，已退费["REFUNDED"]，已作废["DISCARD"]
        List<String> statu1 = new ArrayList<>();
        statu1.add("NORMAL");//生效中
        List<String> statu2 = new ArrayList<>();
        statu2.add("EXPIRED");//已结束
        List<String> statu3 = new ArrayList<>();
        statu3.add("USED_UP");//已用尽
        List<String> statu4 = new ArrayList<>();
        statu4.add("REFUNDED");//已退费
        List<String> statu5 = new ArrayList<>();
        statu5.add("DISCARD");//已作废

        return new Object[][]{
                {"", "", new ArrayList<>(), 1},//无筛选条件
                {"", "B_OFF_LINE", new ArrayList<>(), 1},//根据来源搜索-线下办理（B_OFF_LINE）
                {"", "C_ON_LINE", new ArrayList<>(), 0},//根据来源搜索-上线购买（C_ON_LINE）
                {"", "", statu1, 1},//根据报名记录状态（生效中）搜索
                {"", "", statu2, 0},//根据报名记录状态（已结束）搜索
                {"", "", statu3, 0},//根据报名记录状态（已用尽）搜索
                {"", "", statu4, 1},//根据报名记录状态（已退费）搜索
                {"", "", statu5, 0},//根据报名记录状态（已作废）搜索
                {"", "C_ON_LINE", statu1, 0},//线上售卖，报名记录生效中
                {"", "B_OFF_LINE", statu1, 1},//线下售卖，报名记录生效中搜索
                {this.campId, "", statu1, 1},//根据训练营和生效中
                {this.campId, "B_OFF_LINE", new ArrayList<>(), 1},//根据训练和线下售卖

        };
    }

    @Test(dataProvider = "filterTrainingAccountRecordsByCondition", description = "查看训练营报名记录")
    public void testSearchTrainingAccountRecordsList(String campId, String purchaseChannel, List<String> memberCardState, int flag) {
        JSONObject body = new JSONObject();
        body.put("operatorId", xmAppApi.getLoginInfo().getAdminId());
        body.put("studioId", xmAppApi.getLoginInfo().getStudioId());
        body.put("brandId", xmAppApi.getLoginInfo().getBrandId());
        body.put("accountType", "TRAINING");
        body.put("current", 0);
        body.put("size", 20);
        if (!campId.isEmpty()) {
            body.put("tenantMemberCardId", campId);
        }
        if (!purchaseChannel.isEmpty()) {
            body.put("purchaseChannel", purchaseChannel);
        }

        body.put("memberCardStateList", memberCardState);
        xmAppApi.doRequest(RequestType.JSON, params, body.toString(), headers).assetsSuccess(true);
        //有存量数据，理论上每个查询都会至少有1条数据
        Assert.assertTrue(XMJSONPath.getJSONArrayByReadPath(xmAppApi.getApi_response(), "$.result.records").size() >= flag, "没有搜索到相关数据");

    }

    @AfterTest(description = "删除此case创建的训练营排课日程")
    public void delData() {
        orderTools.discard(orderId,"重复录入","自动化测试作废训练营订单");
        if (null != this.campId || !this.campId.isEmpty()) {
            this.getTrainingTools().deleteTraining(this.campId);
        }

    }
}



    