package com.xiaomai.utils;

import com.alibaba.fastjson.JSONArray;
import com.xiaomai.enums.Terminal;

public class CommonRequestParameters {
    private String user;
    private String tenant;
    private String adminId;
    private String token;
    private String brandId;
    private String studioId;

    public String getCommonRequestString() {
        return null;
    }

    private JSONArray tenandInfos;

    private String accountNo;
    private String domain;

    private String wechatAppId;
    private String openId;



    public String getCommonParam(String userType) {
        if ("B".equals(userType)) {
            return "?build=1&user="+user+"&tenant="+tenant+"&adminId="+adminId+"&domain="+domain+"&sft=20.0&sfr=0.0&token="+token+"&brandId="+brandId+"&studioId="+studioId+"&sfb=0.0&version=1.0&sfl=0.0&platform=iOS";
        }else if (Terminal.minApp.equals(userType)) {
            return "?domain="+domain + "&appId=" + wechatAppId + "&token=" + token + "&openId=" + openId +"&brandId="+brandId+"&studioId="+studioId;
        } else {
            return "?";
        }
    }

    public String getUser() {
        return user;
    }

    public CommonRequestParameters setUser(String user) {
        this.user = user;
        return this;
    }

    public String getTenant() {
        return tenant;
    }

    public CommonRequestParameters setTenant(String tenant) {
        this.tenant = tenant;
        return this;
    }

    public String getAdminId() {
        return adminId;
    }

    public CommonRequestParameters setAdminId(String adminId) {
        this.adminId = adminId;
        return this;
    }

    public String getToken() {
        return token;
    }

    public CommonRequestParameters setToken(String token) {
        this.token = token;
        return this;
    }

    public String getBrandId() {
        return brandId;
    }

    public CommonRequestParameters setBrandId(String brandId) {
        this.brandId = brandId;
        return this;
    }

    public String getStudioId() {
        return studioId;
    }

    public CommonRequestParameters setStudioId(String studioId) {
        this.studioId = studioId;
        return this;
    }

    public JSONArray getTenandInfos() {
        return tenandInfos;
    }

    public CommonRequestParameters setTenandInfos(JSONArray tenandInfos) {
        this.tenandInfos = tenandInfos;
        return this;
    }

    public String getAccountNo() {
        return accountNo;
    }

    public CommonRequestParameters setAccountNo(String accountNo) {
        this.accountNo = accountNo;
        return this;
    }

    public String getDomain() {
        return domain;
    }

    public CommonRequestParameters setDomain(String domain) {
        this.domain = domain;
        return this;
    }

    public String getWechatAppId() {
        return wechatAppId;
    }
    public CommonRequestParameters setWechatAppId(String wechatAppId) {
        this.wechatAppId = wechatAppId;
        return this;
    }
    public String getOpenId() {
        return openId;
    }
    public CommonRequestParameters setOpenId(String openId) {
        this.openId = openId;
        return this;
    }
}
