package com.xiaomai.cases.polar.data.salesData;

import com.alibaba.fastjson.JSONObject;
import com.xiaomai.client.DataUserInfo;
import com.xiaomai.enums.ApiModule;
import com.xiaomai.enums.RequestType;
import com.xiaomai.enums.Terminal;
import com.xiaomai.utils.XMBaseTest;

import java.math.BigDecimal;
import java.util.Date;

public class SalesDataTools extends XMBaseTest {
    /**
     * @param
     * @description:销售数据-数据分析-汇总
     * @param dateType：时间类型：[ DAY, WEEK, MONTH, QUARTER, YEAR ]
     * @param endTime:结束时间
     * @param startTime:开始时间
     * @author: yangfangfang
     **/
    public JSONObject centerData(String dateType, long endTime, long startTime, DataUserInfo...dataUserInfos){

        dataApi.setApiModule(ApiModule.Polar_Data)
                .setApiName("API_centerData")
                .setTerminal(Terminal.B);
        super.beforeDataRequest(dataUserInfos);


        JSONObject analysis=new JSONObject();
        analysis.put("dateType",dateType);
        analysis.put("endTime", endTime);
        analysis.put("startTime",startTime);
        analysis.put("brandId",xmAppApi.getLoginInfo().getBrandId());
        analysis.put("studioId",xmAppApi.getLoginInfo().getStudioId());
        analysis.put("operatorId",xmAppApi.getLoginInfo().getAdminId());

        dataApi.doRequest(RequestType.JSON, dataparams, analysis.toJSONString(), dataheadrs).assetsSuccess(true);
        JSONObject response=dataApi.getBodyInJSON();
        return response;
    }


    /**
     * @param
     * @description:销售数据-趋势图
     * @param dateType：时间类型：[ DAY, WEEK, MONTH, QUARTER, YEAR ]
     * @param metric：时间类型：[ "新增会员数", "签单实收金额" ][ NEW_MEMBER_COUNT, SIGN_ORDER_ACTUAL_AMOUNT ]
     * @param endTime:结束时间  注意：使用这个方法只能搜按天和按月，因为参数类型这里写的long 其他几个不是long型，会用不了
     * @param startTime:开始时间
     * @author: yangfangfang
     **/
    public JSONObject trend(String dateType, String metric,long endTime, long startTime, DataUserInfo...dataUserInfos){

        dataApi.setApiModule(ApiModule.Polar_Data)
                .setApiName("API_saleDataTrend")
                .setTerminal(Terminal.B);
        super.beforeDataRequest(dataUserInfos);


        JSONObject trend=new JSONObject();
        trend.put("dateType",dateType);
        trend.put("endTime", endTime);
        trend.put("startTime", startTime);
        trend.put("metric",metric);
        trend.put("brandId",xmAppApi.getLoginInfo().getBrandId());
        trend.put("studioId",xmAppApi.getLoginInfo().getStudioId());
        trend.put("operatorId",xmAppApi.getLoginInfo().getAdminId());

        dataApi.doRequest(RequestType.JSON, dataparams, trend.toJSONString(), dataheadrs).assetsSuccess(true);
        JSONObject response=dataApi.getBodyInJSON();
        return response;
    }

}
