package com.xiaomai.cases.polar.data.salesData;

import com.alibaba.fastjson.JSONObject;
import com.xiaomai.cases.polar.clue.MemberTools;
import com.xiaomai.cases.polar.finance.order.OrderTools;
import com.xiaomai.cases.polar.memberCard.CardTools;
import com.xiaomai.enums.ApiModule;
import com.xiaomai.enums.LoginAccount;
import com.xiaomai.enums.RequestType;
import com.xiaomai.enums.Terminal;
import com.xiaomai.utils.RandomStringUtil;
import com.xiaomai.utils.TimeUtils;
import com.xiaomai.utils.XMBaseTest;
import org.testng.Assert;
import org.testng.annotations.BeforeMethod;
import org.testng.annotations.Test;

import java.math.BigDecimal;

public class TestCenterData extends XMBaseTest {

    MemberTools memberTools=new MemberTools();

    OrderTools orderTools=new OrderTools();

    CardTools cardTools=new CardTools();

    SalesDataTools salesDataTools=new SalesDataTools();

    String memberId;

    String cardId;

    String getDetailId;

    float paidAmount;

    @BeforeMethod
    public void beforeTest(){
        xmAppApi.setApiModule(ApiModule.Polar_Data)
                .setApiName("API_centerData")
                .setLoginUser(LoginAccount.GYM_PROD)
                .setTerminal(Terminal.B);

        dal.setCase_owner("yff")
                .setCase_name(Thread.currentThread().getStackTrace()[1].getFileName().split("\\.")[0]);
        super.beforeTest();
    }

    @Test(description = "销售数据-数据分析-汇总")
    public void testCenterData(){

        //先查一下当前今天的销售数据-数据分析-汇总
        JSONObject beforeAnalysis=salesDataTools.centerData("DAY",TimeUtils.getTodayEndTime(),TimeUtils.getTodayTime());
        int beforeNewMemberCount=Integer.parseInt(beforeAnalysis.getJSONObject("result").getString("newMemberCount"));//新增会员数
        float beforeActualAmount=Float.parseFloat(beforeAnalysis.getJSONObject("result").getString("actualAmount"));//签单实收金额

        try {
            Thread.sleep(1000);
        } catch (InterruptedException e) {
            throw new RuntimeException(e);
        }

        //添加线索
        String name = "创建数据中心潜在会员"+ RandomStringUtil.randomString(3);
        String phone = RandomStringUtil.randomMobile("999");
        memberId = memberTools.create(name,phone).getString("result");

        //获取会员卡信息
        //获取会员卡列表,没有则新建一个
        int cardTotal = Integer.parseInt(orderTools.fetchPageOfMemberCard("次卡").getJSONObject("result").getString("total"));
        if (cardTotal == 0) {
            cardId = cardTools.memberCardCreate("次卡-创建订单会员卡"+TimeUtils.getCurrentTime()).getString("result");
        }
        JSONObject memberCard=orderTools.fetchPageOfMemberCard("次卡");
        cardId=memberCard.getJSONObject("result").getJSONArray("records").getJSONObject(0).getString("id");
        BigDecimal quantity= new BigDecimal(memberCard.getJSONObject("result").getJSONArray("records").getJSONObject(0).getString("balance"));
        float price= Float.parseFloat(memberCard.getJSONObject("result").getJSONArray("records").getJSONObject(0).getString("price"));
        int validPeriod= Integer.parseInt(memberCard.getJSONObject("result").getJSONArray("records").getJSONObject(0).getString("validPeriod"));

        try {
            Thread.sleep(1000);
        } catch (InterruptedException e) {
            throw new RuntimeException(e);
        }

        //获取签单要用的卡快照id
        String latestSnapshotId=orderTools.fetchDetailById(cardId,xmAppApi.getLoginInfo().getBrandId(),xmAppApi.getLoginInfo().getStudioId(),xmAppApi.getLoginInfo().getAdminId()).getJSONObject("result").getString("latestSnapshotId");

        try {
            Thread.sleep(1000);
        } catch (InterruptedException e) {
            throw new RuntimeException(e);
        }

        //检查会员对该卡是否超出购买上限
        boolean limitResult=orderTools.checkAllowPurchase("MEMBER_CARD",cardId,memberId,"1",xmAppApi.getLoginInfo().getBrandId(),xmAppApi.getLoginInfo().getStudioId(),xmAppApi.getLoginInfo().getAdminId()).getBoolean("success");

        try {
            Thread.sleep(1000);
        } catch (InterruptedException e) {
            throw new RuntimeException(e);
        }

        if(limitResult == true) {

            //创建订单
            JSONObject orderResult = orderTools.signOrder(cardId, latestSnapshotId, quantity, price, validPeriod, latestSnapshotId, price / 2, "PURCHASE",
                    "MEMBER_CARD", memberId, price - price / 2, price - price / 2, "1");
            getDetailId = orderResult.getString("result");

            try {
                Thread.sleep(1000);
            } catch (InterruptedException e) {
                throw new RuntimeException(e);
            }

            //获取订单详情的实收金额
            JSONObject getDetailResult=orderTools.getDetail(getDetailId);
            paidAmount = Float.parseFloat(getDetailResult.getJSONObject("result").getString("paidAmount"));//实收金额

        }


        JSONObject analysis=new JSONObject();
        analysis.put("dateType","DAY");
        analysis.put("endTime", TimeUtils.getTodayEndTime());
        analysis.put("startTime", TimeUtils.getTodayTime());
        analysis.put("brandId",xmAppApi.getLoginInfo().getBrandId());
        analysis.put("studioId",xmAppApi.getLoginInfo().getStudioId());
        analysis.put("operatorId",xmAppApi.getLoginInfo().getAdminId());

        xmAppApi.doRequest(RequestType.JSON,params,analysis.toJSONString(),headers).assetsSuccess(true);
        JSONObject analysisResult=xmAppApi.getBodyInJSON();
        Assert.assertEquals(analysisResult.getString("success"),"true","获取销售数据-数据分析-汇总失败");
        int newMemberCount=Integer.parseInt(analysisResult.getJSONObject("result").getString("newMemberCount"));//新增会员数
        float actualAmount=Float.parseFloat(analysisResult.getJSONObject("result").getString("actualAmount"));//签单实收金额
//        BigDecimal qoqOfActualAmount=new BigDecimal(analysisResult.getJSONObject("result").getString("qoqOfActualAmount"));//签单实收金额环比
//        BigDecimal qoqOfNewMemberCount=new BigDecimal(analysisResult.getJSONObject("result").getString("qoqOfNewMemberCount"));//新增会员数环比
//        BigDecimal yoyOfActualAmount=new BigDecimal(analysisResult.getJSONObject("result").getString("yoyOfActualAmount"));//签单实收金额同比
//        BigDecimal yoyOfNewMemberCount=new BigDecimal(analysisResult.getJSONObject("result").getString("yoyOfNewMemberCount"));//新增会员数同比

        try {
            Thread.sleep(3000);
        } catch (InterruptedException e) {
            throw new RuntimeException(e);
        }

        //校验新增一个会员和签单之后销售数据-新增会员数与签单实收金额
        Assert.assertEquals(newMemberCount,beforeNewMemberCount+1,"新建一个线索之后数据分析的新增会员数未加1");
        Assert.assertEquals(actualAmount,beforeActualAmount+paidAmount,"签单完成之后，数据分析的签单实收金额未增加对应的签单实收金额");

//        //获取新增会员数的趋势图
//        JSONObject trendResult=salesDataTools.trend("DAY","NEW_MEMBER_COUNT",TimeUtils.getTodayEndTime(),TimeUtils.getTodayTime());
//        String value=trendResult.getJSONArray("result").getJSONObject(0).getJSONArray("items").getJSONObject(0).getString("value");
//        Assert.assertEquals(value,beforeNewMemberCount+1,"新建一个线索之后趋势图的新增会员数未加1");



    }
}
