package com.xiaomai.cases.polar.schedule.camp;

import com.alibaba.fastjson.JSONObject;
import com.xiaomai.cases.polar.schedule.group.GroupScheduleTools;
import com.xiaomai.enums.ApiModule;
import com.xiaomai.enums.LoginAccount;
import com.xiaomai.enums.RequestType;
import com.xiaomai.enums.Terminal;
import com.xiaomai.utils.CommUtil;
import com.xiaomai.utils.XMJSONPath;
import org.testng.Assert;
import org.testng.annotations.AfterClass;
import org.testng.annotations.BeforeClass;
import org.testng.annotations.Test;

import javax.annotation.Resource;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;

/**
 * 编辑训练营排课规则
 *
 * @author adu
 * data 2024/7/10 17:46
 */

public class TestEditCampRuleSchedule extends SelectTargetTrainingCampAndGetInfo {
    @Resource(name = "groupScheduleTools")
    GroupScheduleTools groupScheduleTools;
    @Resource(name = "campScheduleTools")
    CampScheduleTools campScheduleTools;
    String campId = "";
    String chiefCoachId = "";
    String ruldId = "";

    @BeforeClass
    public void beforeTest() {
        setTestInfo(ApiModule.Polar_Schedule, "API_editCampRuleSchedule", LoginAccount.ADU_PROD, Terminal.B, "adu");
        super.beforeTest();
    }

    @Test(description = "编辑训练营排课规则")
    public void testEditCampRuleSchedule() {
        //获取选择的训练营ID
        campId = super.campId;
        //获取训练营活动的指定教练ID
        chiefCoachId = super.chiefCoachId;

        //从训练营活动中获取助教信息
        List<String> assistCoachIds = super.assistCoachIds;

        //创建训练营排课：按日期
        campScheduleTools.oneKeyCreateCampRuleSchedule(campId, chiefCoachId, super.courseId,
                super.traineeLowerLimit, super.traineeUpperLimit,
                "1140", super.openEndDate, true,
                "");

        //查询排课日程:根据训练营和教练查询
        campScheduleTools.getCampRuleScheduleList(campId, "", chiefCoachId);
        Assert.assertTrue(XMJSONPath.getJSONArrayByReadPath(dataApi.getApi_response(), "$.result").size() == 1, "排课创建成功后，日程中没查询到对应数据");
        ruldId = XMJSONPath.getJSONArrayByReadPath(dataApi.getApi_response(), "$.result").getJSONObject(0).getString("ruleId");
        int scheduleClassHourBefore = XMJSONPath.getJSONArrayByReadPath(dataApi.getApi_response(), "$.result").getJSONObject(0).getJSONObject("campVO").getIntValue("scheduleClassHour");

        //下面要操作缩短结束日期，check
        String[] weekDaysArray = {"TUESDAY", "THURSDAY", "SATURDAY", "SUNDAY"};
        List<String> weekdaysList = Arrays.asList(weekDaysArray);
        int loopNum = campScheduleTools.queryExpectedLoopNum(CommUtil.getNDayEndTimeTamp(23), super.openEndDate, weekdaysList);

        //编辑训练营排课日程
        JSONObject body = new JSONObject();
        body.put("operatorId", xmAppApi.getLoginInfo().getAdminId());
        body.put("studioId", xmAppApi.getLoginInfo().getStudioId());
        body.put("brandId", xmAppApi.getLoginInfo().getBrandId());
        chiefCoachId = assistCoachIds.get(0).toString();
        body.put("chiefCoachId", chiefCoachId);//修改教练换人
        body.put("minMemberNum", super.traineeLowerLimit);
        body.put("maxMemberNum", super.traineeUpperLimit);
        body.put("minuteOffset", "1320");
        List<String> venueAreaIds = groupScheduleTools.getStockArea("流星花园秘密基地");
        body.put("venueAreaIds", venueAreaIds); //有空改为有数据
        List<String> assistTrainer = new ArrayList<>();
        assistTrainer.add(assistCoachIds.get(1).toString());
        body.put("assistCoachIds", assistTrainer); //空改成有数据
        body.put("ruleId", ruldId);
        body.put("spanMinutes", 50);
        body.put("endDate", CommUtil.getNDayEndTimeTamp(22)); //结束日期缩短了20天，
        body.put("force", true);
        body.put("retainBooking", true);
        xmAppApi.doRequest(RequestType.JSON, params, body.toString(), headers).assetsSuccess(true);

        //查询训练营日程详情，check修改项是否被同步修改
        campScheduleTools.getCampRuleScheduleDetail(ruldId);
        Assert.assertEquals(XMJSONPath.readPath(dataApi.getApi_response(), "$.result.chiefCoachId"), chiefCoachId);
        Assert.assertEquals(XMJSONPath.readPath(dataApi.getApi_response(), "$.result.endDate").substring(0, 9), CommUtil.getNDayEndTimeTamp(22).substring(0, 9));
        Assert.assertTrue(XMJSONPath.getJSONArrayByReadPath(dataApi.getApi_response(), "$.result.venueAreaIds").containsAll(venueAreaIds), "场地有空改为有数据后，查看日程详情发现数据没变更");
        Assert.assertTrue(XMJSONPath.getJSONArrayByReadPath(dataApi.getApi_response(), "$.result.assistCoachIds").containsAll(assistTrainer), "助教有空改为有数据后，查看日程详情发现数据没变更");
        Assert.assertEquals(XMJSONPath.getJSONObjectByReadPath(dataApi.getApi_response(), "$.result.campVO").getIntValue("totalClassHour"), super.totalClassHour, "总课时数有问题");
        int scheduleClassHourAfter =XMJSONPath.getJSONObjectByReadPath(dataApi.getApi_response(), "$.result.campVO").getIntValue("scheduleClassHour");
        //校验已排课次数是否同步变更:原排课次数-缩短日期那段时间的次数
        Assert.assertEquals(scheduleClassHourAfter, (scheduleClassHourBefore - loopNum));
    }

    @AfterClass(description = "删除此case创建的训练营排课日程")
    public void delData() {
        if (null!=campId||!campId.isEmpty()) {
            this.getTrainingTools().deleteTraining(campId);
        }

    }

}

    