package com.xiaomai.cases.polar.setting.courseCategory;

import com.xiaomai.basetest.BaseTestImpl;
import com.xiaomai.enums.ApiModule;
import com.xiaomai.enums.LoginAccount;
import com.xiaomai.enums.Terminal;
import org.testng.Assert;
import org.testng.annotations.BeforeClass;
import org.testng.annotations.Test;

import javax.annotation.Resource;

/**
 * @BelongsProject: xm-sportstest
 * @BelongsPackage: com.xiaomai.cases.polar.setting.courseCategory
 * @Author: xuyamei
 * @CreateTime: 2024-04-29  18:59
 * @Description: 校验课程分类名称是否重复
 * @Version: 1.0
 */
public class TestCheckCategoryNameDup extends BaseTestImpl {
    @Resource(name = "courseCategoryTools")
    CourseCategoryTools courseCategoryTools;
    @BeforeClass
    public void beforeTest(){
        setTestInfo(ApiModule.Polar_Setting,"API_checkCategoryNameDup", LoginAccount.GYM_PROD, Terminal.B,"xym");
        super.beforeTest();
    }

    @Test
    public void testCheckCategoryNameDup(){
        boolean flag = courseCategoryTools.checkCategoryNameDup("不存在的课程分类名称","");
        Assert.assertFalse(flag,"不存在的课程分类名称提示存在");
    }

}
