package com.xiaomai.cases.polar.training;

import com.xiaomai.enums.ApiModule;
import com.xiaomai.enums.LoginAccount;
import com.xiaomai.enums.Terminal;
import com.xiaomai.utils.RandomStringUtil;
import org.testng.Assert;
import org.testng.annotations.BeforeClass;
import org.testng.annotations.Test;

/**
 * 创建训练营活动名称验重
 *
 * @author adu
 * data 2024/7/5 17:18
 */

public class TestCheckTrainingTitleDuplicate extends BaseCreateTrainingData {
    String trainingId = "";

    @BeforeClass
    public void beforeTest() {
        setTestInfo(ApiModule.Polar_Training, "API_checkTrainingTitleDuplicate", LoginAccount.ADU_PROD, Terminal.B, "adu");
        super.beforeTest();
    }

    @Test(description = "测试创建训练营名称是否重复前置校验")
    public void testCheckTrainingTitleDuplicate() throws InterruptedException {
        //1.先创建一个活动
        String title = "杭州减肥训练营-未发布" + RandomStringUtil.randomString(5);
        trainingId = trainingTools.createTrainingNoPublish(title, courseId, trainerListIdS);

        //2.再次创建相同名称的活动，前置校验 返回true 重名，不能创建
        Boolean flag = trainingTools.checkTrainingTitleDuplicate(title);
        Assert.assertTrue(flag == true, "存在相同训练营活动名称，没拦截，验重有bug");
        //3.删除创建的活动后，再次创建check
        trainingTools.deleteTraining(trainingId);
        Thread.sleep(1000);
        Boolean flag1 = trainingTools.checkTrainingTitleDuplicate(title); //false 不重名，可以创建

        Assert.assertTrue(flag1 == false, "相同名称活动已删除，但是还是不能创建");

    }


}

    