package com.xiaomai.cases.polar.clue;

import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import com.xiaomai.enums.ApiModule;
import com.xiaomai.enums.LoginAccount;
import com.xiaomai.enums.RequestType;
import com.xiaomai.enums.Terminal;
import com.xiaomai.utils.RandomStringUtil;
import com.xiaomai.utils.XMBaseTest;
import org.testng.Assert;
import org.testng.annotations.BeforeMethod;
import org.testng.annotations.Test;

import java.util.ArrayList;
import java.util.List;

/**
 * @Author zxy
 * @Description
 * @Date 2024/6/30 10:17
 */
public class TestDistributeToPrivate extends XMBaseTest {
    MemberTools memberTools = new MemberTools();
    String id;

    @BeforeMethod
    public void beforeTest(){

        xmAppApi.setApiModule(ApiModule.Polar_Clue)
                .setApiName("API_distributeToPrivate")
                .setLoginUser(LoginAccount.GYM_PROD)
                .setTerminal(Terminal.B);

        dal.setCase_owner("zyx")
                .setCase_name(Thread.currentThread().getStackTrace()[1].getFileName().split("\\.")[0]);
        super.beforeTest();
    }

    @Test(description = "分配线索到私有池")
    public void testDistributeToPrivate(){
        String name = "自动化潜在会员"+ RandomStringUtil.randomString(3);
        String phone = RandomStringUtil.randomMobile("666");

        //若全部线索有数据，则取第一条数据；若无数据则新建一个线索
        JSONArray array = memberTools.searchMember(0,"POTENTIAL").getJSONObject("result").getJSONArray("records");
        int size = array.size();
        if(size == 0){
            id = memberTools.create(name,phone).getString("result");
        }
        else {
            id = array.getJSONObject(0).getString("id");
        }

        List memberIds = new ArrayList();
        memberIds.add(id);

        JSONObject object = new JSONObject();
        object.put("brandId",xmAppApi.getLoginInfo().getBrandId());
        object.put("studioId",xmAppApi.getLoginInfo().getStudioId());
        object.put("operatorId",xmAppApi.getLoginInfo().getAdminId());
        object.put("saleId",xmAppApi.getLoginInfo().getAdminId());
        object.put("memberIds",memberIds);

        xmAppApi.doRequest(RequestType.JSON,params,object.toString(),headers).assetsSuccess(true);

        JSONObject res = memberTools.findStudioMemberDetail(id).getJSONObject("result");
        Assert.assertEquals(res.getString("saleId"),xmAppApi.getLoginInfo().getAdminId());
        Assert.assertEquals(res.getString("position"),"PRIVATE_RESOURCE");//线索位置：私有池

    }
}
