package com.xiaomai.cases.polar.config;

import com.alibaba.fastjson.JSONObject;
import com.xiaomai.enums.ApiModule;
import com.xiaomai.enums.LoginAccount;
import com.xiaomai.enums.RequestType;
import com.xiaomai.enums.Terminal;
import com.xiaomai.utils.XMJSONPath;
import org.testng.Assert;
import org.testng.annotations.BeforeMethod;
import org.testng.annotations.Test;
import com.xiaomai.utils.XMBaseTest;

/**
 * @Author: xyy
 * @CreateTime: 2024-04-13  11:48
 * @Description:获取场馆短信条数
 * @Version: 1.0
 */

public class TestGetStudioSmsInfo extends XMBaseTest {

    @BeforeMethod
    public void beforeTest(){
        xmAppApi.setApiModule(ApiModule.Polar_Config)
                .setApiName("API_getStudioSmsInfo")
                .setLoginUser(LoginAccount.XYY_PROD)
                .setTerminal(Terminal.B);
        dal.setCase_owner("xyy")
                .setCase_name(Thread.currentThread().getStackTrace()[1].getFileName().split("\\.")[0]);
        super.beforeTest();
    }

    @Test(description = "获取场馆短信条数")
    public void testGetStudioSmsInfo(){

        JSONObject object = new JSONObject();
        object.put("studioId",xmAppApi.getLoginInfo().getStudioId());
        object.put("brandId",xmAppApi.getLoginInfo().getBrandId());
        object.put("operatorId",xmAppApi.getLoginInfo().getAdminId());

        xmAppApi.doRequest(RequestType.JSON,params,object.toJSONString(),headers).assetsSuccess(true);
        JSONObject response = xmAppApi.getBodyInJSON();
        Assert.assertEquals(XMJSONPath.readPath(response,"$.message"),"操作成功!");
        int total = Integer.parseInt(XMJSONPath.readPath(response,"$.result.remain"));
        Assert.assertTrue(total >= 0);
    }
}


