package com.xiaomai.cases.polar.config;

import com.alibaba.fastjson.JSONObject;
import com.xiaomai.enums.ApiModule;
import com.xiaomai.enums.LoginAccount;
import com.xiaomai.enums.RequestType;
import com.xiaomai.enums.Terminal;
import com.xiaomai.utils.XMJSONPath;
import org.testng.Assert;
import org.testng.annotations.BeforeMethod;
import org.testng.annotations.Test;
import com.xiaomai.utils.XMBaseTest;
import com.xiaomai.utils.RandomStringUtil;

/**
 * @Author: xyy
 * @CreateTime: 2024-04-13  11:48
 * @Description:获取某条短信记录详情
 * @Version: 1.0
 */
public class TestGetTenantSmsRecordDetail extends XMBaseTest {

    @BeforeMethod
    public void beforeTest(){
        xmAppApi.setApiModule(ApiModule.Polar_Config)
                .setApiName("API_getTenantSmsRecordDetail")
                .setLoginUser(LoginAccount.XYY_PROD)
                .setTerminal(Terminal.B);
        dal.setCase_owner("xyy")
                .setCase_name(Thread.currentThread().getStackTrace()[1].getFileName().split("\\.")[0]);
        super.beforeTest();
    }

    @Test(description = "获取某条短信记录详情")
    public void testGetTenantSmsRecordDetail(){

        String recordId = RandomStringUtil.randomNumber(3,"");

        JSONObject object = new JSONObject();
        object.put("recordId",recordId);

        xmAppApi.doRequest(RequestType.JSON,params,object.toJSONString(),headers).assetsSuccess(false);
        JSONObject response = xmAppApi.getBodyInJSON();
        Assert.assertEquals(XMJSONPath.readPath(response,"$.message"),"校验失败");
    }
}