package com.xiaomai.cases.polar.studio;

import com.alibaba.fastjson.JSONObject;
import com.xiaomai.enums.ApiModule;
import com.xiaomai.enums.LoginAccount;
import com.xiaomai.enums.RequestType;
import com.xiaomai.enums.Terminal;
import com.xiaomai.utils.XMBaseTest;
import com.xiaomai.utils.XMJSONPath;
import org.testng.Assert;
import org.testng.annotations.BeforeMethod;
import org.testng.annotations.Test;

import java.util.ArrayList;
import java.util.List;

public class TestSaveShortcutEntries extends XMBaseTest {
    @BeforeMethod
    public void beforeTest(){
        xmAppApi.setApiModule(ApiModule.Polar_Studio)
                .setApiName("API_saveShortcutEntries")
                .setLoginUser(LoginAccount.GYM_PROD)
                .setTerminal(Terminal.B);

        dal.setCase_owner("yj")
                .setCase_name(Thread.currentThread().getStackTrace()[1].getFileName().split("\\.")[0]);
        super.beforeTest();
    }
    @Test(description = "编辑首页功能")
    public void testsaveShortcutEntries() {
        JSONObject jsonObject = new JSONObject();

        List shortcutEntries = new ArrayList();
        shortcutEntries.add("CLUE_MANAGEMENT");
        shortcutEntries.add("FOLLOW_MANAGEMENT");
        shortcutEntries.add("CARD_MANAGEMENT");
        shortcutEntries.add("TRAINING_CAMP");
        shortcutEntries.add("COURSE_MANAGEMENT");
        shortcutEntries.add("WORKOUT_SCHEDULE");
        shortcutEntries.add("RESERVE_RECORD");
        shortcutEntries.add("BILLING");
        shortcutEntries.add("ORDER_MANAGEMENT");
        shortcutEntries.add("INCOME_OUTCOME");

        jsonObject.put("adminId",xmAppApi.getLoginInfo().getAdminId());
        jsonObject.put("shortcutEntries",shortcutEntries);


        xmAppApi.doRequest(RequestType.JSON, params, jsonObject.toJSONString(), headers).assetsSuccess(true);
        Assert.assertEquals(XMJSONPath.readPath(xmAppApi.getBodyInJSON(),"$code"),"200");

    }
}
