package com.xiaomai.cases.lunar.goods;

import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import com.xiaomai.basetest.BaseTestImpl;
import com.xiaomai.cases.polar.goods.Tools.GoodTools;
import com.xiaomai.client.DataUserInfo;
import com.xiaomai.enums.ApiModule;
import com.xiaomai.enums.LoginAccount;
import com.xiaomai.enums.Terminal;
import org.testng.Assert;
import org.testng.annotations.BeforeMethod;
import org.testng.annotations.Test;


public class TestListXcxGoodsGroup extends BaseTestImpl {
    GoodCTools goodCTools=new GoodCTools();

    GoodTools goodTools=new GoodTools();

    String createGoodsId;


    DataUserInfo info = new DataUserInfo();


    @BeforeMethod
    @Override
    public void beforeTest(){
        setTestInfo(ApiModule.Lunar_Goods,"API_listXcxGoodsGroup", LoginAccount.GYM_MINIAPPC, Terminal.minApp,"yff");
        super.beforeTest();
    }


    @Test(description = "拉取C端小程序物品组列表")
    public void testListXcxGoodsGroup() {

        //切换端位
        info.setTerminal(Terminal.B);
        info.setLoginUser(LoginAccount.GYM_PROD);

        //存量分组："id": "1873903771989471234","name": "自动化分组勿动勿用"

        String id="1873903771989471234";

        //case1：获取小程序物品分组列表：没有这个分组数据，因为没任何物品

        JSONObject listXcxGoodsGroup=goodCTools.listXcxGoodsGroup();
        JSONArray result=listXcxGoodsGroup.getJSONArray("result");
        boolean success=false;
        for(int i=0;i<result.size();i++){
            if( ! result.getJSONObject(1).getString("id").equals(id)){
                success=true;
            }
            Assert.assertEquals(success,true,"分组里没有一个物品，这个分组不应该在小程序物品组列表展示");

        }



        //case2：获取小程序物品分组列表：有这个分组数据，因为创建了一个单规格&启用&开启小程序售卖的物品
        //新建物品
        //创建了一个单规格&启用&开启小程序售卖
        JSONObject createGoods=goodTools.createGoods_single("YES","0.01",10,info);
        createGoodsId=createGoods.getString("result");

        //移动至这个分组
        JSONObject batchModifyGoodsBelongGroup=goodTools.batchModifyGoodsBelongGroup("1873903771989471234",createGoodsId,info);
        String  batchModifyGoodsBelongGroupSuccess=batchModifyGoodsBelongGroup.getJSONObject("result").getString("success");
        Assert.assertEquals(batchModifyGoodsBelongGroupSuccess,"1","移动一个物品至该分组失败");

        try {
            Thread.sleep(3000);
        } catch (InterruptedException e) {
            throw new RuntimeException(e);
        }

        //获取小程序物品分组列表：有该分组
        JSONObject listXcxGoodsGroup1=goodCTools.listXcxGoodsGroup();

        try {
            Thread.sleep(3000);
        } catch (InterruptedException e) {
            throw new RuntimeException(e);
        }

        JSONArray result1=listXcxGoodsGroup1.getJSONArray("result");

        boolean success1=false;
        for(int i=0;i < result1.size();i++){
            if(result1.getJSONObject(1).getString("id").equals(id)){
                success1=true;
            }
            Assert.assertEquals(success1,true,"分组的物品是启用且开启小程序售卖的，这个分组应该在小程序物品组列表展示");
        }


        //case3：获取小程序物品分组列表：没有这个分组数据，因为分组内的物品为启用&关闭小程序售卖
        //修改上个物品为启用&关闭小程序售卖
        JSONObject modifyGoodsXcxSaleState=goodTools.modifyGoodsXcxSaleState(createGoodsId,"NO",info);


        try {
            Thread.sleep(3000);
        } catch (InterruptedException e) {
            throw new RuntimeException(e);
        }

        //修改校验1：获取B端物品详情
        JSONObject getDetail=goodTools.getDetail_goods(createGoodsId,info);
        String xcxSaleState=getDetail.getJSONObject("result").getString("xcxSaleState");
        Assert.assertEquals(xcxSaleState,"NO","修改物品的小程序售卖为关闭失败");

        //获取小程序物品分组列表：没有该分组
        JSONObject listXcxGoodsGroup2=goodCTools.listXcxGoodsGroup();
        JSONArray result2=listXcxGoodsGroup2.getJSONArray("result");
        boolean success2=false;
        for(int i=0;i<result2.size();i++){
            if( ! result2.getJSONObject(1).getString("id").equals(id)){
                success2=true;
            }
            Assert.assertEquals(success2,true,"分组的物品是启用且关闭小程序售卖的，这个分组应该不在小程序物品组列表展示");
        }


        //case4：获取小程序物品分组列表：没有这个分组数据，因为分组内的物品为停用&关闭小程序售卖
        //修改上个物品为停用&关闭小程序售卖
        JSONObject modifyGoodsState=goodTools.modifyGoodsState(createGoodsId,"NO",info);

        try {
            Thread.sleep(3000);
        } catch (InterruptedException e) {
            throw new RuntimeException(e);
        }

        //修改校验1：获取B端物品详情
        JSONObject getDetail1=goodTools.getDetail_goods(createGoodsId,info);
        String state=getDetail1.getJSONObject("result").getString("state");
        Assert.assertEquals(state,"NO","修改物品的状态为停用失败");

        //获取小程序物品分组列表：没有该分组
        JSONObject listXcxGoodsGroup3=goodCTools.listXcxGoodsGroup();
        JSONArray result3=listXcxGoodsGroup3.getJSONArray("result");
        boolean success3=false;
        for(int i=0;i<result3.size();i++){
            if( ! result3.getJSONObject(1).getString("id").equals(id)){
                success3=true;
            }
            Assert.assertEquals(success3,true,"分组的物品是停用且关闭小程序售卖的，这个分组应该不在小程序物品组列表展示");
        }


    }
    @Test(description = "清理物品数据",priority = 1)
    public void delete() {
        goodTools.deleteGoods(createGoodsId,info);

    }

}
