package com.xiaomai.cases.polar.points;

import com.alibaba.fastjson.JSONObject;
import com.xiaomai.client.DataUserInfo;
import com.xiaomai.enums.ApiModule;
import com.xiaomai.enums.RequestType;
import com.xiaomai.enums.Terminal;
import com.xiaomai.utils.XMBaseTest;
import org.springframework.stereotype.Component;

import java.util.ArrayList;
import java.util.List;

@Component("pointsTools")//B端会员积分工具类
public class PointsTools extends XMBaseTest {
    public void setUp(String name, DataUserInfo...dataUserInfo) {
        dataApi.setApiModule(ApiModule.Polar_Points)
                .setApiName(name)
                .setTerminal(Terminal.B);//这个到时候要改
    }

    /**
     * @param
     * @description:会员积分帐户列表
     * @author: yangjian
     * @param studioId 场馆id不传则为品牌端操作

     **/
    public JSONObject findAccountPagePermission(String studioId,String memberId, DataUserInfo... dataUserInfos) {

        dataApi.setApiModule(ApiModule.Polar_Points)
                .setApiName("API_findAccountPagePermission")
                .setTerminal(Terminal.B);
        super.beforeDataRequest(dataUserInfos);

        List<String> memberIds = new ArrayList<>();
        memberIds.add(memberId);

        JSONObject jsonObject = new JSONObject();
        jsonObject.put("gtTotalAwardBalance", 0);
        jsonObject.put("current", 0);
        jsonObject.put("size", 20);
        jsonObject.put("sort", "TOTAL_AWARD_BALANCE_DESC");
        if (!studioId.equals("")){
            jsonObject.put("studioId", studioId);//传studioId则为场馆操作；不传则为品牌操作
        }
        if (!memberId.equals("")){
            jsonObject.put("memberIds", memberIds);//传studioId则为场馆操作；不传则为品牌操作
        }

        jsonObject.put("brandId", dataApi.getLoginInfo().getBrandId());
        jsonObject.put("operatorId", dataApi.getLoginInfo().getAdminId());

        dataApi.doRequest(RequestType.JSON, dataparams, jsonObject.toJSONString(), dataheadrs).assetsSuccess(true);
        JSONObject response = dataApi.getBodyInJSON();
        return response;
    }


    /**
     * @param
     * @description:积分记录列表
     * @author: yangjian
     * @param studioId 场馆id不传则为品牌端操作

     **/
    public JSONObject findStatementPagePermission(String studioId, DataUserInfo... dataUserInfos) {

        dataApi.setApiModule(ApiModule.Polar_Points)
                .setApiName("API_findStatementPagePermission")
                .setTerminal(Terminal.B);
        super.beforeDataRequest(dataUserInfos);

        JSONObject jsonObject = new JSONObject();
        jsonObject.put("current", 0);
        jsonObject.put("size", 20);
        jsonObject.put("startCreated", null);
        jsonObject.put("endCreated", null);
        if (!studioId.equals("")){
            jsonObject.put("studioId", dataApi.getLoginInfo().getStudioId());//传studioId则为场馆操作；不传则为品牌操作
        }
        jsonObject.put("brandId", dataApi.getLoginInfo().getBrandId());
        jsonObject.put("operatorId", dataApi.getLoginInfo().getAdminId());

        dataApi.doRequest(RequestType.JSON, dataparams, jsonObject.toJSONString(), dataheadrs).assetsSuccess(true);
        JSONObject response = dataApi.getBodyInJSON();
        return response;
    }

    /**
     * @param
     * @description:积分帐户导出
     * @author: yangjian
     * @param studioId 场馆id不传则为品牌端操作

     **/
    public JSONObject exportAccount(String studioId, DataUserInfo... dataUserInfos) {

        dataApi.setApiModule(ApiModule.Polar_Points)
                .setApiName("API_exportAccount")
                .setTerminal(Terminal.B);
        super.beforeDataRequest(dataUserInfos);

        JSONObject jsonObject = new JSONObject();
        jsonObject.put("current", 0);
        jsonObject.put("size", 20);
        jsonObject.put("gtTotalAwardBalance", 0);
        jsonObject.put("sort", "TOTAL_AWARD_BALANCE_DESC");
        if (!studioId.equals("")){
            jsonObject.put("studioId", dataApi.getLoginInfo().getStudioId());//传studioId则为场馆操作；不传则为品牌操作
        }
        jsonObject.put("brandId", dataApi.getLoginInfo().getBrandId());
        jsonObject.put("operatorId", dataApi.getLoginInfo().getAdminId());

        dataApi.doRequest(RequestType.JSON, dataparams, jsonObject.toJSONString(), dataheadrs).assetsSuccess(true);
        JSONObject response = dataApi.getBodyInJSON();
        return response;
    }

    /**
     * @param
     * @description:积分记录导出
     * @author: yangjian
     * @param studioId 场馆id不传则为品牌端操作

     **/
    public JSONObject exportStatement(String studioId, DataUserInfo... dataUserInfos) {

        dataApi.setApiModule(ApiModule.Polar_Points)
                .setApiName("API_exportStatement")
                .setTerminal(Terminal.B);
        super.beforeDataRequest(dataUserInfos);

        JSONObject jsonObject = new JSONObject();
        if (!studioId.equals("")){
            jsonObject.put("studioId", dataApi.getLoginInfo().getStudioId());//传studioId则为场馆操作；不传则为品牌操作
        }
        jsonObject.put("brandId", dataApi.getLoginInfo().getBrandId());
        jsonObject.put("operatorId", dataApi.getLoginInfo().getAdminId());

        dataApi.doRequest(RequestType.JSON, dataparams, jsonObject.toJSONString(), dataheadrs).assetsSuccess(true);
        JSONObject response = dataApi.getBodyInJSON();
        return response;
    }

    /**
     * @param
     * @description:获取积分规则
     * @author: yangjian
     * @param studioId 场馆id不传则为品牌端操作

     **/
    public JSONObject memberPoint_findRule(String studioId, DataUserInfo... dataUserInfos) {

        dataApi.setApiModule(ApiModule.Polar_Points)
                .setApiName("API_memberPoint_findRule")
                .setTerminal(Terminal.B);
        super.beforeDataRequest(dataUserInfos);

        JSONObject jsonObject = new JSONObject();
        if (!studioId.equals("")){
            jsonObject.put("studioId", dataApi.getLoginInfo().getStudioId());//传studioId则为场馆操作；不传则为品牌操作
        }
        jsonObject.put("brandId", dataApi.getLoginInfo().getBrandId());
        jsonObject.put("operatorId", dataApi.getLoginInfo().getAdminId());

        dataApi.doRequest(RequestType.JSON, dataparams, jsonObject.toJSONString(), dataheadrs).assetsSuccess(true);
        JSONObject response = dataApi.getBodyInJSON();
        return response;
    }

    /**
     * @param
     * @description:保存积分规则
     * @author: yangjian
     * @param studioId 场馆id不传则为品牌端操作

     **/
    public JSONObject memberPoint_saveRule(String studioId, DataUserInfo... dataUserInfos) {

        dataApi.setApiModule(ApiModule.Polar_Points)
                .setApiName("API_memberPoint_saveRule")
                .setTerminal(Terminal.B);
        super.beforeDataRequest(dataUserInfos);

        String description ="{\"items\":[{\"content\":\"自动化规则说明\",\"type\":\"TEXT\",\"aspect\":\"\"}]}";

        JSONObject jsonObject1 = new JSONObject();
        jsonObject1.put("ruleType", "BIND_WECHAT");//绑定公众号
        jsonObject1.put("state","YES");
        jsonObject1.put("fixedPointAmount", "19");

        JSONObject jsonObject2 = new JSONObject();
        jsonObject2.put("ruleType", "CHECK_IN_GROUP_CLASS");//团课签到
        jsonObject2.put("state","YES");
        jsonObject2.put("fixedPointAmount", "1");//1积分
        jsonObject2.put("fixedPointLimitPerDay", "100");//上限

        JSONObject jsonObject3 = new JSONObject();
        jsonObject3.put("ruleType", "CHECK_IN_PRIVATE_CLASS");//私教课签到
        jsonObject3.put("state","YES");
        jsonObject3.put("fixedPointAmount", "2");//2积分
        jsonObject3.put("fixedPointLimitPerDay", "100");//上限

        JSONObject jsonObject4 = new JSONObject();
        jsonObject4.put("ruleType", "CHECK_IN_TRAINING_CAMP");//训练营签到
        jsonObject4.put("state","YES");
        jsonObject4.put("fixedPointAmount", "3");//3积分
        jsonObject4.put("fixedPointLimitPerDay", "100");//上限

        JSONObject jsonObject5 = new JSONObject();
        jsonObject5.put("ruleType", "CHECK_IN_VENUE_ENTRY");//入场签到
        jsonObject5.put("state","YES");
        jsonObject5.put("fixedPointAmount", "4");//4积分
        jsonObject5.put("fixedPointLimitPerDay", "100");//上限

        JSONObject jsonObject6 = new JSONObject();
        jsonObject6.put("ruleType", "CHECK_IN_VENUE_RESERVE");//约场签到
        jsonObject6.put("state","YES");
        jsonObject6.put("fixedPointAmount", "5");//5积分
        jsonObject6.put("fixedPointLimitPerDay", "100");//上限

        JSONObject jsonObject7 = new JSONObject();
        jsonObject7.put("ruleType", "SIGN_MEMBER_CARD");//会员卡实付满100，送6积分
        jsonObject7.put("state","YES");
        jsonObject7.put("accumulativePointAmount", "6");//6积分
        jsonObject7.put("accumulativeBizAmount", "100");//满100

        JSONObject jsonObject8 = new JSONObject();
        jsonObject8.put("ruleType", "REFUND_MEMBER_CARD");//会员卡实退满100，扣7积分
        jsonObject8.put("state","YES");
        jsonObject8.put("accumulativeBizAmount", "7");//7积分
        jsonObject8.put("accumulativePointAmount", "100");

        JSONObject jsonObject9 = new JSONObject();
        jsonObject9.put("ruleType", "SIGN_DEPOSIT_CARD");//训练营实付满100，送8积分
        jsonObject9.put("state","YES");
        jsonObject9.put("accumulativePointAmount", "8");//8积分
        jsonObject9.put("accumulativeBizAmount", "100");//上限

        JSONObject jsonObject10 = new JSONObject();
        jsonObject10.put("ruleType", "REFUND_TRAINING_CAMP");//训练营实退满100
        jsonObject10.put("state","YES");
        jsonObject10.put("accumulativePointAmount", "9");
        jsonObject10.put("accumulativeBizAmount", "100");

        JSONObject jsonObject11 = new JSONObject();
        jsonObject11.put("ruleType", "SIGN_DEPOSIT_CARD");//储值卡实付款满100
        jsonObject11.put("state","YES");
        jsonObject11.put("accumulativePointAmount", "10");
        jsonObject11.put("accumulativeBizAmount", "100");

        JSONObject jsonObject12 = new JSONObject();
        jsonObject12.put("ruleType", "CHECK_IN_TRAINING_CAMP");//储值卡实退款满100
        jsonObject12.put("state","YES");
        jsonObject12.put("accumulativePointAmount", "11");
        jsonObject12.put("accumulativeBizAmount", "100");

        JSONObject jsonObject13 = new JSONObject();
        jsonObject13.put("ruleType", "SIGN_EXPERIENCE_CARD");//体验卡实付款满100
        jsonObject13.put("state","YES");
        jsonObject13.put("accumulativePointAmount", "12");
        jsonObject13.put("accumulativeBizAmount", "100");

        JSONObject jsonObject14 = new JSONObject();
        jsonObject14.put("ruleType", "REFUND_EXPERIENCE_CARD");//体验卡实退款满100
        jsonObject14.put("state","YES");
        jsonObject14.put("accumulativePointAmount", "13");
        jsonObject14.put("accumulativeBizAmount", "100");

        JSONObject jsonObject15 = new JSONObject();
        jsonObject15.put("ruleType", "SIGN_GOODS");//物品实付款满100
        jsonObject15.put("state","YES");
        jsonObject15.put("accumulativePointAmount", "14");
        jsonObject15.put("accumulativeBizAmount", "100");

        JSONObject jsonObject16 = new JSONObject();
        jsonObject16.put("ruleType", "REFUND_GOODS");//物品实退款满100
        jsonObject16.put("state","YES");
        jsonObject16.put("accumulativePointAmount", "15");
        jsonObject16.put("accumulativeBizAmount", "100");

        JSONObject jsonObject17 = new JSONObject();
        jsonObject17.put("ruleType", "SIGN_VENUE_RESERVE");//场地预约实付款满100
        jsonObject17.put("state","YES");
        jsonObject17.put("accumulativePointAmount", "16");
        jsonObject17.put("accumulativeBizAmount", "100");

        JSONObject jsonObject18 = new JSONObject();
        jsonObject18.put("ruleType", "SIGN_SINGLE_RESERVE");//单次约课实付款满100
        jsonObject18.put("state","YES");
        jsonObject18.put("accumulativePointAmount", "17");
        jsonObject18.put("accumulativeBizAmount", "100");

        JSONObject jsonObject19 = new JSONObject();
        jsonObject19.put("ruleType", "SIGN_ACTIVITY");//活动报名实付款满100
        jsonObject19.put("state","YES");
        jsonObject19.put("accumulativePointAmount", "18");
        jsonObject19.put("accumulativeBizAmount", "100");

        List<JSONObject> ruleItemList = new ArrayList<>();//规则数组
        ruleItemList.add(jsonObject1);
        ruleItemList.add(jsonObject2);
        ruleItemList.add(jsonObject3);
        ruleItemList.add(jsonObject4);
        ruleItemList.add(jsonObject5);
        ruleItemList.add(jsonObject6);
        ruleItemList.add(jsonObject7);
        ruleItemList.add(jsonObject8);
        ruleItemList.add(jsonObject9);
        ruleItemList.add(jsonObject10);
        ruleItemList.add(jsonObject11);
        ruleItemList.add(jsonObject12);
        ruleItemList.add(jsonObject13);
        ruleItemList.add(jsonObject14);
        ruleItemList.add(jsonObject15);
        ruleItemList.add(jsonObject16);
        ruleItemList.add(jsonObject17);
        ruleItemList.add(jsonObject18);
        ruleItemList.add(jsonObject19);



        JSONObject jsonObject = new JSONObject();
        if (!studioId.equals("")){
            jsonObject.put("studioId", dataApi.getLoginInfo().getStudioId());//传studioId则为场馆操作；不传则为品牌操作
        }
        jsonObject.put("brandId", dataApi.getLoginInfo().getBrandId());
        jsonObject.put("operatorId", dataApi.getLoginInfo().getAdminId());
        jsonObject.put("enableMemberPoint", "YES");//积分功能是否打开
        jsonObject.put("memberPointName", "自动化积分");//积分名称
        jsonObject.put("ruleItemList", ruleItemList);//积分规则
        jsonObject.put("validPeriod", "1");
        jsonObject.put("description", description);


        dataApi.doRequest(RequestType.JSON, dataparams, jsonObject.toJSONString(), dataheadrs).assetsSuccess(true);
        JSONObject response = dataApi.getBodyInJSON();
        return response;
    }



























    /**
     * @param
     * @description:批量增加-积分
     * @author: yangjian
     * @param studioId 场馆id不传则为品牌端操作
     * @param amount   增加的积分数
     * @param memberId 增加积分的会员

     **/
    public JSONObject batchAwardPoint(String amount,String memberId,String studioId, DataUserInfo... dataUserInfos) {

        dataApi.setApiModule(ApiModule.Polar_Points)
                .setApiName("API_batchAwardPoint")
                .setTerminal(Terminal.B);
        super.beforeDataRequest(dataUserInfos);

        List<String> memberIds = new ArrayList<>();
        memberIds.add(memberId);

        JSONObject jsonObject = new JSONObject();
        jsonObject.put("amount", amount);
        jsonObject.put("memberIds", memberIds);
        if (!studioId.equals("")){
            jsonObject.put("studioId", dataApi.getLoginInfo().getStudioId());//传studioId则为场馆操作；不传则为品牌操作
        }
        jsonObject.put("brandId", dataApi.getLoginInfo().getBrandId());
        jsonObject.put("operatorId", dataApi.getLoginInfo().getAdminId());
        jsonObject.put("memo", "自动化积分批量增加");

        dataApi.doRequest(RequestType.JSON, dataparams, jsonObject.toJSONString(), dataheadrs).assetsSuccess(true);
        JSONObject response = dataApi.getBodyInJSON();
        return response;
    }

    /**
     * @param
     * @description:批量扣减-积分
     * @author: yangjian
     * @param studioId 场馆id不传则为品牌端操作
     * @param amount   扣减的积分数
     * @param memberId 扣减积分的会员

     **/
    public JSONObject batchDeductPoint(String amount,String memberId,String studioId, DataUserInfo... dataUserInfos) {

        dataApi.setApiModule(ApiModule.Polar_Points)
                .setApiName("API_batchDeductPoint")
                .setTerminal(Terminal.B);
        super.beforeDataRequest(dataUserInfos);

        List<String> memberIds = new ArrayList<>();
        memberIds.add(memberId);

        JSONObject jsonObject = new JSONObject();
        jsonObject.put("amount", amount);
        jsonObject.put("memberIds", memberIds);
        if (!studioId.equals("")){
            jsonObject.put("studioId", dataApi.getLoginInfo().getStudioId());//传studioId则为场馆操作；不传则为品牌操作
        }
        jsonObject.put("brandId", dataApi.getLoginInfo().getBrandId());
        jsonObject.put("operatorId", dataApi.getLoginInfo().getAdminId());
        jsonObject.put("memo", "自动化积分批量增扣减");

        dataApi.doRequest(RequestType.JSON, dataparams, jsonObject.toJSONString(), dataheadrs).assetsSuccess(true);
        JSONObject response = dataApi.getBodyInJSON();
        return response;
    }

    /**
     * @param
     * @description:批量清零-积分
     * @author: yangjian
     * @param studioId 场馆id不传则为品牌端操作
     * @param memberId 扣减积分的会员

     **/
    public JSONObject batchClearPoint(String memberId,String studioId, DataUserInfo... dataUserInfos) {

        dataApi.setApiModule(ApiModule.Polar_Points)
                .setApiName("API_batchClearPoint")
                .setTerminal(Terminal.B);
        super.beforeDataRequest(dataUserInfos);

        List<String> memberIds = new ArrayList<>();
        memberIds.add(memberId);

        JSONObject jsonObject = new JSONObject();
        jsonObject.put("memberIds", memberIds);
        if (!studioId.equals("")){
            jsonObject.put("studioId", dataApi.getLoginInfo().getStudioId());//传studioId则为场馆操作；不传则为品牌操作
        }
        jsonObject.put("brandId", dataApi.getLoginInfo().getBrandId());
        jsonObject.put("operatorId", dataApi.getLoginInfo().getAdminId());
        jsonObject.put("memo", "自动化积分批量增清零");


        dataApi.doRequest(RequestType.JSON, dataparams, jsonObject.toJSONString(), dataheadrs).assetsSuccess(true);
        JSONObject response = dataApi.getBodyInJSON();
        return response;
    }

    /**
     * @param
     * @description:会员详情-增加积分
     * @author: yangjian
     * @param memberId 增加积分的会员
     * @param amount 增加的积分数

     **/
    public JSONObject manualAwardPoint(String amount,String memberId, DataUserInfo... dataUserInfos) {

        dataApi.setApiModule(ApiModule.Polar_Points)
                .setApiName("API_manualAwardPoint")
                .setTerminal(Terminal.B);
        super.beforeDataRequest(dataUserInfos);

        JSONObject jsonObject = new JSONObject();
        jsonObject.put("amount", amount);
        jsonObject.put("memberId", memberId);
        jsonObject.put("brandId", dataApi.getLoginInfo().getBrandId());
        jsonObject.put("operatorId", dataApi.getLoginInfo().getAdminId());
        jsonObject.put("studioId", dataApi.getLoginInfo().getStudioId());
        jsonObject.put("memo", "自动化积分学员详情-增加积分");

        dataApi.doRequest(RequestType.JSON, dataparams, jsonObject.toJSONString(), dataheadrs).assetsSuccess(true);
        JSONObject response = dataApi.getBodyInJSON();
        return response;
    }

    /**
     * @param
     * @description:会员详情-扣减积分
     * @author: yangjian
     * @param memberId 扣减积分的会员
     * @param amount 扣减的积分数

     **/
    public JSONObject manualDeductPoint(String amount,String memberId, DataUserInfo... dataUserInfos) {

        dataApi.setApiModule(ApiModule.Polar_Points)
                .setApiName("API_manualDeductPoint")
                .setTerminal(Terminal.B);
        super.beforeDataRequest(dataUserInfos);

        JSONObject jsonObject = new JSONObject();
        jsonObject.put("amount", amount);
        jsonObject.put("memberId", memberId);
        jsonObject.put("brandId", dataApi.getLoginInfo().getBrandId());
        jsonObject.put("operatorId", dataApi.getLoginInfo().getAdminId());
        jsonObject.put("studioId", dataApi.getLoginInfo().getStudioId());
        jsonObject.put("memo", "自动化积分学员详情-扣减积分");

        dataApi.doRequest(RequestType.JSON, dataparams, jsonObject.toJSONString(), dataheadrs).assetsSuccess(true);
        JSONObject response = dataApi.getBodyInJSON();
        return response;
    }

    //导出记录列表-品牌
    public JSONObject pageStudioExportRecord(String studioId, DataUserInfo...userInfos){
        dataApi.setApiModule(ApiModule.Polar_Export)
                .setApiName("API_pageStudioExportRecord")
                .setTerminal(Terminal.B);

        super.beforeDataRequest(userInfos);

        JSONObject object = new JSONObject();
        object.put("current",1);
        object.put("size",20);
        object.put("brandId",dataApi.getLoginInfo().getBrandId());
        if (!studioId.equals("")){
            object.put("studioId", dataApi.getLoginInfo().getStudioId());//传studioId则为场馆操作；不传则为品牌操作
        }
        object.put("operatorId",dataApi.getLoginInfo().getAdminId());

        dataApi.doRequest(RequestType.JSON,dataparams,object.toString(),dataheadrs).assetsSuccess(true);
        return dataApi.getBodyInJSON();
    }

}
