package com.xiaomai.cases.polar.finance.revenueAndExpenditure;

import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import com.xiaomai.client.DataUserInfo;
import com.xiaomai.enums.ApiModule;
import com.xiaomai.enums.RequestType;
import com.xiaomai.enums.Terminal;
import com.xiaomai.utils.XMBaseTest;
import com.xiaomai.utils.XMJSONPath;

import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;

public class RevenueAndExpenditureTools extends XMBaseTest {

    /**
     * @param
     * @description:分页收支列表
     * @param paymentWays：支付方式  1  2
     * @param type:	业务收支类型：INCOME:收入 EXPENSE:支出
     * @param item:	业务收支类型：SIGN:签单 REFUND:退单
     * @param supplierId：卖家ID 场馆ID
     * @author: yangfangfang
     **/
    public JSONObject pageNormalIncomeExpense(String paymentWays, String type, String item, String supplierId,  DataUserInfo...dataUserInfos){

        dataApi.setApiModule(ApiModule.Polar_Finance)
                .setApiName("API_pageNormalIncomeExpense")
                .setTerminal(Terminal.B);
        super.beforeDataRequest(dataUserInfos);

        JSONObject jsonObject=new JSONObject();
        jsonObject.put("current",0);
        jsonObject.put("size",20);


        JSONArray jsonArray=new JSONArray();
        jsonArray.add(paymentWays);
        jsonObject.put("paymentWays",jsonArray);

        jsonObject.put("type",type);
        jsonObject.put("item",item);
        jsonObject.put("supplierId",supplierId);
        jsonObject.put("brandId",dataApi.getLoginInfo().getBrandId());
        jsonObject.put("studioId",dataApi.getLoginInfo().getStudioId());
        jsonObject.put("operatorId",dataApi.getLoginInfo().getAdminId());

        dataApi.doRequest(RequestType.JSON, dataparams, jsonObject.toJSONString(), dataheadrs).assetsSuccess(true);
        JSONObject response=dataApi.getBodyInJSON();
        return response;
    }

    /**
     * @param
     * @description:统计收支
     * @param supplierId：卖家ID 场馆ID
     * @author: yangfangfang
     **/
    public JSONObject sumNormalIncomeExpense(String paymentWays, String type, String item,String supplierId,  DataUserInfo...dataUserInfos){

        dataApi.setApiModule(ApiModule.Polar_Finance)
                .setApiName("API_sumNormalIncomeExpense")
                .setTerminal(Terminal.B);
        super.beforeDataRequest(dataUserInfos);

        JSONObject jsonObject=new JSONObject();
        jsonObject.put("current",0);
        jsonObject.put("size",20);


        JSONArray jsonArray=new JSONArray();
        jsonArray.add(paymentWays);
        jsonObject.put("paymentWays",jsonArray);

        jsonObject.put("type",type);
        jsonObject.put("item",item);
        jsonObject.put("supplierId",supplierId);
        jsonObject.put("brandId",dataApi.getLoginInfo().getBrandId());
        jsonObject.put("studioId",dataApi.getLoginInfo().getStudioId());
        jsonObject.put("operatorId",dataApi.getLoginInfo().getAdminId());

        dataApi.doRequest(RequestType.JSON, dataparams, jsonObject.toJSONString(), dataheadrs).assetsSuccess(true);
        JSONObject response=dataApi.getBodyInJSON();
        return response;
    }

    /**
     * @param
     * @description:分页作废收支列表
     * @param supplierId：卖家ID 场馆ID
     * @param brandId:品牌ID
     * @param studioId：场馆ID
     * @param operatorId：操作人ID
     * @author: yangfangfang
     **/
    public JSONObject pageDiscardIncomeExpense(String paymentWays, String type, String item, String supplierId, DataUserInfo...dataUserInfos){

        dataApi.setApiModule(ApiModule.Polar_Finance)
                .setApiName("API_pageDiscardIncomeExpense")
                .setTerminal(Terminal.B);
        super.beforeDataRequest(dataUserInfos);

        JSONObject jsonObject=new JSONObject();
        jsonObject.put("current",0);
        jsonObject.put("size",20);


        JSONArray jsonArray=new JSONArray();
        jsonArray.add(paymentWays);
        jsonObject.put("paymentWays",jsonArray);

        jsonObject.put("type",type);
        jsonObject.put("item",item);
        jsonObject.put("supplierId",supplierId);
        jsonObject.put("brandId",dataApi.getLoginInfo().getBrandId());
        jsonObject.put("studioId",dataApi.getLoginInfo().getStudioId());
        jsonObject.put("operatorId",dataApi.getLoginInfo().getAdminId());

        dataApi.doRequest(RequestType.JSON, dataparams, jsonObject.toJSONString(), dataheadrs).assetsSuccess(true);
        JSONObject response=dataApi.getBodyInJSON();
        return response;
    }


    /**
     * @param
     * @description:获取收支的支付/退款记录
     * @param id：主键ID
     * @author: yangfangfang
     **/
    public JSONObject get(String id,DataUserInfo...dataUserInfos){

        dataApi.setApiModule(ApiModule.Polar_Finance)
                .setApiName("API_get")
                .setTerminal(Terminal.B);
        super.beforeDataRequest(dataUserInfos);

        JSONObject jsonObject=new JSONObject();
        jsonObject.put("id",id);
        jsonObject.put("brandId",dataApi.getLoginInfo().getBrandId());
        jsonObject.put("studioId",dataApi.getLoginInfo().getStudioId());
        jsonObject.put("operatorId",dataApi.getLoginInfo().getAdminId());

        dataApi.doRequest(RequestType.JSON, dataparams, jsonObject.toJSONString(), dataheadrs).assetsSuccess(true);
        JSONObject response=dataApi.getBodyInJSON();
        return response;
    }

    /**
     * @param
     * @description:上传图片资源
     * @param bizCode：VOUCHER_INFO
     * @param tenantType：BRAND
     * @param filePath：图片地址
     * @author: yangfangfang
     **/
    public JSONObject mobileResource( String bizCode, String tenantType, String filePath, DataUserInfo...dataUserInfos) throws IOException {

        dataApi.setApiModule(ApiModule.Polar_Finance)
                .setApiName("API_mobileResource")
                .setTerminal(Terminal.B);
        super.beforeDataRequest(dataUserInfos);

        JSONObject jsonObject=new JSONObject();
        jsonObject.put("tenantId",dataApi.getLoginInfo().getBrandId());
        jsonObject.put("resourceName","imgFile/test1.jpg");
        jsonObject.put("bizCode",bizCode);
        jsonObject.put("tenantType",tenantType);

        dataApi.doRequest(RequestType.JSON, dataparams, jsonObject.toJSONString(), dataheadrs).assetsSuccess(true);

        JSONObject response = dataApi.getBodyInJSON();
        String resourceId = XMJSONPath.readPath(response, "$.result.resourceId");
        String accessId = XMJSONPath.readPath(response, "$.result.accessId");
        String policy = XMJSONPath.readPath(response, "$.result.policy");
        String signature = XMJSONPath.readPath(response, "$.result.signature");
        String key = XMJSONPath.readPath(response, "$.result.key");
        String callback = XMJSONPath.readPath(response, "$.result.callback");
        String host = XMJSONPath.readPath(response, "$.result.host");


        InputStream inputStream = new FileInputStream(filePath);
        SignatureVO signatureVO = new SignatureVO();
        signatureVO.setAccessId(accessId);
        signatureVO.setPolicy(policy);
        signatureVO.setCallback(callback);
        signatureVO.setKey(key);
        signatureVO.setSignature(signature);
        signatureVO.setHost(host);
        signatureVO.setResourceId(Long.valueOf(resourceId));

        ResourceUtil.uploadFile(inputStream, filePath, signatureVO, 5000);

        return response;
    }


}
