package com.xiaomai.cases.polar.eleContract;

import com.xiaomai.basetest.BaseTestImpl;
import com.xiaomai.enums.ApiModule;
import com.xiaomai.enums.LoginAccount;
import com.xiaomai.enums.RequestType;
import com.xiaomai.enums.Terminal;
import org.testng.Assert;
import org.testng.annotations.BeforeMethod;
import org.testng.annotations.Test;

/**
 * @BelongsProject: xm-sportstest
 * @BelongsPackage: com.xiaomai.cases.polar.eleContract
 * @Author: xuyamei
 * @CreateTime: 2024-08-05  11:28
 * @Description: 获取企业最新的认证结果-只有状态
 * @Version: 1.0
 */
public class TestGetCompanyLastVerifyStatus extends BaseTestImpl {


    @BeforeMethod
    @Override
    public void beforeTest(){
        setTestInfo(ApiModule.Polar_EleContract,"API_getCompanyLastVerifyStatus", LoginAccount.DZHT_PROD, Terminal.B,"xym");
        super.beforeTest();
    }

    @Test
    public void testGetCompanyLastVerifyStatus(){
        String body = "{\"tenantId\":\""+xmAppApi.getLoginInfo().getStudioId()+"\"}";
        xmAppApi.doRequest(RequestType.JSON,params,body,headers).assetsSuccess(true);
        Assert.assertEquals(xmAppApi.getBodyInJSON().getJSONObject("result").getString("status"),"AUDIT_SUCCEEDED","场馆已经认证，获取的企业最新的认证结果返回的不是AUDIT_SUCCEEDED");
    }
}
