package com.xiaomai.cases.lunar.user;

import com.alibaba.fastjson.JSONObject;
import com.xiaomai.basetest.BaseTestImpl;
import com.xiaomai.enums.ApiModule;
import com.xiaomai.enums.LoginAccount;
import com.xiaomai.enums.RequestType;
import com.xiaomai.enums.Terminal;
import com.xiaomai.utils.XMBaseTest;
import org.testng.Assert;
import org.testng.annotations.BeforeClass;
import org.testng.annotations.BeforeMethod;
import org.testng.annotations.Test;

/**
 * @Author zxy
 * @Description
 * @Date 2024/7/12 15:01
 */
public class TestBindGhzStatus extends XMBaseTest {
    @BeforeMethod
    public void beforeTest(){

        xmAppApi.setApiModule(ApiModule.Lunar_User)
                .setApiName("API_bindGhzStatus")
                .setLoginUser(LoginAccount.GYM_MINIAPPC)
                .setTerminal(Terminal.minApp);

        dal.setCase_owner("zyx")
                .setCase_name(Thread.currentThread().getStackTrace()[1].getFileName().split("\\.")[0]);
        super.beforeTest();

    }

    @Test(description = "公众号订阅状态")//UN_AUTH_SUCCESS：品牌授权公众号未成功,UN_OPENID：未绑定公众号openId,UN_SUBSCRIBE：未关注, SUBSCRIBE：已关注

    public void testBindGhzStatus(){

        UserTools userTools = new UserTools();
        String memberId = userTools.getMemberInfo().getString("memberId");

        JSONObject object = new JSONObject();
        object.put("brandId",xmAppApi.getLoginInfo().getBrandId());
        object.put("memberId",memberId);
        object.put("userId",xmAppApi.getLoginInfo().getUser());

        xmAppApi.doRequest(RequestType.JSON,params,object.toString(),headers).assetsSuccess(true);
        Assert.assertEquals(xmAppApi.getBodyInJSON().getString("result"),"UN_OPENID");

    }
}
