package com.xiaomai.cases.polar.coupon;

import com.alibaba.fastjson.JSONObject;
import com.xiaomai.cases.lunar.minMemberCard.MinCardTools;
import com.xiaomai.cases.lunar.order.OrderCTools;
import com.xiaomai.cases.lunar.user.UserTools;
import com.xiaomai.enums.ApiModule;
import com.xiaomai.enums.LoginAccount;
import com.xiaomai.enums.RequestType;
import com.xiaomai.enums.Terminal;
import com.xiaomai.utils.XMBaseTest;
import com.xiaomai.utils.XMJSONPath;
import org.testng.Assert;
import org.testng.annotations.BeforeMethod;
import org.testng.annotations.Test;

import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.List;

public class TestFetchOrderWaitUse extends XMBaseTest {
    @BeforeMethod
    public void beforeTest(){
        xmAppApi.setApiModule(ApiModule.Lunar_Coupon)
                .setApiName("API_fetchOrderWaitUse")
                .setLoginUser(LoginAccount.GYM_MINIAPPC)
                .setTerminal(Terminal.minApp);

        dal.setCase_owner("yj")
                .setCase_name(Thread.currentThread().getStackTrace()[1].getFileName().split("\\.")[0]);
        super.beforeTest();
    }
    @Test(description = "确认订单页查看可使用优惠券")
    public void fetchOrderWaitUse() {
        UserTools userTools=new UserTools();
        String receiverId = userTools.getMemberInfo().getString("memberId");//同memberId
        CouponMInTools CouponMIntools =new CouponMInTools();
        CouponMIntools.getPageConfig();//首页获取首页的配置
        String id =XMJSONPath.readPath(dataApi.getApi_response(),"$.result.moduleConfigList[11].config.ids[0]");//小程序首页，拿配置返回的优惠券id

        CouponMIntools.claim(id,receiverId);//领取优惠券
        String cooponid =XMJSONPath.readPath(dataApi.getApi_response(),"$.result");//拿第一张可用的优惠券
        System.out.println("--------"+cooponid);

        JSONObject jsonObject1 = new JSONObject();
        jsonObject1.put("amount", 1);
        jsonObject1.put("scope","MEMBER_CARD");

        List<JSONObject> useScope2Amounts = new ArrayList<>();
        useScope2Amounts.add(jsonObject1);

        JSONObject jsonObject = new JSONObject();
        jsonObject.put("receiverId", receiverId);
        jsonObject.put("studioId",dataApi.getLoginInfo().getStudioId());
        jsonObject.put("useScope2Amounts",useScope2Amounts);

        xmAppApi.doRequest(RequestType.JSON, params, jsonObject.toJSONString(), headers).assetsSuccess(true);

        CouponMIntools.fetchOrderWaitUse(receiverId);
        int count= XMJSONPath.getJSONArrayByReadPath(dataApi.getApi_response(),"$.result").size();//核对能用优惠券的张数
        Assert.assertEquals(count>=0,true,"该账户下，没有优惠券了");//没有优惠券需要提示

        String memberId = userTools.getMemberInfo().getString("memberId");
        OrderCTools orderCTools=new OrderCTools();
        JSONObject Result=orderCTools.pageOrder(receiverId);
        int before=Integer.parseInt(Result.getJSONObject("result").getString("total"));

        MinCardTools minCardTools=new MinCardTools();
        CouponMIntools.listMemberReceivedCoupon(receiverId,"USED");
        int count1= XMJSONPath.getJSONArrayByReadPath(dataApi.getApi_response(),"$.result").size();//未签约0元单时候，已使用优惠券张数
        JSONObject memberCardResult=minCardTools.fetchOnSaleMemberCard("次卡").getJSONObject("result").getJSONArray("records").getJSONObject(0);
        String id1=memberCardResult.getString("id");
        JSONObject memberCardDetailResult=orderCTools.findTenantCardDetailById(id1,memberId);
        String cardId= memberCardDetailResult.getJSONObject("result").getString("id");
        String latestSnapshotId= memberCardDetailResult.getJSONObject("result").getString("latestSnapshotId");

        CouponMIntools.purchaseCarduseCoupon("PURCHASE",cardId,latestSnapshotId,memberId,cooponid);//使用优惠券购买0元卡

        JSONObject Result1=orderCTools.pageOrder(receiverId);
        int after=Integer.parseInt(Result1.getJSONObject("result").getString("total"));
        Assert.assertEquals(after,before+1);//使用优惠券购买订单后，我的订单+1条数据

        CouponMIntools.listMemberReceivedCoupon(receiverId,"USED");
        int count2= XMJSONPath.getJSONArrayByReadPath(dataApi.getApi_response(),"$.result").size();//已签约0元单时候，已使用优惠券张数
        Assert.assertEquals(count2,count1+1);//使用优惠券后，已使用优惠券+1


    }

}
