package com.xiaomai.cases.polar.course;

import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import com.xiaomai.basetest.BaseTestImpl;
import com.xiaomai.cases.polar.setting.courseCategory.CourseCategoryTools;
import com.xiaomai.enums.ApiModule;
import com.xiaomai.enums.LoginAccount;
import com.xiaomai.enums.RequestType;
import com.xiaomai.enums.Terminal;
import com.xiaomai.utils.TimeUtils;
import org.testng.Assert;
import org.testng.annotations.BeforeClass;
import org.testng.annotations.Test;

import javax.annotation.Resource;
import java.util.Random;

/**
 * @BelongsProject: xm-sportstest
 * @BelongsPackage: com.xiaomai.cases.polar.course
 * @Author: xuyamei
 * @CreateTime: 2024-05-07  14:36
 * @Description: 编辑私教课
 * @Version: 1.0
 */
public class TestEditPersonalCourse extends BaseTestImpl {
    @Resource(name = "courseCategoryTools")
    CourseCategoryTools courseCategoryTools;
    @Resource(name = "courseTools")
    CourseTools courseTools;


    @BeforeClass
    @Override
    public void beforeTest() {
        setTestInfo(ApiModule.Polar_Course, "API_editPersonalCourse", LoginAccount.GYM_PROD, Terminal.B, "xym");
        super.beforeTest();
    }

    @Test
    public void testEditPersonalCourse() {
        String categoryId = courseCategoryTools.getCourseCategoryPage("瑜伽");
        // 查询存量的课程用于编辑
        JSONArray courseIdArray = courseTools.getPersonalOrGroupCourseId("PERSONAL", "存量瑜伽课程", categoryId, "STUDIO", "ONE_TO_MANY", 2, 1);
        try {
            Thread.sleep(3000);
        } catch (InterruptedException e) {
            throw new RuntimeException(e);
        }
        String courseId = courseIdArray.getString(0);

        Random random = new Random();
        JSONObject courseDetail = courseTools.getCourseDetail(courseId);
        int duration = random.nextInt(60)+10;
        int difficulty = random.nextInt(5)+1;
        int capacity = random.nextInt(10)+1;
        String courseName = "存量瑜伽课程"+ TimeUtils.getCurrentTime();

        JSONObject body = new JSONObject();
        body.put("categoryId", categoryId);
        body.put("courseName", courseName);
        body.put("duration", duration);      // 时长
        body.put("difficulty", difficulty);     // 难度
        body.put("color", "#AACF53");
        body.put("coverId", "0");
        body.put("timeUnit", "MINUTE");
        body.put("operatorId", xmAppApi.getLoginInfo().getAdminId());
        body.put("sourceId", xmAppApi.getLoginInfo().getStudioId());  // 来源：场馆、品牌
        body.put("sourceType", "STUDIO");  // 来源类型：场馆、品牌
        body.put("brandId", xmAppApi.getLoginInfo().getBrandId());  // 品牌
        body.put("studioId", xmAppApi.getLoginInfo().getStudioId());
        body.put("sizeType", "ONE_TO_MANY");  // 私教模式
        body.put("allArea", false); // 场地
        JSONArray coachIds = new JSONArray();
        coachIds.add(xmAppApi.getLoginInfo().getAdminId());
        body.put("coachIds", coachIds);
        body.put("capacity", capacity); // 课容量
        body.put("minCapacity", 1); // 开课人数
        body.put("brandCourseId", courseId);

        xmAppApi.doRequest(RequestType.JSON,params,body.toString(),headers).assetsSuccess(true);

        try {
            Thread.sleep(3000);
        } catch (InterruptedException e) {
            throw new RuntimeException(e);
        }
        String[] keys = {"courseName","duration","difficulty","color","coverId","timeUnit","categoryId","sourceId","sourceType","brandId","sizeType","allArea","capacity","minCapacity"};
        String[] values = {courseName,String.valueOf(duration),String.valueOf(difficulty),"#AACF53","0","MINUTE",categoryId,xmAppApi.getLoginInfo().getStudioId(),"STUDIO",xmAppApi.getLoginInfo().getBrandId(),"ONE_TO_MANY","false",String.valueOf(capacity),"1"};
        // 校验内容与编辑的是否一致
        courseDetail = courseTools.getCourseDetail(courseId);
        for (int i = 0; i < keys.length; i++) {
            String result = values[i];
            Assert.assertEquals(courseDetail.getString(keys[i]),result,"编辑之后课程详情与编辑内容不一致");
        }

    }
}
