package com.xiaomai.cases.polar.data.financeData;

import com.alibaba.fastjson.JSONObject;
import com.xiaomai.enums.ApiModule;
import com.xiaomai.enums.LoginAccount;
import com.xiaomai.enums.RequestType;
import com.xiaomai.enums.Terminal;
import com.xiaomai.utils.TimeUtils;
import com.xiaomai.utils.XMBaseTest;
import org.testng.Assert;
import org.testng.annotations.BeforeMethod;
import org.testng.annotations.DataProvider;
import org.testng.annotations.Test;

public class TestGetCostDetail extends XMBaseTest {
    @BeforeMethod
    public void beforeTest(){
        xmAppApi.setApiModule(ApiModule.Polar_Data)
                .setApiName("API_getCostDetail")
                .setLoginUser(LoginAccount.GYM_PROD)
                .setTerminal(Terminal.B);

        dal.setCase_owner("yff")
                .setCase_name(Thread.currentThread().getStackTrace()[1].getFileName().split("\\.")[0]);
        super.beforeTest();
    }

    @DataProvider
    public Object[][] dataProvider(){
        return new Object[][]{
                {"DAY","LEFT_AMOUNT_ASC","MEMBER_CARD",TimeUtils.getTodayEndTime(),TimeUtils.getTodayTime()},//今天,排序：待消耗金额正序
                {"MONTH","LEFT_AMOUNT_DESC","EXPERIENCE_CARD",TimeUtils.getMonthLastDay(),TimeUtils.getMonthFristDay()},//本月,排序：待消耗金额倒序
                {"DAY","CONFIRMED_AMOUNT_ASC", "TRAINING_CAMP",TimeUtils.getTodayEndTime(),TimeUtils.getTodayTime()},//今天,排序：确认金额正序
                {"MONTH","CONFIRMED_AMOUNT_DESC","DEPOSIT_CARD",TimeUtils.getMonthLastDay(),TimeUtils.getMonthFristDay()},//本月,排序：确认金额倒序
                {"DAY","LEFT_AMOUNT_ASC", "SINGLE_RESERVE",TimeUtils.getTodayEndTime(),TimeUtils.getTodayTime()}//今天,排序：待消耗金额正序

        };
    }

    @Test(description = "获取数据中心-财务数据-营收明细：按天、按月以及各种排序各种类型筛选的营收明细",dataProvider = "dataProvider")
    public void testGetCostDetail(String dateType, String sort,String type, long endTime,long startTime){

        JSONObject getCostDetail=new JSONObject();
        getCostDetail.put("dateType",dateType);
        getCostDetail.put("memberId","");
        getCostDetail.put("campId","");
        getCostDetail.put("depositId","");
        getCostDetail.put("sort",sort);
        getCostDetail.put("type",type);
        getCostDetail.put("itemId","");
        getCostDetail.put("endTime",endTime);
        getCostDetail.put("startTime",startTime);
        getCostDetail.put("brandId",xmAppApi.getLoginInfo().getBrandId());
        getCostDetail.put("studioId",xmAppApi.getLoginInfo().getStudioId());
        getCostDetail.put("operatorId",xmAppApi.getLoginInfo().getAdminId());


        xmAppApi.doRequest(RequestType.JSON,params,getCostDetail.toJSONString(),headers).assetsSuccess(true);
        String getOrderDetailResult=xmAppApi.getBodyInJSON().getString("success");
        Assert.assertEquals(getOrderDetailResult,"true","获取数据中心-财务数据-营收明细失败");
    }


    @DataProvider
    public Object[][] dataProvider1(){
        return new Object[][]{
                {"WEEK","LEFT_AMOUNT_ASC","MEMBER_CARD",TimeUtils.getWeekLastTime(),TimeUtils.getWeekFirstTime()},//本周,排序：待消耗金额正序
                {"WEEK","LEFT_AMOUNT_DESC","EXPERIENCE_CARD",TimeUtils.getWeekLastTime(),TimeUtils.getWeekFirstTime()},//本周,排序：待消耗金额倒序
                {"WEEK","CONFIRMED_AMOUNT_ASC","TRAINING_CAMP",TimeUtils.getWeekLastTime(),TimeUtils.getWeekFirstTime()},//本周,排序：确认金额正序
                {"WEEK","CONFIRMED_AMOUNT_DESC","DEPOSIT_CARD",TimeUtils.getWeekLastTime(),TimeUtils.getWeekFirstTime()},//本周,排序：确认金额倒序
                {"WEEK","LEFT_AMOUNT_ASC","SINGLE_RESERVE",TimeUtils.getWeekLastTime(),TimeUtils.getWeekFirstTime()},//本周,排序：待消耗金额正序
        };
    }


    @Test(description = "获取数据中心-财务数据-营收明细：按周以及各种排序各种类型筛选的营收明细",dataProvider = "dataProvider1")
    public void testGetCostDetail1(String dateType,String sort,String type,String endTime,String startTime){

        JSONObject getCostDetail=new JSONObject();
        getCostDetail.put("dateType",dateType);
        getCostDetail.put("memberId","");
        getCostDetail.put("campId","");
        getCostDetail.put("depositId","");
        getCostDetail.put("sort",sort);
        getCostDetail.put("type",type);
        getCostDetail.put("itemId","");
        getCostDetail.put("endTime",endTime);
        getCostDetail.put("startTime",startTime);
        getCostDetail.put("brandId",xmAppApi.getLoginInfo().getBrandId());
        getCostDetail.put("studioId",xmAppApi.getLoginInfo().getStudioId());
        getCostDetail.put("operatorId",xmAppApi.getLoginInfo().getAdminId());

        xmAppApi.doRequest(RequestType.JSON,params,getCostDetail.toJSONString(),headers).assetsSuccess(true);
        String getOrderDetailResult=xmAppApi.getBodyInJSON().getString("success");
        Assert.assertEquals(getOrderDetailResult,"true","获取数据中心-财务数据-营收明细失败");

    }

}
