package com.xiaomai.cases.polar.data.salesData;

import com.alibaba.fastjson.JSONObject;
import com.xiaomai.enums.ApiModule;
import com.xiaomai.enums.LoginAccount;
import com.xiaomai.enums.RequestType;
import com.xiaomai.enums.Terminal;
import com.xiaomai.utils.TimeUtils;
import com.xiaomai.utils.XMBaseTest;
import org.testng.Assert;
import org.testng.annotations.BeforeMethod;
import org.testng.annotations.DataProvider;
import org.testng.annotations.Test;

/**
 * @Author zxy
 * @Description
 * @Date 2024/11/15 14:06
 */
public class TestSaleRank extends XMBaseTest {
    @BeforeMethod
    public void beforeTest(){
        xmAppApi.setApiModule(ApiModule.Polar_Data)
                .setApiName("API_saleRank")
                .setLoginUser(LoginAccount.GYM_PROD)
                .setTerminal(Terminal.B);

        dal.setCase_owner("zyx")
                .setCase_name(Thread.currentThread().getStackTrace()[1].getFileName().split("\\.")[0]);
        super.beforeTest();
    }
    @DataProvider
    public Object[][] data(){
        return new Object[][]{
                {"DAY","SIGN_MEMBER_COUNT", TimeUtils.getWeekLastTime(),TimeUtils.getWeekFirstTime()},//按签单会员数，本周
                {"DAY","SIGN_ACTUAL_AMOUNT",TimeUtils.getWeekLastTime(),TimeUtils.getWeekFirstTime()},//按签单实收金额，本周
        };
    }
    @Test(description = "销售排行",dataProvider = "data")
    public void testSaleRank(String dateType,String sort,String endTime,String startTime){
        JSONObject object=new JSONObject();
        object.put("dateType",dateType);
        object.put("endTime", endTime);
        object.put("startTime", startTime);
        object.put("sort",sort);
        object.put("current",0);
        object.put("size",6);
        object.put("brandId",xmAppApi.getLoginInfo().getBrandId());
        object.put("studioId",xmAppApi.getLoginInfo().getStudioId());
        object.put("operatorId",xmAppApi.getLoginInfo().getAdminId());

        xmAppApi.doRequest(RequestType.JSON,params,object.toJSONString(),headers).assetsSuccess(true);
        String trendResult=xmAppApi.getBodyInJSON().getString("success");
        Assert.assertEquals(trendResult,"true","获取销售排行失败");

    }
}
