package com.xiaomai.cases.polar.eleContract;

import com.alibaba.fastjson.JSONObject;
import com.xiaomai.basetest.BaseTestImpl;
import com.xiaomai.enums.ApiModule;
import com.xiaomai.enums.LoginAccount;
import com.xiaomai.enums.RequestType;
import com.xiaomai.enums.Terminal;
import org.testng.Assert;
import org.testng.annotations.BeforeMethod;
import org.testng.annotations.Test;

/**
 * @BelongsProject: xm-sportstest
 * @BelongsPackage: com.xiaomai.cases.polar.eleContract
 * @Author: xuyamei
 * @CreateTime: 2024-08-05  15:33
 * @Description:获取合同充值套餐列表
 * @Version: 1.0
 */
public class TestGetSuiteList extends BaseTestImpl {
    @BeforeMethod
    @Override
    public void beforeTest(){
        setTestInfo(ApiModule.Polar_EleContract,"API_getSuiteList", LoginAccount.DZHT_PROD, Terminal.B,"xym");
        super.beforeTest();
    }

    @Test
    public void testGetValidBalanceList() {
        JSONObject body = new JSONObject();
        body.put("brandId", xmAppApi.getLoginInfo().getBrandId());
        body.put("studioId", xmAppApi.getLoginInfo().getStudioId());
        body.put("operatorId", xmAppApi.getLoginInfo().getAdminId());

        xmAppApi.doRequest(RequestType.JSON, params, body.toString(), headers).assetsSuccess(true);

        String[] keys = new String[]{"productCode","productName","validPeriodYear","amount","price","oriUnitPrice","unitPrice"};
        String[] values1 = new String[]{"E_CONT_100_1Y","电子合同100份","1","100","49800","698","498"};
        String[] values2 = new String[]{"E_CONT_200_1Y","电子合同200份","1","200","79600","598","398"};
        String[] values3 = new String[]{"E_CONT_500_2Y","电子合同500份","2","500","149000","498","298"};
        String[] values4 = new String[]{"E_CONT_1000_2Y","电子合同1000份","2","1000","198000","398","198"};

        for (int i = 0; i < 4; i++){
            String[] values = i == 0 ? values1 : i == 1 ? values2 : i == 2 ? values3 : values4;
            for (int j = 0; j < keys.length; j++){
                Assert.assertEquals(xmAppApi.getBodyInJSON().getJSONArray("result").getJSONObject(i).getString(keys[j]),values[j]);
            }
        }
    }
}
