package com.xiaomai.cases.polar.eleContract;

import com.xiaomai.basetest.BaseTestImpl;
import com.xiaomai.enums.ApiModule;
import com.xiaomai.enums.LoginAccount;
import com.xiaomai.enums.RequestType;
import com.xiaomai.enums.Terminal;
import org.testng.Assert;
import org.testng.annotations.BeforeMethod;
import org.testng.annotations.Test;

/**
 * @BelongsProject: xm-sportstest
 * @BelongsPackage: com.xiaomai.cases.polar.eleContract
 * @Author: xuyamei
 * @CreateTime: 2024-08-06  16:46
 * @Description: 获取租户是否购买结果
 * @Version: 1.0
 */
public class TestGetTenantPurchaseFlag extends BaseTestImpl {
    @BeforeMethod
    @Override
    public void beforeTest(){
        setTestInfo(ApiModule.Polar_EleContract,"API_getTenantPurchaseFlag", LoginAccount.DZHT_PROD, Terminal.B,"xym");
        super.beforeTest();
    }

    @Test
    public void testGetTenantPurchaseFlag(){
        String body = "{\"tenantId\":\""+xmAppApi.getLoginInfo().getStudioId()+"\"}";
        xmAppApi.doRequest(RequestType.JSON,params,body,headers).assetsSuccess(true);

        Assert.assertTrue(xmAppApi.getBodyInJSON().getBoolean("result"),"场馆已经购买但是返回的false");
    }



}
