package com.xiaomai.cases.polar.entry;

import com.alibaba.fastjson.JSONObject;
import com.xiaomai.enums.ApiModule;
import com.xiaomai.enums.LoginAccount;
import com.xiaomai.enums.RequestType;
import com.xiaomai.enums.Terminal;
import com.xiaomai.utils.XMBaseTest;
import org.testng.Assert;
import org.testng.annotations.BeforeMethod;
import org.testng.annotations.DataProvider;
import org.testng.annotations.Test;

/**
 * @Author zxy
 * @Description
 * @Date 2024/11/5 14:42
 */
public class TestSaveEntryRule extends XMBaseTest {
    EntryTool entryTool = new EntryTool();
    @BeforeMethod
    public void beforeTest(){

        xmAppApi.setApiModule(ApiModule.Polar_MemberEntry)
                .setApiName("API_memberEntryRuleSave")
                .setLoginUser(LoginAccount.GYM_PROD)
                .setTerminal(Terminal.B);

        dal.setCase_owner("zyx")
                .setCase_name(Thread.currentThread().getStackTrace()[1].getFileName().split("\\.")[0]);
        super.beforeTest();
    }
    @DataProvider()
    public Object[][] data(){
        return new Object[][]{
                {"MEMBER_CARD_ENTRY","FALSE"},//不支持凭会员卡入场
                {"MEMBER_CARD_ENTRY","TRUE"},//支持凭会员卡入场
                {"MEMBER_CARD_REPEAT_ENTRY","FALSE"},//不支持凭体验卡入场
                {"MEMBER_CARD_REPEAT_ENTRY","TRUE"},//支持凭体验卡入场
                {"EXPERIENCE_CARD_ENTRY","FALSE"},
                {"EXPERIENCE_CARD_ENTRY","TRUE"},
                {"EXPERIENCE_CARD_REPEAT_ENTRY","FALSE"},
                {"EXPERIENCE_CARD_REPEAT_ENTRY","TRUE"},
                {"RESERVE_ENTRY","FALSE"},//不支持凭约课记录入场
                {"RESERVE_ENTRY","TRUE"},//支持凭约课记录入场
                {"RESERVE_ENTRY_TIME_LIMIT","TRUE"},
                {"RESERVE_ENTRY_LEAD_MINUTES","15"},//开课前15分钟支持入场
                {"RESERVE_ENTRY_LAG_MINUTES","30"},//开课后30分钟支持入场
                {"RESERVE_ENTRY_TIME_LIMIT","FALSE"},//进场时间限制


        };
    }
    @Test(dataProvider = "data",description = "保存入场规则")
    public void testSaveEntryRule(String code,String value){
        JSONObject object = new JSONObject();
        object.put("code",code);
        object.put("value",value);
        object.put("studioId",xmAppApi.getLoginInfo().getStudioId());
        object.put("brandId",xmAppApi.getLoginInfo().getBrandId());
        object.put("operatorId",xmAppApi.getLoginInfo().getAdminId());

        xmAppApi.doRequest(RequestType.JSON,params,object.toString(),headers).assetsSuccess(true);

        Assert.assertEquals(entryTool.entryRuleList().getJSONObject("result").getJSONObject("ruleMap").getString(code),value);
    }
}
