package com.xiaomai.cases.polar.enums;

import org.apache.commons.lang3.StringUtils;

/**
 * @Author zxy
 * @Description
 * @Date 2024/7/2 17:48
 */
public enum ExcelImportEnum {
    MEMBER_INFO("memberInfo",3,0,1),
    DEPOSIT_INFO("depositInfo",3,0,1);

    /**业务  */
    private String value;
    /**行开始下标（从0开始）  */
    private int rowStartIndex;
    /**姓名列坐标  */
    private int cellNametIndex;
    /**手机号列坐标  */
    private int cellPhoneIndex;

    ExcelImportEnum(String value, int rowStartIndex, int cellNametIndex, int cellPhoneIndex) {
        this.value = value;
        this.rowStartIndex = rowStartIndex;
        this.cellNametIndex = cellNametIndex;
        this.cellPhoneIndex = cellPhoneIndex;
    }

    ExcelImportEnum(String value, int rowStartIndex, int cellPhoneIndex) {
        this.value = value;
        this.rowStartIndex = rowStartIndex;
        this.cellPhoneIndex = cellPhoneIndex;
    }

    public String getValue() {
        return value;
    }

    public void setValue(String value) {
        this.value = value;
    }

    public int getRowStartIndex() {
        return rowStartIndex;
    }

    public void setRowStartIndex(int rowStartIndex) {
        this.rowStartIndex = rowStartIndex;
    }

    public int getCellNametIndex() {
        return cellNametIndex;
    }

    public void setCellNametIndex(int cellNametIndex) {
        this.cellNametIndex = cellNametIndex;
    }

    public int getCellPhoneIndex() {
        return cellPhoneIndex;
    }

    public void setCellPhoneIndex(int cellPhoneIndex) {
        this.cellPhoneIndex = cellPhoneIndex;
    }
    /**
     *根据value获取对应枚举
     * value找不对应的枚举,则返回一个默认值
     * @param  value
     * @return
    }
     */
    public static int getRowIndexByValue(String value) {
        for (ExcelImportEnum excelImportBusinessEnum : ExcelImportEnum.values()) {
            if (StringUtils.equals(excelImportBusinessEnum.getValue(), value)) {
                return excelImportBusinessEnum.rowStartIndex;
            }
        }
        return 0;
    }

    public static int getNameCellIndexByValue(String value) {
        for (ExcelImportEnum excelImportBusinessEnum : ExcelImportEnum.values()) {
            if (StringUtils.equals(excelImportBusinessEnum.getValue(), value)) {
                return excelImportBusinessEnum.cellNametIndex;
            }
        }
        return 0;
    }

    public static int getPhoneCellIndexByValue(String value) {
        for (ExcelImportEnum excelImportBusinessEnum : ExcelImportEnum.values()) {
            if (StringUtils.equals(excelImportBusinessEnum.getValue(), value)) {
                return excelImportBusinessEnum.cellPhoneIndex;
            }
        }
        return 1;
    }
}
