package com.xiaomai.cases.polar.finance.axf;

import com.xiaomai.basetest.BaseTestImpl;
import com.xiaomai.enums.ApiModule;
import com.xiaomai.enums.LoginAccount;
import com.xiaomai.enums.RequestType;
import com.xiaomai.enums.Terminal;
import org.testng.Assert;
import org.testng.annotations.BeforeMethod;
import org.testng.annotations.Test;

/**
 * @BelongsProject: xm-sportstest
 * @BelongsPackage: com.xiaomai.cases.polar.finance.axf
 * @Author: xuyamei
 * @CreateTime: 2024-12-25  15:34
 * @Description: 查询最新的申请
 * @Version: 1.0
 */
public class TestAxfGetLatestApply extends BaseTestImpl {
    @BeforeMethod
    @Override
    public void beforeTest(){
        setTestInfo(ApiModule.Polar_Finance,"API_axf_getLatestApply", LoginAccount.GYM_PROD, Terminal.B,"xym");
        super.beforeTest();
    }

    @Test
    public void testAxfGetLatestApply(){
        String str = "{\"studioId\":\""+xmAppApi.getLoginInfo().getStudioId()+"\",\"brandId\":\""+xmAppApi.getLoginInfo().getBrandId()+"\",\"operatorId\":\""+xmAppApi.getLoginInfo().getAdminId()+"\"}";
        xmAppApi.doRequest(RequestType.JSON, params,str,headers).assetsSuccess(true);
        //校验校区的商户号PID与预期的一致
        Assert.assertEquals(xmAppApi.getBodyInJSON().getJSONObject("result").getString("merchantNo"),"2088460274140455","PID返回错误");
        Assert.assertEquals(xmAppApi.getBodyInJSON().getJSONObject("result").getString("state"),"SETTLE_SUCCESS","状态是申请成功");

    }
}
