package com.xiaomai.cases.polar.finance.axf;

import com.alibaba.fastjson.JSONObject;
import com.xiaomai.basetest.BaseTestImpl;
import com.xiaomai.enums.ApiModule;
import com.xiaomai.enums.LoginAccount;
import com.xiaomai.enums.RequestType;
import com.xiaomai.enums.Terminal;
import org.testng.Assert;
import org.testng.annotations.BeforeMethod;
import org.testng.annotations.Test;

/**
 * @BelongsProject: xm-sportstest
 * @BelongsPackage: com.xiaomai.cases.polar.finance.axf
 * @Author: xuyamei
 * @CreateTime: 2024-12-25  16:10
 * @Description: 是否存在失败扣款的数据
 * @Version: 1.0
 */
public class TestExistFailDeduction extends BaseTestImpl {
    AXFTools axfTools = new AXFTools();

    @BeforeMethod
    @Override
    public void beforeTest(){
        setTestInfo(ApiModule.Polar_Finance,"API_existFailDeduction", LoginAccount.GYM_PROD, Terminal.B,"xym");
        super.beforeTest();
    }

    @Test
    public void testExistFailDeduction() {
        // 查询签约成功的列表数据 且有扣款数据
        String body = "{\"current\":0,\"size\":20,\"studioId\":\""+xmAppApi.getLoginInfo().getStudioId()+"\",\"brandId\":\""+xmAppApi.getLoginInfo().getBrandId()+"\",\"commodityCardType\":\"DEPOSIT_CARD\",\"voucherBusinessNo\":null,\"thirdOrderNo\":null,\"operatorId\":\""+xmAppApi.getLoginInfo().getAdminId()+"\"}";
        JSONObject response = axfTools.getAXFPageOrder(body);
        // 查询列表数据
        int total = response.getJSONObject("result").getJSONArray("records").size();
        String id = "";
        for (int i = 0; i < total; i++){
            double receivedAmount = response.getJSONObject("result").getJSONArray("records").getJSONObject(i).getDouble("receivedAmount");
            if (receivedAmount > 0){
                // 查询详情数据
                id = response.getJSONObject("result").getJSONArray("records").getJSONObject(i).getString("id");
                break;
            }
        }

        body = "{\"id\":\""+id+"\",\"studioId\":\""+xmAppApi.getLoginInfo().getStudioId()+"\",\"brandId\":\""+xmAppApi.getLoginInfo().getBrandId()+"\",\"operatorId\":\""+xmAppApi.getLoginInfo().getAdminId()+"\"}";
        xmAppApi.doRequest(RequestType.JSON,params,body,headers).assetsSuccess(true);
        response = xmAppApi.getBodyInJSON();
        Assert.assertEquals(response.getString("result"),"NO");
    }



}
