package com.xiaomai.cases.polar.finance.salary;

import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import com.xiaomai.basetest.BaseTestImpl;
import com.xiaomai.enums.ApiModule;
import com.xiaomai.enums.RequestType;
import com.xiaomai.enums.Terminal;

/**
 * @BelongsProject: xm-sportstest
 * @BelongsPackage: com.xiaomai.cases.polar.finance.salary
 * @Author: xuyamei
 * @CreateTime: 2024-11-06  17:26
 * @Description: 工资工具类
 * @Version: 1.0
 */
public class SalaryTools extends BaseTestImpl {

    /**
     * @description:查询工资条项目
     * @author: xuyamei
     * @date:  2024/11/6 17:28
     * @param
     * @return: com.alibaba.fastjson.JSONArray
     **/
   public JSONArray listSettleItem(){
       dataApi.setApiModule(ApiModule.Polar_Salary)
               .setApiName("API_settleItem_listByStudioId")
               .setTerminal(Terminal.B);

       super.beforeDataRequest();

       JSONObject jsonObject=new JSONObject();
       jsonObject.put("brandId",xmAppApi.getLoginInfo().getBrandId());
       jsonObject.put("studioId",xmAppApi.getLoginInfo().getStudioId());
       jsonObject.put("operatorId",xmAppApi.getLoginInfo().getAdminId());

       dataApi.doRequest(RequestType.JSON,dataparams,jsonObject.toJSONString(),dataheadrs).assetsSuccess(true);
       return dataApi.getBodyInJSON().getJSONArray("result");
   }


    /**
     * @description:删除工资条项目
     * @author: xuyamei
     * @date:  2024/11/6 17:40
     * @param id：工资条项目id
     * @return: void
     **/
    public void deleteSettleItem(String id){
       dataApi.setApiModule(ApiModule.Polar_Salary)
               .setApiName("API_settleItem_delete")
               .setTerminal(Terminal.B);

       super.beforeDataRequest();

        JSONObject jsonObject=new JSONObject();
        jsonObject.put("brandId",dataApi.getLoginInfo().getBrandId());
        jsonObject.put("studioId",dataApi.getLoginInfo().getStudioId());
        jsonObject.put("operatorId",dataApi.getLoginInfo().getAdminId());
        jsonObject.put("id",id);

        dataApi.doRequest(RequestType.JSON,dataparams,jsonObject.toJSONString(),dataheadrs).assetsSuccess(true);

    }

    /**
     * @description:创建工资条项目
     * @author: xuyamei
     * @date:  2024/11/6 18:16
     * @param type
     * @param title
     * @return: java.lang.String
     **/
    public String createSettleItem(String type,String title){
        dataApi.setApiModule(ApiModule.Polar_Salary)
                .setApiName("API_settleItem_create")
                .setTerminal(Terminal.B);

        super.beforeDataRequest();

        JSONObject jsonObject=new JSONObject();
        jsonObject.put("brandId",dataApi.getLoginInfo().getBrandId());
        jsonObject.put("studioId",dataApi.getLoginInfo().getStudioId());
        jsonObject.put("operatorId",dataApi.getLoginInfo().getAdminId());
        jsonObject.put("adjustType",type); // PLUS 加钱，MINUS 扣钱
        jsonObject.put("title",title); // 工资条项目名称
        jsonObject.put("id","");
        
        dataApi.doRequest(RequestType.JSON,dataparams,jsonObject.toJSONString(),dataheadrs).assetsSuccess(true);
        return dataApi.getBodyInJSON().getString("result");
    }


    /**
     * @description:查询工资模版列表数据
     * @author: xuyamei
     * @date:  2024/11/7 16:19
     * @param adminId：员工id
     * @return: com.alibaba.fastjson.JSONArray
     **/
    public JSONArray fetchPageOfTemplate(String adminId){
        dataApi.setApiModule(ApiModule.Polar_Salary)
                .setApiName("API_fetchPageOfTemplate")
                .setTerminal(Terminal.B);

        super.beforeDataRequest();

        JSONObject jsonObject=new JSONObject();
        jsonObject.put("brandId",dataApi.getLoginInfo().getBrandId());
        jsonObject.put("studioId",dataApi.getLoginInfo().getStudioId());
        jsonObject.put("operatorId",dataApi.getLoginInfo().getAdminId());
        jsonObject.put("size",20);
        jsonObject.put("current",0);
        jsonObject.put("adminId",adminId);

        dataApi.doRequest(RequestType.JSON,dataparams,jsonObject.toJSONString(),dataheadrs).assetsSuccess(true);
        return dataApi.getBodyInJSON().getJSONObject("result").getJSONArray("records");
    }


    /**
     * @description:工资模版详情
     * @author: xuyamei
     * @date:  2024/11/7 16:26
     * @param id：模版id
     * @return: com.alibaba.fastjson.JSONObject
     **/
    public JSONObject findDetailById(String id){
        dataApi.setApiModule(ApiModule.Polar_Salary)
                .setApiName("API_settleTemplate_findDetailById")
                .setTerminal(Terminal.B);

        super.beforeDataRequest();

        JSONObject jsonObject=new JSONObject();
        jsonObject.put("brandId",dataApi.getLoginInfo().getBrandId());
        jsonObject.put("studioId",dataApi.getLoginInfo().getStudioId());
        jsonObject.put("operatorId",dataApi.getLoginInfo().getAdminId());
        jsonObject.put("id",id);
        dataApi.doRequest(RequestType.JSON,dataparams,jsonObject.toJSONString(),dataheadrs).assetsSuccess(true);
        return dataApi.getBodyInJSON().getJSONObject("result");
    }



    /**
     * @description:删除工资模版
     * @author: xuyamei
     * @date:  2024/11/7 16:30
     * @param id：模版id
     * @return: com.alibaba.fastjson.JSONObject
     **/
    public void deleteTemplate(String id){
        dataApi.setApiModule(ApiModule.Polar_Salary)
                .setApiName("API_settleTemplate_delete")
                .setTerminal(Terminal.B);

        super.beforeDataRequest();

        JSONObject jsonObject=new JSONObject();
        jsonObject.put("brandId",dataApi.getLoginInfo().getBrandId());
        jsonObject.put("studioId",dataApi.getLoginInfo().getStudioId());
        jsonObject.put("operatorId",dataApi.getLoginInfo().getAdminId());
        jsonObject.put("id",id);
        dataApi.doRequest(RequestType.JSON,dataparams,jsonObject.toJSONString(),dataheadrs).assetsSuccess(true);
    }


    /**
     * @description:编辑工资条模版
     * @author: xuyamei
     * @date:  2024/11/7 16:57
     * @param body：请求参数
     * @return: void
     **/
    public void updateTemplate(JSONObject body){
        dataApi.setApiModule(ApiModule.Polar_Salary)
                .setApiName("API_settleTemplate_update")
                .setTerminal(Terminal.B);

        super.beforeDataRequest();

        dataApi.doRequest(RequestType.JSON,dataparams,body.toJSONString(),dataheadrs).assetsSuccess(true);
    }


    /**
     * @description:查询员工
     * @author: xuyamei
     * @date:  2024/11/7 17:08
     * @param hasTemplate 是否有模版 在工资模版传false、在工资结算单传true
     * @param searchContext 搜索员工手机号或者昵称
     * @param currentSettleTemplateId 当前模版id（编辑模版时用到）
     * @return: com.alibaba.fastjson.JSONArray
     **/
    public JSONArray fetchStaff(boolean hasTemplate,String searchContext,String currentSettleTemplateId){
        dataApi.setApiModule(ApiModule.Polar_Salary)
                .setApiName("API_fetchStaff")
                .setTerminal(Terminal.B);

        super.beforeDataRequest();

        JSONObject jsonObject=new JSONObject();
        jsonObject.put("brandId",dataApi.getLoginInfo().getBrandId());
        jsonObject.put("studioId",dataApi.getLoginInfo().getStudioId());
        jsonObject.put("operatorId",dataApi.getLoginInfo().getAdminId());
        jsonObject.put("current",0);
        jsonObject.put("size",20);
        jsonObject.put("state","DUTY");
        jsonObject.put("hasTemplate",hasTemplate);
        jsonObject.put("searchContext",searchContext);
        jsonObject.put("currentSettleTemplateId",currentSettleTemplateId);

        dataApi.doRequest(RequestType.JSON,dataparams,jsonObject.toJSONString(),dataheadrs).assetsSuccess(true);
        return dataApi.getBodyInJSON().getJSONObject("result").getJSONArray("records");

    }

    /**
     * @description:查询工资结算单列表
     * @author: xuyamei
     * @date:  2024/11/8 11:16
     * @param body ：请求参数
     * @return: com.alibaba.fastjson.JSONArray
     **/
    public JSONArray searchSettle(String body){
        dataApi.setApiModule(ApiModule.Polar_Salary)
                .setApiName("API_settle_search")
                .setTerminal(Terminal.B);

        super.beforeDataRequest();

        dataApi.doRequest(RequestType.JSON,dataparams,body,dataheadrs).assetsSuccess(true);
        return dataApi.getBodyInJSON().getJSONObject("result").getJSONArray("records");

    }

    /**
     * @description:获取工资结算单详情
     * @author: xuyamei
     * @date:  2024/11/8 13:59
     * @param id ：结算记录id
     * @return: com.alibaba.fastjson.JSONObject
     **/
    public JSONObject fetchRecordById(String id){
        dataApi.setApiModule(ApiModule.Polar_Salary)
                .setApiName("API_fetchRecordById")
                .setTerminal(Terminal.B);

        super.beforeDataRequest();

        JSONObject jsonObject=new JSONObject();
        jsonObject.put("brandId",dataApi.getLoginInfo().getBrandId());
        jsonObject.put("studioId",dataApi.getLoginInfo().getStudioId());
        jsonObject.put("operatorId",dataApi.getLoginInfo().getAdminId());
        jsonObject.put("id",id);
        dataApi.doRequest(RequestType.JSON,dataparams,jsonObject.toJSONString(),dataheadrs).assetsSuccess(true);

        return dataApi.getBodyInJSON().getJSONObject("result");


    }

    /**
     * @description:列表查询员工结算明细
     * @author: xuyamei
     * @date:  2024/11/8 14:03
     * @param id:结算记录id
     * @return: com.alibaba.fastjson.JSONArray
     **/
    public JSONArray fetchSettleResult(String id){
        dataApi.setApiModule(ApiModule.Polar_Salary)
                .setApiName("API_fetchSettleResult")
                .setTerminal(Terminal.B);

        super.beforeDataRequest();

        JSONObject jsonObject=new JSONObject();
        jsonObject.put("brandId",dataApi.getLoginInfo().getBrandId());
        jsonObject.put("studioId",dataApi.getLoginInfo().getStudioId());
        jsonObject.put("operatorId",dataApi.getLoginInfo().getAdminId());
        jsonObject.put("settleRecordId",id);
        jsonObject.put("size",20);
        jsonObject.put("current",0);


        dataApi.doRequest(RequestType.JSON,dataparams,jsonObject.toJSONString(),dataheadrs).assetsSuccess(true);
        return dataApi.getBodyInJSON().getJSONObject("result").getJSONArray("records");

    }


    /**
     * @description:获取员工工资明细详情
     * @author: xuyamei
     * @date:  2024/11/8 14:46
     * @param id 结算记录明细id
     * @return:
     **/
    public JSONObject fetchSettleResultDetailById(String id){
        dataApi.setApiModule(ApiModule.Polar_Salary)
                .setApiName("API_fetchSettleResultDetailById")
                .setTerminal(Terminal.B);

        super.beforeDataRequest();

        JSONObject jsonObject=new JSONObject();
        jsonObject.put("brandId",dataApi.getLoginInfo().getBrandId());
        jsonObject.put("studioId",dataApi.getLoginInfo().getStudioId());
        jsonObject.put("operatorId",dataApi.getLoginInfo().getAdminId());
        jsonObject.put("id",id);

        dataApi.doRequest(RequestType.JSON,dataparams,jsonObject.toJSONString(),dataheadrs).assetsSuccess(true);
        return dataApi.getBodyInJSON().getJSONObject("result");

    }


    /**
     * @description:更新员工结算单明细
     * @author: xuyamei
     * @date:  2024/11/8 15:00
     * @param id
     * @param billItemList
     * @return: void
     **/
    public void updateSettleResult(String id,JSONArray billItemList){
        dataApi.setApiModule(ApiModule.Polar_Salary)
                .setApiName("API_updateSettleResult")
                .setTerminal(Terminal.B);

        super.beforeDataRequest();

        JSONObject jsonObject=new JSONObject();
        jsonObject.put("brandId",dataApi.getLoginInfo().getBrandId());
        jsonObject.put("studioId",dataApi.getLoginInfo().getStudioId());
        jsonObject.put("operatorId",dataApi.getLoginInfo().getAdminId());
        jsonObject.put("id",id);
        jsonObject.put("billItemList",billItemList);

        dataApi.doRequest(RequestType.JSON,dataparams,jsonObject.toJSONString(),dataheadrs).assetsSuccess(true);

    }


    /**
     * @description:确认结算
     * @author: xuyamei
     * @date:  2024/11/8 15:30
     * @param id：结算单id
     * @return: void
     **/
    public void confirmSettle(String id){
        dataApi.setApiModule(ApiModule.Polar_Salary)
                .setApiName("API_settle_confirm")
                .setTerminal(Terminal.B);

        super.beforeDataRequest();

        JSONObject jsonObject=new JSONObject();
        jsonObject.put("brandId",dataApi.getLoginInfo().getBrandId());
        jsonObject.put("studioId",dataApi.getLoginInfo().getStudioId());
        jsonObject.put("operatorId",dataApi.getLoginInfo().getAdminId());
        jsonObject.put("id",id);
        dataApi.doRequest(RequestType.JSON,dataparams,jsonObject.toJSONString(),dataheadrs).assetsSuccess(true);

    }


    /**
     * @description:删除结算单
     * @author: xuyamei
     * @date:  2024/11/8 15:31
     * @param id：结算单id
     * @return: void
     **/
    public void deleteSettle(String id){
        dataApi.setApiModule(ApiModule.Polar_Salary)
                .setApiName("API_settle_delete")
                .setTerminal(Terminal.B);

        super.beforeDataRequest();

        JSONObject jsonObject=new JSONObject();
        jsonObject.put("brandId",dataApi.getLoginInfo().getBrandId());
        jsonObject.put("studioId",dataApi.getLoginInfo().getStudioId());
        jsonObject.put("operatorId",dataApi.getLoginInfo().getAdminId());
        jsonObject.put("id",id);
        dataApi.doRequest(RequestType.JSON,dataparams,jsonObject.toJSONString(),dataheadrs).assetsSuccess(true);

    }


}
