package com.xiaomai.cases.polar.finance.salary;

import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import com.xiaomai.basetest.BaseTestImpl;
import com.xiaomai.enums.ApiModule;
import com.xiaomai.enums.LoginAccount;
import com.xiaomai.enums.RequestType;
import com.xiaomai.enums.Terminal;
import org.testng.Assert;
import org.testng.annotations.BeforeMethod;
import org.testng.annotations.DataProvider;
import org.testng.annotations.Test;

/**
 * @BelongsProject: xm-sportstest
 * @BelongsPackage: com.xiaomai.cases.polar.finance.salary
 * @Author: xuyamei
 * @CreateTime: 2024-11-06  16:44
 * @Description: 创建、删除工资条项目
 * @Version: 1.0
 */
public class TestSettleItemCreate extends BaseTestImpl {
    SalaryTools salaryTools = new SalaryTools();
    JSONArray items = new JSONArray();
    @BeforeMethod
    @Override
    public void beforeTest(){
        setTestInfo(ApiModule.Polar_Salary,"API_settleItem_create", LoginAccount.GYM_PROD, Terminal.B,"xym");
        super.beforeTest();
    }

    @DataProvider
    public Object[][] dataProvider(){
        return new Object[][]{
                {"PLUS","自定义加钱工资条项目"},
                {"MINUS","自定义扣钱工资条项目"}
        };
    }
    @Test( dataProvider = "dataProvider")
    public void testSettleItemCreate(String type,String title){
        JSONObject jsonObject=new JSONObject();
        jsonObject.put("brandId",xmAppApi.getLoginInfo().getBrandId());
        jsonObject.put("studioId",xmAppApi.getLoginInfo().getStudioId());
        jsonObject.put("operatorId",xmAppApi.getLoginInfo().getAdminId());
        jsonObject.put("adjustType",type); // PLUS 加钱，MINUS 扣钱
        jsonObject.put("title",title); // 工资条项目名称
        jsonObject.put("id","");
        xmAppApi.doRequest(RequestType.JSON,params,jsonObject.toJSONString(),headers).assetsSuccess(true);
        JSONObject response = xmAppApi.getBodyInJSON();
        String id = response.getString("result");
        items.add(id); //存储id，用于删除

        try {
            Thread.sleep(2000);
        } catch (InterruptedException e) {
            throw new RuntimeException(e);
        }
        JSONArray listSettleItem = salaryTools.listSettleItem();
        boolean flag = false;
        for (int i = 0; i < listSettleItem.size(); i++) {
            if(listSettleItem.getJSONObject(i).getString("id").equals(id)){
                flag = true;
                break;
            }
        }
        Assert.assertEquals(true,flag,"创建工资条项目失败");

    }

    @Test
    public void testSettleItemCreate(){
        JSONObject jsonObject=new JSONObject();
        jsonObject.put("brandId",xmAppApi.getLoginInfo().getBrandId());
        jsonObject.put("studioId",xmAppApi.getLoginInfo().getStudioId());
        jsonObject.put("operatorId",xmAppApi.getLoginInfo().getAdminId());
        jsonObject.put("adjustType","PLUS"); // PLUS 加钱，MINUS 扣钱
        jsonObject.put("title","底薪"); // 工资条项目名称
        jsonObject.put("id","");
        xmAppApi.doRequest(RequestType.JSON,params,jsonObject.toJSONString(),headers).assetsSuccess(false);
        Assert.assertEquals(xmAppApi.getBodyInJSON().getString("message"),"已存在相同项目名称，请修改","创建同名的工资条项目名称");
    }

    @Test(description = "删除创建的工资条项目",priority = 2)
    public void testSettleItemDelete(){
        for (int i = 0; i < items.size(); i++) {
            // 删除工资条项目
            salaryTools.deleteSettleItem(items.getString(i));
            try {
                Thread.sleep(2000);
            } catch (InterruptedException e) {
                throw new RuntimeException(e);
            }
            // 删除后查询工资条项目是否还存在
            JSONArray listSettleItem = salaryTools.listSettleItem();
            boolean flag = true;
            for (int j = 0; j < listSettleItem.size(); j++) {
                if(listSettleItem.getJSONObject(j).getString("id").equals(items.getString(i))){
                    flag = false;
                    break;
                }
            }

            Assert.assertEquals(true,flag,"删除工资条项目失败");

        }
    }

}
