package com.xiaomai.cases.polar.finance.salary;

import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import com.xiaomai.basetest.BaseTestImpl;
import com.xiaomai.enums.ApiModule;
import com.xiaomai.enums.LoginAccount;
import com.xiaomai.enums.RequestType;
import com.xiaomai.enums.Terminal;
import org.testng.Assert;
import org.testng.annotations.BeforeMethod;
import org.testng.annotations.Test;

/**
 * @BelongsProject: xm-sportstest
 * @BelongsPackage: com.xiaomai.cases.polar.finance.salary
 * @Author: xuyamei
 * @CreateTime: 2024-11-06  17:57
 * @Description: 编辑工资条项目
 * @Version: 1.0
 */
public class TestSettleItemUpdate extends BaseTestImpl {
    SalaryTools salaryTools = new SalaryTools();
    private String id;
    @BeforeMethod
    @Override
    public void beforeTest(){
        setTestInfo(ApiModule.Polar_Salary,"API_settleItem_update", LoginAccount.GYM_PROD, Terminal.B,"xym");
        super.beforeTest();
    }

    @Test
    public void testSettleItemUpdate(){
        id = salaryTools.createSettleItem("PLUS","自定义工资条项目");

        JSONObject jsonObject = new JSONObject();
        jsonObject.put("brandId",xmAppApi.getLoginInfo().getBrandId());
        jsonObject.put("studioId",xmAppApi.getLoginInfo().getStudioId());
        jsonObject.put("operatorId",xmAppApi.getLoginInfo().getAdminId());
        jsonObject.put("adjustType","MINUS"); // PLUS 加钱，MINUS 扣钱
        jsonObject.put("title","编辑工资条项目"); // 工资条项目名称
        jsonObject.put("id",id);
        xmAppApi.doRequest(RequestType.JSON,params,jsonObject.toJSONString(),headers).assetsSuccess(true);

        try {
            Thread.sleep(2000);
        } catch (InterruptedException e) {
            throw new RuntimeException(e);
        }
        JSONArray listSettleItem = salaryTools.listSettleItem();
        String afterTitle = "";
        String afterAdjustType = "";
        for (int i = 0; i < listSettleItem.size(); i++) {
            if(listSettleItem.getJSONObject(i).getString("id").equals(id)){
                afterTitle = listSettleItem.getJSONObject(i).getString("title");
                afterAdjustType = listSettleItem.getJSONObject(i).getString("adjustType");
                break;
            }
        }
        Assert.assertEquals(true,afterTitle.equals("编辑工资条项目") && afterAdjustType.equals("MINUS"),"编辑工资条项目失败");

    }
    @Test(description = "删除创建的工资条项目",priority = 2)
    public void deleteSettleItem(){
        salaryTools.deleteSettleItem(id);
    }


}
