package com.xiaomai.cases.polar.luckyDraw;

import com.alibaba.fastjson.JSONObject;
import com.xiaomai.enums.ApiModule;
import com.xiaomai.enums.LoginAccount;
import com.xiaomai.enums.RequestType;
import com.xiaomai.enums.Terminal;
import com.xiaomai.utils.RandomStringUtil;
import com.xiaomai.utils.XMBaseTest;
import com.xiaomai.utils.XMJSONPath;
import org.testng.Assert;
import org.testng.annotations.BeforeMethod;
import org.testng.annotations.Test;

import javax.annotation.Resource;

public class TestAbnormalLuckyDraw extends XMBaseTest {
    @Resource(name = "luckyDrawTools")
    LuckyDrawTools luckyDrawTools;
    @BeforeMethod
    public void beforeTest(){
        xmAppApi.setApiModule(ApiModule.Polar_LuckyDraw)
                .setApiName("API_abnormalLuckyDraw")
                .setLoginUser(LoginAccount.GYM_PROD)
                .setTerminal(Terminal.B);
        dal.setCase_owner("xyy")
                .setCase_name(Thread.currentThread().getStackTrace()[1].getFileName().split("\\.")[0]);
        super.beforeTest();
    }
    @Test(description = "创建未发布活动->发布活动->失效活动->删除活动")
    public void testAbnormalLuckyDraw()throws InterruptedException{
        //获取活动列表数据
        int total = Integer.parseInt(XMJSONPath.readPath(luckyDrawTools.getLuckyDrawByPage(""),"$.result.total"));
        //创建自定义奖品
        String prizeName = "奖品" + RandomStringUtil.randomString(5);
        String prizeId = luckyDrawTools.addCustomizePrize(prizeName);
        //创建活动名称
        String activityName = "每人总共抽100次" + RandomStringUtil.randomString(5);
        //创建未发布的活动
        String activityId = luckyDrawTools.addLuckyDraw("CUSTOMIZE_GIFT",prizeName,prizeId,false,activityName);
        Assert.assertTrue(Integer.parseInt(XMJSONPath.readPath(luckyDrawTools.getLuckyDrawByPage(""),"$.result.total"))==total+1);
        Thread.sleep(1000);
        //检验活动状态=未发布
        Assert.assertEquals(XMJSONPath.readPath(luckyDrawTools.getLuckyDrawDetail(activityId),"$.result.status"),"UNPUBLISHED");
        //此时删除自定义奖品,会报错，因为奖品关联着活动
        Assert.assertEquals(XMJSONPath.readPath(luckyDrawTools.delCustomizePrize(prizeId),"$.message"),"该奖品已被"+activityName+"活动引用，暂不支持删除。");
        //发布活动,并且校验活动状态=未开始
        luckyDrawTools.publishLuckyDraw(activityId);
        Assert.assertEquals(XMJSONPath.readPath(luckyDrawTools.getLuckyDrawDetail(activityId),"$.result.status"),"WAITING");
        //失效活动
        JSONObject body = new JSONObject();
        body.put("id", activityId);
        body.put("brandId", xmAppApi.getLoginInfo().getBrandId());
        body.put("studioId", xmAppApi.getLoginInfo().getStudioId());
        body.put("operatorId", xmAppApi.getLoginInfo().getAdminId());

        xmAppApi.doRequest(RequestType.JSON, params, body.toJSONString(), headers).assetsSuccess(true);
        Assert.assertEquals(XMJSONPath.readPath(xmAppApi.getBodyInJSON(),"$.message"),"操作成功!");
        //检验活动状态=已失效
        Assert.assertEquals(XMJSONPath.readPath(luckyDrawTools.getLuckyDrawDetail(activityId),"$.result.status"),"ABNORMAL");
        //删除活动
        luckyDrawTools.deleteLuckyDraw(activityId);
        //删除自定义奖品
        luckyDrawTools.delCustomizePrize(prizeId);
    }
}
