package com.xiaomai.cases.polar.memberCard.MemberCardTimeSale;

import com.alibaba.fastjson.JSONObject;
import com.xiaomai.client.DataUserInfo;
import com.xiaomai.enums.ApiModule;
import com.xiaomai.enums.RequestType;
import com.xiaomai.enums.Terminal;
import com.xiaomai.utils.XMBaseTest;
import org.springframework.stereotype.Component;

import java.util.ArrayList;
import java.util.List;


@Component("CardTimeSaleMinTools")
public class CardTimeSaleMinTools extends XMBaseTest {
    /**
     * @param
     * @description:小程序查看秒杀活动列表
     * @author: yangjian
     * @param activityId 活动id
     * @param state 活动状态
     **/
    public JSONObject getStudioActivityPage(String activityId,String state,String memberId, DataUserInfo... dataUserInfos) {

        dataApi.setApiModule(ApiModule.Lunar_Card)
                .setApiName("API_getStudioActivityPage")
                .setTerminal(Terminal.minApp);
        super.beforeDataRequest(dataUserInfos);

        List<String> activityIds = new ArrayList<>();
        activityIds.add(activityId);

        JSONObject jsonObject = new JSONObject();
        jsonObject.put("current", 0);
        jsonObject.put("size", 50);
        jsonObject.put("state", state);//null全部，PROCESSING开抢中，WAITING即将开抢
        jsonObject.put("activityIds", activityIds);//活动ID
        jsonObject.put("memberId", memberId);//String memberId = userTools.getMemberInfo().getString("memberId");
        jsonObject.put("studioId", dataApi.getLoginInfo().getStudioId());


        dataApi.doRequest(RequestType.JSON, dataparams, jsonObject.toJSONString(), dataheadrs).assetsSuccess(true);
        JSONObject response = dataApi.getBodyInJSON();
        return response;
    }


    /**
     * @param
     * @description:秒杀活动查看会员卡详情
     * @author: yangjian
     * @param activityId 活动id
     **/
    public JSONObject findTenantCardDetailById(String id,String activityId,String memberId, DataUserInfo... dataUserInfos) {

        dataApi.setApiModule(ApiModule.Lunar_Card)
                .setApiName("API_findTenantCardDetailById")
                .setTerminal(Terminal.minApp);
        super.beforeDataRequest(dataUserInfos);


        JSONObject jsonObject = new JSONObject();
        jsonObject.put("activityId", activityId);
        jsonObject.put("id", id);//会员卡ID
        jsonObject.put("memberId", memberId);//String memberId = userTools.getMemberInfo().getString("memberId");
        jsonObject.put("studioId", dataApi.getLoginInfo().getStudioId());


        dataApi.doRequest(RequestType.JSON, dataparams, jsonObject.toJSONString(), dataheadrs).assetsSuccess(true);
        JSONObject response = dataApi.getBodyInJSON();
        return response;
    }


    /**
     * @param
     * @description:预约秒杀活动
     * @author: yangjian
     * @param activityId 活动id
     * @param cancel 预约状态
     **/
    public JSONObject reserveRemindOrCancel(String cancel,String activityId,String memberId, DataUserInfo... dataUserInfos) {

        dataApi.setApiModule(ApiModule.Lunar_Card)
                .setApiName("API_reserveRemindOrCancel")
                .setTerminal(Terminal.minApp);
        super.beforeDataRequest(dataUserInfos);


        JSONObject jsonObject = new JSONObject();
        jsonObject.put("activityId", activityId);
        jsonObject.put("cancel", cancel);//预约状态：true为取消预约提醒，false为预约提醒
        jsonObject.put("memberId", memberId);//String memberId = userTools.getMemberInfo().getString("memberId");
        jsonObject.put("studioId", dataApi.getLoginInfo().getStudioId());


        dataApi.doRequest(RequestType.JSON, dataparams, jsonObject.toJSONString(), dataheadrs).assetsSuccess(true);
        JSONObject response = dataApi.getBodyInJSON();
        return response;
    }

}
