package com.xiaomai.cases.polar.memberCard.MemberCardTimeSale;

import com.alibaba.fastjson.JSONObject;
import com.xiaomai.cases.lunar.order.OrderCTools;
import com.xiaomai.cases.lunar.user.UserTools;
import com.xiaomai.cases.polar.finance.order.OrderTools;
import com.xiaomai.cases.polar.luckyDraw.LuckyDrawTools;
import com.xiaomai.cases.polar.memberCard.CardTools;
import com.xiaomai.client.DataUserInfo;
import com.xiaomai.enums.ApiModule;
import com.xiaomai.enums.LoginAccount;
import com.xiaomai.enums.RequestType;
import com.xiaomai.enums.Terminal;
import com.xiaomai.utils.RandomStringUtil;
import com.xiaomai.utils.TimeUtils;
import com.xiaomai.utils.XMBaseTest;
import com.xiaomai.utils.XMJSONPath;
import org.testng.Assert;
import org.testng.annotations.BeforeMethod;
import org.testng.annotations.Test;

import javax.annotation.Resource;


public class TestPurchaseCardTimeSale extends XMBaseTest {

    DataUserInfo info = new DataUserInfo();

    @Resource(name = "memberCardTimeSaleTools")
    MemberCardTimeSaleTools memberCardTimeSaleTools;

    @Resource(name = "cardTools")
    CardTools cardTools;

    @Resource(name = "userTools")
    UserTools userTools;

    @Resource(name = "CardTimeSaleMinTools")
    CardTimeSaleMinTools CardTimeSaleMinTools;

    @Resource(name = "orderCTools")
    OrderCTools orderCTools;

    @Resource(name = "orderTools")
    OrderTools orderTools;


    @BeforeMethod
    public void beforeTest(){
        xmAppApi.setApiModule(ApiModule.Lunar_Order)
                .setApiName("API_purchaseCard")
                .setLoginUser(LoginAccount.GYM_MINIAPPC)
                .setTerminal(Terminal.minApp);
        dal.setCase_owner("yangjian")
                .setCase_name(Thread.currentThread().getStackTrace()[1].getFileName().split("\\.")[0]);
        super.beforeTest();
    }

    @Test(description = "参与秒杀活动")
    public void testPurchaseCardTimeSale() throws InterruptedException {

        info.setTerminal(Terminal.B);
        info.setLoginUser(LoginAccount.GYM_PROD);
        String cardId = cardTools.memberCardCreate("用于秒杀活动的会员卡"+ TimeUtils.getCurrentTime(),info).getString("result");//创建一张用于秒杀活动的会员卡

        String title ="预约秒杀活动"+ TimeUtils.getCurrentTime();
        String activeid = memberCardTimeSaleTools.create(cardId,title,true,TimeUtils.getTodayEndTime(),TimeUtils.getCurrentTime_AddMinute(6),info).getString("result");//创建并发布秒杀活动 活动开始前5分钟可以预约
        String memberId = userTools.getMemberInfo().getString("memberId");

        CardTimeSaleMinTools.getStudioActivityPage(activeid,"WAITING",memberId);
        Assert.assertEquals(XMJSONPath.readPath(dataApi.getApi_response(), "$.result.records[0].activityId"), activeid, "即将开始的活动没有新建的秒杀活动");//断言即将开始活动列表有目标活动

        CardTimeSaleMinTools.reserveRemindOrCancel("false",activeid,memberId);//预约秒杀活动
        CardTimeSaleMinTools.findTenantCardDetailById(cardId,activeid,memberId);
        Assert.assertEquals(XMJSONPath.readPath(dataApi.getApi_response(), "$.result.activityVO.reserveRemind"), "true", "预约秒杀活动失败");//断言目标活动已预约完成
        CardTimeSaleMinTools.reserveRemindOrCancel("true",activeid,memberId);//取消预约秒杀活动
        CardTimeSaleMinTools.findTenantCardDetailById(cardId,activeid,memberId);
        Assert.assertEquals(XMJSONPath.readPath(dataApi.getApi_response(), "$.result.activityVO.reserveRemind"), "false", "预约秒杀活动失败");//断言目标活动已取消预约

        Thread.sleep(5000);
        String cardId1 = cardTools.memberCardCreate("用于秒杀活动的会员卡"+ TimeUtils.getCurrentTime(),info).getString("result");//创建一张用于秒杀活动的会员卡
        String title1 ="参与秒杀活动"+ TimeUtils.getCurrentTime();
        String activeid1 = memberCardTimeSaleTools.create(cardId1,title1,true,TimeUtils.getTodayEndTime(),TimeUtils.getTodayTime(),info).getString("result");//创建一个已开始的活动的秒杀活动

        int before = Integer.parseInt(XMJSONPath.readPath(CardTimeSaleMinTools.findTenantCardDetailById(cardId1,activeid1,memberId), "$.result.activityVO.salesVolumeShow"));//初始秒杀数量


        JSONObject jsonObject = new JSONObject();
        jsonObject.put("activatePattern","PURCHASE");
        jsonObject.put("cardId",cardId1);
        jsonObject.put("cardSnapshotId",cardId1);
        jsonObject.put("memberId",memberId);
        jsonObject.put("memo","自动化买秒杀活动会员卡");
        jsonObject.put("receivableAmount","0.00");
        jsonObject.put("studioId",xmAppApi.getLoginInfo().getStudioId());
        jsonObject.put("objectId", RandomStringUtil.randomString(16));
        jsonObject.put("depositCardId",null);
        jsonObject.put("depositAmount","0.00");
        jsonObject.put("commodityCardType","MEMBER_CARD");
        jsonObject.put("activityId",activeid1);
        jsonObject.put("activityAmount",1);
        xmAppApi.doRequest(RequestType.JSON,params,jsonObject.toString(),headers).assetsSuccess(true);
        String voucherId = xmAppApi.getBodyInJSON().getJSONObject("result").getString("voucherId");//订单ID

        int after = Integer.parseInt(XMJSONPath.readPath(CardTimeSaleMinTools.findTenantCardDetailById(cardId1,activeid1,memberId), "$.result.activityVO.salesVolumeShow"));//参与秒杀活动后，已秒数量

        Assert.assertEquals(after,before+1);//参与秒杀活动后，秒杀人数+1

        Thread.sleep(3000);
        //校验C端订单详情
        Assert.assertEquals(XMJSONPath.readPath(orderCTools.getDetail(voucherId),"$.result.state"),"PAID","创建签单订单成功,但订单状态不是已完成");
        Assert.assertEquals(XMJSONPath.readPath(orderCTools.getDetail(voucherId),"$.result.source"),"ONLINE_MALL","C端创建的签单订单,订单来源非会员创建");

        cardTools.getUserMemberCardList(memberId,"MEMBER",info);
        String memberAccountCardId=XMJSONPath.readPath(dataApi.getApi_response(),"$.result[0].id");
        cardTools.memberCardFindDetailById(memberAccountCardId,info);
        Assert.assertEquals(XMJSONPath.readPath(dataApi.getApi_response(),"$.result.tradeOrderId"),voucherId,"B端售卖记录非秒杀活动对应会员卡的记录");//断言B端第一条的售卖记录的订单为目标售卖记录

        orderTools.discard(voucherId,"其他","自动化作废秒杀订单",info);

        int after1 = Integer.parseInt(XMJSONPath.readPath(CardTimeSaleMinTools.findTenantCardDetailById(cardId1,activeid1,memberId), "$.result.activityVO.salesVolumeShow"));//作废订单后，秒杀数量
        Assert.assertEquals(after1,before);//初始秒杀数量和作废后秒杀数量一致





    }


}
