package com.xiaomai.cases.polar.memberCard;

import com.alibaba.fastjson.JSONObject;
import com.xiaomai.enums.ApiModule;
import com.xiaomai.enums.LoginAccount;
import com.xiaomai.enums.RequestType;
import com.xiaomai.enums.Terminal;
import com.xiaomai.utils.XMBaseTest;
import com.xiaomai.utils.XMJSONPath;
import org.testng.Assert;
import org.testng.annotations.BeforeMethod;
import org.testng.annotations.Test;

public class TestFindHistoryDetailById extends XMBaseTest {
    @BeforeMethod
    public void beforeTest(){
        xmAppApi.setApiModule(ApiModule.Polar_Card)
                .setApiName("API_findHistoryDetailById")
                .setLoginUser(LoginAccount.GYM_PROD)
                .setTerminal(Terminal.B);

        dal.setCase_owner("yj")
                .setCase_name(Thread.currentThread().getStackTrace()[1].getFileName().split("\\.")[0]);
        super.beforeTest();
    }
    @Test(description = "查看会员卡编辑记录-会员卡详情")
    public void testfindHistoryDetailById() {
        CardTools Cardtools = new CardTools();

        Cardtools.fetchPageOfMemberCard("MEMBER_CARD");
        String memberCardId = XMJSONPath.readPath(dataApi.getApi_response(), "$.result.records[0].id");//拿售卖记录第一张会员卡的ID

        Cardtools.fetchPageOfHistory(memberCardId);
        //Assert.assertEquals(XMJSONPath.readPath(dataApi.getApi_response(), "$.result.records[0].operateType"), "NEW", "第一条非新建的编辑记录");//断言第一条编辑记录-新建的编辑记录
        String id = XMJSONPath.readPath(dataApi.getApi_response(), "$.result.records[0].snapshotId");//


        JSONObject jsonObject = new JSONObject();

        jsonObject.put("id",id);
        jsonObject.put("brandId",xmAppApi.getLoginInfo().getBrandId());
        jsonObject.put("studioId",xmAppApi.getLoginInfo().getStudioId());
        jsonObject.put("operatorId",xmAppApi.getLoginInfo().getAdminId());



        xmAppApi.doRequest(RequestType.JSON, params, jsonObject.toJSONString(), headers).assetsSuccess(true);
        Cardtools.findHistoryDetailById(id);
        //Assert.assertEquals(XMJSONPath.readPath(dataApi.getApi_response(), "$.result.sharePeopleLimit"), 0, "详情的id不是查看的id");//断言第一条编辑记录-新建的编辑记录
        Assert.assertTrue(XMJSONPath.readPath(xmAppApi.getApi_response(),"$.result.id").equals(id),"编辑记录的会员卡详情id对不上");




    }
}
