package com.xiaomai.cases.polar.membercluster;

import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import com.xiaomai.basetest.BaseTestImpl;
import com.xiaomai.client.DataUserInfo;
import com.xiaomai.enums.ApiModule;
import com.xiaomai.enums.RequestType;
import com.xiaomai.enums.Terminal;
import com.xiaomai.utils.XMJSONPath;
import org.springframework.stereotype.Component;
import org.testng.Assert;

import java.util.List;

/**
 * 会员分群工具类
 *
 * @author adu
 * data 2024/10/26 10:48
 */
@Component("memberClusterTools")
public class MemberClusterTools extends BaseTestImpl {

    /**
     * 同一个ApiModule下的登录信息封装出一个类，减少代码冗余
     *
     * @param apiName
     * @param userInfo
     */
    public void setUP(String apiName, DataUserInfo... userInfo) {
        dataApi.setApiModule(ApiModule.Polar_Membercluster)
                .setApiName(apiName)
                .setTerminal(Terminal.B);
        super.beforeDataRequest(userInfo);
    }

    /**
     * 获取场馆会员分群列表数据
     */
    public void getMemberClusterList() {
        setUP("API_getMemberClusterList");
        JSONObject body = new JSONObject();
        body.put("operatorId", dataApi.getLoginInfo().getAdminId());
        body.put("studioId", dataApi.getLoginInfo().getStudioId());
        body.put("brandId", dataApi.getLoginInfo().getBrandId());
        dataApi.doRequest(RequestType.JSON, dataparams, body.toString(), dataheadrs);
        Assert.assertTrue(Boolean.valueOf(XMJSONPath.readPath(dataApi.getApi_response(), "$.success")) == true, "调用接口返回结果：" + XMJSONPath.readPath(dataApi.getApi_response(), "$.message"));

    }

    /**
     * 创建/编辑会员人群名称验重check
     *
     * @param name
     */
    public void memberClusterDuplicateCheck(String name) {
        setUP("API_memberClusterDuplicateCheck");
        JSONObject body = new JSONObject();
        body.put("operatorId", dataApi.getLoginInfo().getAdminId());
        body.put("studioId", dataApi.getLoginInfo().getStudioId());
        body.put("brandId", dataApi.getLoginInfo().getBrandId());
        body.put("name", name);
        dataApi.doRequest(RequestType.JSON, dataparams, body.toString(), dataheadrs);
        //断言在业务中check

    }

    /**
     * @param name           会员分群名称
     * @param description    人群说明
     * @param requireFullHit 人群范围 YES 满足全部条件，NO 满足任意一个
     * @param ruleList       人群定义 条件列表
     * @return 人群clusterId
     */
    public String createMemberCluster(String name, String description, String requireFullHit, List<JSONObject> ruleList) {
        setUP("API_createMemberCluster");
        JSONObject body = new JSONObject();
        body.put("operatorId", dataApi.getLoginInfo().getAdminId());
        body.put("studioId", dataApi.getLoginInfo().getStudioId());
        body.put("brandId", dataApi.getLoginInfo().getBrandId());
        body.put("name", name);
        body.put("requireFullHit", requireFullHit);
        body.put("ruleList", ruleList);
        dataApi.doRequest(RequestType.JSON, dataparams, body.toString(), dataheadrs);
        Assert.assertTrue(Boolean.valueOf(XMJSONPath.readPath(dataApi.getApi_response(), "$.success")) == true, "调用接口返回结果：" + XMJSONPath.readPath(dataApi.getApi_response(), "$.message"));
        return XMJSONPath.readPath(dataApi.getApi_response(), "$.result");

    }

    /**
     * 查看人群详情-人群信息
     *
     * @param clusterId 人群ID
     */
    public void getMemberClusterDetail(String clusterId) {
        setUP("API_getMemberClusterDetail");
        JSONObject body = new JSONObject();
        body.put("operatorId", dataApi.getLoginInfo().getAdminId());
        body.put("studioId", dataApi.getLoginInfo().getStudioId());
        body.put("brandId", dataApi.getLoginInfo().getBrandId());
        body.put("id", clusterId);
        dataApi.doRequest(RequestType.JSON, dataparams, body.toString(), dataheadrs);
        Assert.assertTrue(Boolean.valueOf(XMJSONPath.readPath(dataApi.getApi_response(), "$.success")) == true, "调用接口返回结果：" + XMJSONPath.readPath(dataApi.getApi_response(), "$.message"));
    }

    /**
     * 删除会员分群
     *
     * @param clusterId
     */
    public void deleteMemberCluster(String clusterId) {
        setUP("API_deleteMemberCluster");
        JSONObject body = new JSONObject();
        body.put("operatorId", dataApi.getLoginInfo().getAdminId());
        body.put("studioId", dataApi.getLoginInfo().getStudioId());
        body.put("brandId", dataApi.getLoginInfo().getBrandId());
        body.put("id", clusterId);
        dataApi.doRequest(RequestType.JSON, dataparams, body.toString(), dataheadrs);
        Assert.assertTrue(Boolean.valueOf(XMJSONPath.readPath(dataApi.getApi_response(), "$.success")) == true, "调用接口返回结果：" + XMJSONPath.readPath(dataApi.getApi_response(), "$.message"));

    }

    /**
     * @param clusterId
     * @param messageType 微信：通用 WECHAT_COMMON，会员卡专用 WECHAT_MEMBER_CARD，储值卡专用 WECHAT_DEPOSIT_CARD
     *                    短信：通用 SMS_COMMON，会员卡专用 SMS_MEMBER_CARD，储值卡专用 SMS_DEPOSIT_CARD
     */
    public void batchMessagePushForMemberCluster(String clusterId, String messageType) {
        setUP("API_batchMessagePushForMemberCluster");
        JSONObject body = new JSONObject();
        body.put("operatorId", dataApi.getLoginInfo().getAdminId());
        body.put("studioId", dataApi.getLoginInfo().getStudioId());
        body.put("brandId", dataApi.getLoginInfo().getBrandId());
        body.put("clusterId", clusterId);
        body.put("messageType", messageType);
        dataApi.doRequest(RequestType.JSON, dataparams, body.toString(), dataheadrs);
        //断言业务中check

    }

    /**
     * 查看会员分群人群详情-会员名单
     *
     * @param clusterId
     */
    public void getClusterMemberList(String clusterId) {
        setUP("API_getClusterMemberList");
        JSONObject body = new JSONObject();
        body.put("operatorId", dataApi.getLoginInfo().getAdminId());
        body.put("studioId", dataApi.getLoginInfo().getStudioId());
        body.put("brandId", dataApi.getLoginInfo().getBrandId());
        body.put("clusterId", clusterId);
        body.put("current", 0);
        dataApi.doRequest(RequestType.JSON, dataparams, body.toString(), dataheadrs);
        Assert.assertTrue(Boolean.valueOf(XMJSONPath.readPath(dataApi.getApi_response(), "$.success")) == true, "调用接口返回结果：" + XMJSONPath.readPath(dataApi.getApi_response(), "$.message"));

    }

    /**
     * 获取会员分群人群详情-运营记录
     *
     * @param clusterId
     */
    public void getClusterOperateRecord(String clusterId) {
        setUP("API_getClusterOperateRecord");
        JSONObject body = new JSONObject();
        body.put("operatorId", dataApi.getLoginInfo().getAdminId());
        body.put("studioId", dataApi.getLoginInfo().getStudioId());
        body.put("brandId", dataApi.getLoginInfo().getBrandId());
        body.put("clusterId", clusterId);
        body.put("current", 0);
        dataApi.doRequest(RequestType.JSON, dataparams, body.toString(), dataheadrs);
        Assert.assertTrue(Boolean.valueOf(XMJSONPath.readPath(dataApi.getApi_response(), "$.success")) == true, "调用接口返回结果：" + XMJSONPath.readPath(dataApi.getApi_response(), "$.message"));

    }

    /**
     * 会员分群定向运营发送体验卡
     *
     * @param clusterId        选择的分群ID
     * @param experienceCardId 体验卡ID
     */
    public void batchSendExpCardForMemberCluster(String clusterId, String experienceCardId) {
        setUP("API_batchSendExpCardForMemberCluster");
        JSONObject body = new JSONObject();
        body.put("operatorId", dataApi.getLoginInfo().getAdminId());
        body.put("studioId", dataApi.getLoginInfo().getStudioId());
        body.put("brandId", dataApi.getLoginInfo().getBrandId());
        body.put("clusterId", clusterId);
        body.put("experienceCardId", experienceCardId);
        dataApi.doRequest(RequestType.JSON, dataparams, body.toString(), dataheadrs);
        Assert.assertTrue(Boolean.valueOf(XMJSONPath.readPath(dataApi.getApi_response(), "$.success")) == true, "调用接口返回结果：" + XMJSONPath.readPath(dataApi.getApi_response(), "$.message"));

    }

    /**
     * 会员分群定向运营发送优惠券
     *
     * @param memberClusterId
     * @param couponId
     */
    public void batchSendCouponForMemberCluster(String memberClusterId, String couponId) {
        dataApi.setApiModule(ApiModule.Polar_Coupon)
                .setApiName("API_batchSendCoupon")
                .setTerminal(Terminal.B);
        super.beforeDataRequest();

        JSONObject body = new JSONObject();
        body.put("operatorId", dataApi.getLoginInfo().getAdminId());
        body.put("studioId", dataApi.getLoginInfo().getStudioId());
        body.put("brandId", dataApi.getLoginInfo().getBrandId());
        body.put("memberClusterId", memberClusterId);
        body.put("couponId", couponId);
        body.put("channel", "TARGETED_OPERATION");
        dataApi.doRequest(RequestType.JSON, dataparams, body.toString(), dataheadrs);
        Assert.assertTrue(Boolean.valueOf(XMJSONPath.readPath(dataApi.getApi_response(), "$.success")) == true, "调用接口返回结果：" + XMJSONPath.readPath(dataApi.getApi_response(), "$.message"));

    }

    /**
     * 手动操作更新会员分群（1小时内只能操作1次，且每次更新都是针对本场馆，不会单独更新对应场馆的某一个人群）
     */
    public void manuaUpdatelMemberCluster() {
        setUP("API_manuaUpdatelMemberCluster");
        JSONObject body = new JSONObject();
        body.put("operatorId", dataApi.getLoginInfo().getAdminId());
        body.put("studioId", dataApi.getLoginInfo().getStudioId());
        body.put("brandId", dataApi.getLoginInfo().getBrandId());
        dataApi.doRequest(RequestType.JSON, dataparams, body.toString(), dataheadrs);

        //断言在业务中check
    }

    /**
     * 人群详情-会员名单：点击会员查看会员信息
     * @param memberId
     */
    public void findMemberClusterInfo(String memberId){
        setUP("API_findMemberClusterInfo");
        JSONObject body = new JSONObject();
        body.put("operatorId", dataApi.getLoginInfo().getAdminId());
        body.put("studioId", dataApi.getLoginInfo().getStudioId());
        body.put("brandId", dataApi.getLoginInfo().getBrandId());
        body.put("memberId", memberId);
        dataApi.doRequest(RequestType.JSON, dataparams, body.toString(), dataheadrs);
        Assert.assertTrue(Boolean.valueOf(XMJSONPath.readPath(dataApi.getApi_response(), "$.success")) == true, "调用接口返回结果：" + XMJSONPath.readPath(dataApi.getApi_response(), "$.message"));

    }

    /**
     * 查看会员分群详情-运营记录-记录详情-发送名单
     * @param clusterId
     * @param operateRecordId 记录ID（从记录列表中获取ID）
     */
    public void fetchListOfOperateMember(String clusterId,String operateRecordId){
        setUP("API_fetchListOfOperateMember");
        JSONObject body = new JSONObject();
        body.put("operatorId", dataApi.getLoginInfo().getAdminId());
        body.put("studioId", dataApi.getLoginInfo().getStudioId());
        body.put("brandId", dataApi.getLoginInfo().getBrandId());
        body.put("clusterId", clusterId);
        body.put("operateRecordId", operateRecordId);
        body.put("current", 0);
        dataApi.doRequest(RequestType.JSON, dataparams, body.toString(), dataheadrs);
        Assert.assertTrue(Boolean.valueOf(XMJSONPath.readPath(dataApi.getApi_response(), "$.success")) == true, "调用接口返回结果：" + XMJSONPath.readPath(dataApi.getApi_response(), "$.message"));


    }


    /**
     * 获取会员分群详情-运营记录-对应记录详情
     * @param operateRecordId 记录ID（从运营记录列表中获取对应的记录ID）
     */
    public void fetchMemberClusterOperateRecordDetail(String operateRecordId){

        setUP("API_fetchMemberClusterOperateRecordDetail");
        JSONObject body = new JSONObject();
        body.put("operatorId", dataApi.getLoginInfo().getAdminId());
        body.put("studioId", dataApi.getLoginInfo().getStudioId());
        body.put("brandId", dataApi.getLoginInfo().getBrandId());
        body.put("id", operateRecordId);
        dataApi.doRequest(RequestType.JSON, dataparams, body.toString(), dataheadrs);
        Assert.assertTrue(Boolean.valueOf(XMJSONPath.readPath(dataApi.getApi_response(), "$.success")) == true, "调用接口返回结果：" + XMJSONPath.readPath(dataApi.getApi_response(), "$.message"));

    }



}

    