package com.xiaomai.cases.polar.training;

import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import com.xiaomai.basetest.BaseTestImpl;
import com.xiaomai.enums.ApiModule;
import com.xiaomai.enums.LoginAccount;
import com.xiaomai.enums.RequestType;
import com.xiaomai.enums.Terminal;
import com.xiaomai.utils.RandomStringUtil;
import com.xiaomai.utils.XMJSONPath;
import org.testng.Assert;
import org.testng.annotations.BeforeMethod;
import org.testng.annotations.Test;

import javax.annotation.Resource;

public class TestTrainingExerciseEdit extends BaseTestImpl {

    @Resource(name="trainingTools")
    TrainingTools trainingTools;

    String exerciseName = "其他部位";

    @BeforeMethod
    @Override
    public void beforeTest(){
        setTestInfo(ApiModule.Polar_Training,"API_trainingExerciseEdit", LoginAccount.GYM_PROD, Terminal.B,"xyy");
        super.beforeTest();
    }
    @Test(description = "创建动作>查看详情>编辑动作>删除动作")
    public void testTrainingExerciseEdit(){
        //1.获取动作库-其他部位的数据
        String bodyPartId = XMJSONPath.readPath(trainingTools.getBodyPartList(),"$.result[-1].id");//其他部位id
        int num = XMJSONPath.getJSONArrayByReadPath(trainingTools.trainingExerciseList(bodyPartId),"$.result").size();

        //2.创建动作
        //若重名，则换一个名称
        boolean flag = trainingTools.trainingExerciseCheckName("",exerciseName);
        if(flag==false){
            exerciseName = "其他部位"+ RandomStringUtil.randomString(5);
        }
        String exerciseId = trainingTools.trainingExerciseCreate(exerciseName,bodyPartId);
        //检验其他部位的数据+1
        Assert.assertTrue(XMJSONPath.getJSONArrayByReadPath(trainingTools.trainingExerciseList(bodyPartId),"$.result").size()==num+1);

        //检验动作详情，动作名称正确、部位有值；
        Assert.assertEquals(XMJSONPath.readPath(trainingTools.trainingExerciseGetDetail(exerciseId),"$.result.name"),exerciseName);
        Assert.assertTrue(XMJSONPath.getJSONArrayByReadPath(trainingTools.trainingExerciseGetDetail(exerciseId),"$.result.trainingBodyPartList").size()==1);

        //编辑动作的新名称
        String editName = "编辑其他部位"+ RandomStringUtil.randomString(5);

        //3.编辑动作
        JSONArray bodyPartIds = new JSONArray();
        bodyPartIds.add(bodyPartId);

        JSONObject body = new JSONObject();
        body.put("name", editName);
        body.put("bodyPartIds",bodyPartIds);
        body.put("muscle","自动化脚本编辑训练肌肉");
        body.put("actionStandards","自动化脚本编辑动作标准");
        body.put("notes","自动化脚本编辑注意事项");
        body.put("id",exerciseId);
        body.put("brandId", xmAppApi.getLoginInfo().getBrandId());
        body.put("studioId", xmAppApi.getLoginInfo().getStudioId());
        body.put("operatorId", xmAppApi.getLoginInfo().getAdminId());

        xmAppApi.doRequest(RequestType.JSON, params, body.toString(), headers).assetsSuccess(true);
        //检验动作详情，编辑的新动作名称正确；
        Assert.assertEquals(XMJSONPath.readPath(trainingTools.trainingExerciseGetDetail(exerciseId),"$.result.name"),editName);

        //4.删除动作
        trainingTools.trainingExerciseDelete(exerciseId);
        //检验其他部位的数据-1
        Assert.assertTrue(XMJSONPath.getJSONArrayByReadPath(trainingTools.trainingExerciseList(bodyPartId),"$.result").size()==num);
    }
}
