package com.xiaomai.cases.lunar.training;

import com.alibaba.fastjson.JSONArray;
import com.xiaomai.basetest.BaseTestImpl;
import com.xiaomai.cases.lunar.user.UserTools;
import com.xiaomai.enums.ApiModule;
import com.xiaomai.enums.LoginAccount;
import com.xiaomai.enums.Terminal;
import com.xiaomai.utils.TimeUtils;
import org.testng.Assert;
import org.testng.annotations.BeforeMethod;
import org.testng.annotations.Test;

import javax.annotation.Resource;

/**
 * @BelongsProject: xm-sportstest
 * @BelongsPackage: com.xiaomai.cases.lunar.training
 * @Author: xuyamei
 * @CreateTime: 2024-07-31  17:45
 * @Description: 训练营课表数据
 * @Version: 1.0
 */
public class TestGetMemberCampScheduleItemList extends BaseTestImpl {
    @Resource(name = "trainingCTools")
    TrainingCTools trainTools;
    @Resource(name = "userTools")
    UserTools userTools;
    @BeforeMethod
    @Override
    public void beforeTest(){
        setTestInfo(ApiModule.Lunar_Training,"API_getMemberCampScheduleItemList", LoginAccount.GYM_MINIAPPC, Terminal.minApp,"xym");
        super.beforeTest();
    }

    @Test(description = "获取会员训练营课表数据")
    public void testGetMemberCampScheduleItemList(){
        // 获取的微信用户
        String memberId = userTools.getMemberInfo().getString("memberId");

        JSONArray data = trainTools.getMemberCampScheduleItemList(TimeUtils.getTodayTime(),TimeUtils.getTodayEndTime(),memberId);
        Assert.assertEquals(data.size()>=2,true,"有3条存量的训练营课次数据");
    }

}
