package com.xiaomai.cases.lunar.goods;

import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import com.xiaomai.client.DataUserInfo;
import com.xiaomai.enums.ApiModule;
import com.xiaomai.enums.RequestType;
import com.xiaomai.enums.Terminal;
import com.xiaomai.utils.RandomStringUtil;
import com.xiaomai.utils.XMBaseTest;

import java.math.BigDecimal;

public class GoodCTools extends XMBaseTest {

    /**
     * @param
     * @description:C端获取物品列表
     * @author: yff
     **/

    public JSONObject pageXcxHomeGoodsC(DataUserInfo...userInfos){
        dataApi.setApiModule(ApiModule.Lunar_Goods)
                .setApiName("API_pageXcxHomeGoodsC")
                .setTerminal(Terminal.minApp);

        super.beforeDataRequest(userInfos);

        JSONObject jsonObject = new JSONObject();

        jsonObject.put("current", 0);
        jsonObject.put("size",20);
        jsonObject.put("studioId",dataApi.getLoginInfo().getStudioId());
        JSONArray ids=new JSONArray();
        jsonObject.put("ids",ids);

        dataApi.doRequest(RequestType.JSON,dataparams,jsonObject.toString(),dataheadrs).assetsSuccess(true);
        return dataApi.getBodyInJSON();
    }

    /**
     * @param
     * @description:获取C端的物品详情
     * @param id：物品ID
     * @author: yff
     **/

    public JSONObject getDetail_goods_C(String id, DataUserInfo...userInfos){
        dataApi.setApiModule(ApiModule.Lunar_Goods)
                .setApiName("API_getDetail_goods_C")
                .setTerminal(Terminal.minApp);

        super.beforeDataRequest(userInfos);

        JSONObject jsonObject = new JSONObject();

        jsonObject.put("id",id);

        dataApi.doRequest(RequestType.JSON,dataparams,jsonObject.toString(),dataheadrs).assetsSuccess(true);
        return dataApi.getBodyInJSON();
    }

    /**
     * @param
     * @description:拉取C端小程序物品组列表
     * @author: yff
     **/

    public JSONObject listXcxGoodsGroup(DataUserInfo...userInfos){
        dataApi.setApiModule(ApiModule.Lunar_Goods)
                .setApiName("API_listXcxGoodsGroup")
                .setTerminal(Terminal.minApp);

        super.beforeDataRequest(userInfos);

        JSONObject listXcxGoodsGroup=new JSONObject();
        listXcxGoodsGroup.put("studioId",dataApi.getLoginInfo().getStudioId());
        JSONArray ids=new JSONArray();
        listXcxGoodsGroup.put("ids",ids);

        dataApi.doRequest(RequestType.JSON,dataparams,listXcxGoodsGroup.toString(),dataheadrs).assetsSuccess(true);
        return dataApi.getBodyInJSON();
    }


    /**
     * @param
     * @description:C端购买物品前校验是否通过
     * @author: yff
     **/

    public JSONObject checkAllowPurchase(String goodsSpecId, String memberId, String price,int quantity, DataUserInfo...userInfos){
        dataApi.setApiModule(ApiModule.Lunar_Goods)
                .setApiName("API_checkAllowPurchase")
                .setTerminal(Terminal.minApp);

        super.beforeDataRequest(userInfos);

        JSONObject checkAllowPurchase=new JSONObject();
        checkAllowPurchase.put("goodsSpecId",goodsSpecId);
        checkAllowPurchase.put("memberId",memberId);
        checkAllowPurchase.put("price",price);
        checkAllowPurchase.put("quantity",quantity);
        checkAllowPurchase.put("studioId",dataApi.getLoginInfo().getStudioId());

        dataApi.doRequest(RequestType.JSON,dataparams,checkAllowPurchase.toString(),dataheadrs).assetsSuccess(true);
        return dataApi.getBodyInJSON();
    }




    /**
     * @param
     * @description:C端购买物品
     * @author: yff
     **/

    public JSONObject purchaseGoods(String depositAmount, String depositCardId, String memberId,String memo, String receivableAmount,String id, String price, int quantity, DataUserInfo...userInfos){
        dataApi.setApiModule(ApiModule.Lunar_Goods)
                .setApiName("API_purchaseGoods")
                .setTerminal(Terminal.minApp);

        super.beforeDataRequest(userInfos);

        JSONObject  purchaseGoods=new JSONObject();
        purchaseGoods.put("depositAmount",depositAmount);
        purchaseGoods.put("depositCardId",depositCardId);
        purchaseGoods.put("memberId",memberId);
        purchaseGoods.put("memo",memo);
        purchaseGoods.put("objectId", RandomStringUtil.randomString(16));
        purchaseGoods.put("receivableAmount",receivableAmount);
        purchaseGoods.put("goodsSpecId",id);
        purchaseGoods.put("price",price);
        purchaseGoods.put("quantity",quantity);
        purchaseGoods.put("studioId",dataApi.getLoginInfo().getStudioId());

        dataApi.doRequest(RequestType.JSON,dataparams,purchaseGoods.toString(),dataheadrs).assetsSuccess(true);
        return dataApi.getBodyInJSON();
    }


}
