package com.xiaomai.cases.polar.goods;

import com.alibaba.fastjson.JSONObject;
import com.xiaomai.cases.lunar.goods.GoodCTools;
import com.xiaomai.cases.lunar.order.OrderCTools;
import com.xiaomai.cases.lunar.user.UserTools;
import com.xiaomai.cases.polar.data.financeData.FinanceDataTools;
import com.xiaomai.cases.polar.finance.order.OrderTools;
import com.xiaomai.cases.polar.goods.Tools.GoodTools;
import com.xiaomai.client.DataUserInfo;
import com.xiaomai.enums.ApiModule;
import com.xiaomai.enums.LoginAccount;
import com.xiaomai.enums.Terminal;
import com.xiaomai.utils.TimeUtils;
import com.xiaomai.utils.XMBaseTest;
import org.testng.Assert;
import org.testng.annotations.BeforeMethod;
import org.testng.annotations.Test;

import java.math.BigDecimal;

public class TestRefundGoods extends XMBaseTest {

    GoodTools goodTools=new GoodTools();
    GoodCTools goodCTools=new GoodCTools();



    DataUserInfo info =new DataUserInfo();
    UserTools userTools=new UserTools();
    OrderCTools orderCTools=new OrderCTools();

    OrderTools orderTools=new OrderTools();

    FinanceDataTools financeDataTools=new FinanceDataTools();



    String orderId1;
    String memberId;




    @BeforeMethod
    public void beforeTest() {
        xmAppApi.setApiModule(ApiModule.Polar_Goods)
                .setApiName("API_refundGoods")
                .setLoginUser(LoginAccount.GYM_PROD)
                .setTerminal(Terminal.B);

        dal.setCase_owner("yff")
                .setCase_name(Thread.currentThread().getStackTrace()[1].getFileName().split("\\.")[0]);
        super.beforeTest();
    }

    @Test(description = "签单单规格:待支付->取消订单")
    public void testModifyGoods_single() {

        //涉及到订单的都使用存量物品数据，因为购买过物品就不能被删除了，所以不会买一次新建一个

//        "id": "1874413681302990849",
//                "name": "自动化禁用-购买订单单规格1元",
//        "id": "1874413587237335042",
//                "name": "自动化禁用-购买订单多规格1元",
//        "id": "1874413193018896386",
//                "name": "自动化禁用-购买订单多规格0元",
//        "id": "1874411064376061954",
//                "name": "自动化禁用-购买订单单规格0元",

        //case1:购买多规格非0元物品生成待支付订单

        //case1：购买非0订单->待支付->取消订单

        //切换端位
        info.setTerminal(Terminal.minApp);
        info.setLoginUser(LoginAccount.GYM_MINIAPPC);

        try {
            Thread.sleep(3000);
        } catch (InterruptedException e) {
            throw new RuntimeException(e);
        }


        //获取会员信息
        //获取用户
        memberId = userTools.getMemberInfo(info).getString("memberId");

        String goodsId1="1874413681302990849";

        //获取B端商品详情
        JSONObject getDetail_goods=goodTools.getDetail_goods(goodsId1);
        String id=getDetail_goods.getJSONObject("result").getString("id");
        String price=getDetail_goods.getJSONObject("result").getJSONObject("singleSpecInfo").getString("price");
        int beforeInventory=Integer.parseInt(getDetail_goods.getJSONObject("result").getJSONObject("singleSpecInfo").getString("inventory"));

        try {
            Thread.sleep(3000);
        } catch (InterruptedException e) {
            throw new RuntimeException(e);
        }

        //获取数据中心-财务中心-营收明细-物品的确认收入
        JSONObject beforeGetCostData_type=financeDataTools.getCostData_type("DAY","GOODS", TimeUtils.getTodayTime(),TimeUtils.getTodayEndTime());
        BigDecimal beforeConfirmedAmount=new BigDecimal(beforeGetCostData_type.getJSONObject("result").getString("confirmedAmount"));//确认收入

        boolean checkAllowPurchase=Boolean.parseBoolean(goodCTools.checkAllowPurchase(id,memberId,price,beforeInventory,info).getJSONObject("result").getString("success"));

        //校验一下物品购买是否可以通过，为true才可以
        if(checkAllowPurchase==true) {

            JSONObject purchaseGoods = goodCTools.purchaseGoods("0.00", null,memberId,"",price,id,price,1,info);
            orderId1=purchaseGoods.getJSONObject("result").getString("id");

            //生成待支付订单后，去B端继续收款

            //获取B端订单详情：待支付状态
            JSONObject getDetailResult = orderTools.getDetail(orderId1,info);
            String state=getDetailResult.getJSONObject("result").getString("state");

            Assert.assertEquals(state,"WAITING","未生成待支付物品订单");


            //校验1：B端商品详情库存数-1
            JSONObject afterGetDetail_goods=goodTools.getDetail_goods(goodsId1);
            int afterInventory=Integer.parseInt(afterGetDetail_goods.getJSONObject("result").getJSONObject("singleSpecInfo").getString("inventory"));
            Assert.assertEquals(afterInventory,beforeInventory-1,"购买1个物品生成待支付订单后，应扣除1个库存数");

            try {
                Thread.sleep(5000);
            } catch (InterruptedException e) {
                throw new RuntimeException(e);
            }
            //校验2：权益未到，数据中心的确认收入没有增加
            //获取数据中心-财务中心-营收明细-物品的确认收入
            JSONObject afterGetCostData_type=financeDataTools.getCostData_type("DAY","GOODS", TimeUtils.getTodayTime(),TimeUtils.getTodayEndTime());
            BigDecimal afterConfirmedAmount=new BigDecimal(afterGetCostData_type.getJSONObject("result").getString("confirmedAmount"));//确认收入
            Assert.assertEquals(afterConfirmedAmount,beforeConfirmedAmount,"购买1个物品生成待支付订单后，财务中心-营收明细-物品的确认收入应无变化");


            //B端取消物品订单

            JSONObject cancel=orderTools.cancel(orderId1);

            //校验1：获取B端订单详情：已取消状态
            JSONObject getDetailResult_cancel = orderTools.getDetail(orderId1);
            String state_cancel=getDetailResult_cancel.getJSONObject("result").getString("state");
            Assert.assertEquals(state_cancel,"CANCEL","B端取消物品订单后，订单状态未从待支付变更为已取消");


            //校验2：B端商品详情库存数+1
            JSONObject lastGetDetail_goods=goodTools.getDetail_goods(goodsId1);
            int lastInventory=Integer.parseInt(lastGetDetail_goods.getJSONObject("result").getJSONObject("singleSpecInfo").getString("inventory"));
            Assert.assertEquals(lastInventory,afterInventory+1,"取消购买1个物品的待支付订单后，应返回1个库存数");

            try {
                Thread.sleep(5000);
            } catch (InterruptedException e) {
                throw new RuntimeException(e);
            }

            //校验3：权益未涉及，数据中心的确认收入没有变化
            //获取数据中心-财务中心-营收明细-物品的确认收入
            JSONObject lastGetCostData_type=financeDataTools.getCostData_type("DAY","GOODS", TimeUtils.getTodayTime(),TimeUtils.getTodayEndTime());
            BigDecimal lastConfirmedAmount=new BigDecimal(lastGetCostData_type.getJSONObject("result").getString("confirmedAmount"));//确认收入
            Assert.assertEquals(lastConfirmedAmount,afterConfirmedAmount,"取消购买1个物品的待支付订单后，财务中心-营收明细-物品的确认收入应无变化");


        }

    }


//
//    //继续收款
//    JSONObject pay=orderTools.pay(unpaidAmount,"1",orderId1);
//
//    //获取B端订单详情：待支付状态
//    JSONObject getDetailResult1 = orderTools.getDetail(orderId1,info);
//    String state1=getDetailResult1.getJSONObject("result").getString("state");
//
//            Assert.assertEquals(state1,"PAID","继续收款后订单状态由待支付变为已完成");
    @Test(description = "退单物品_多规格")
    public void testModifyGoods_multiple() {

        //涉及到订单的都使用存量物品数据，因为购买过物品就不能被删除了，所以不会买一次新建一个

//        "id": "1874413681302990849",
//                "name": "自动化禁用-购买订单单规格1元",
//        "id": "1874413587237335042",
//                "name": "自动化禁用-购买订单多规格1元",
//        "id": "1874413193018896386",
//                "name": "自动化禁用-购买订单多规格0元",
//        "id": "1874411064376061954",
//                "name": "自动化禁用-购买订单单规格0元",

        //case1:购买多规格非0元物品生成待支付订单

    }
}
