package com.xiaomai.cases.polar.studioConfig;

import com.alibaba.fastjson.JSONObject;
import com.xiaomai.basetest.BaseTestImpl;
import com.xiaomai.client.DataUserInfo;
import com.xiaomai.enums.ApiModule;
import com.xiaomai.enums.RequestType;
import com.xiaomai.enums.Terminal;
import com.xiaomai.utils.TimeUtils;
import com.xiaomai.utils.XMBaseTest;

/**
 * @Author zxy
 * @Description
 * @Date 2024/7/2 14:33
 */
public class HomeTools extends BaseTestImpl {
    //首页数据概览
    public JSONObject preview(String type,DataUserInfo...userInfos){
        dataApi.setApiModule(ApiModule.Polar_Homepage)
                .setApiName("API_preview")
                .setTerminal(Terminal.B);
        super.beforeDataRequest(userInfos);

        JSONObject object = new JSONObject();
        switch (type) {
            case "本周":
                object.put("startTime", TimeUtils.getWeekFirstTime());
                object.put("endTime", TimeUtils.getWeekLastTime());
                break;
            case "本月":
                object.put("startTime",TimeUtils.getMonthFristDay());
                object.put("endTime",TimeUtils.getMonthLastTime());
                break;
            case "今日":
                object.put("startTime",TimeUtils.getTodayTime());
                object.put("endTime",TimeUtils.getTodayEndTime());
                break;
            case "昨日":
                object.put("startTime",TimeUtils.getDayTime(-1,00,00));
                object.put("endTime",TimeUtils.getTodayEndTime(-1));
                break;
        }
        dataApi.doRequest(RequestType.JSON,dataparams,object.toString(),dataheadrs).assetsSuccess(true);
        return dataApi.getBodyInJSON();
    }

    //首页今日待上课
    public JSONObject queryTodaySchedule(DataUserInfo...userInfos){
        dataApi.setApiModule(ApiModule.Polar_Homepage)
                .setApiName("API_queryTodaySchedule")
                .setTerminal(Terminal.B);
        super.beforeDataRequest(userInfos);

        JSONObject object = new JSONObject();
        object.put("studioId",dataApi.getLoginInfo().getStudioId());
        object.put("operatorId",dataApi.getLoginInfo().getAdminId());

        dataApi.doRequest(RequestType.JSON,dataparams,object.toString(),dataheadrs).assetsSuccess(true);
        return dataApi.getBodyInJSON();
    }

    //首页今日待上课
    public JSONObject queryTodayFeedback(DataUserInfo...userInfos){
        dataApi.setApiModule(ApiModule.Polar_Homepage)
                .setApiName("API_queryTodayFeedback")
                .setTerminal(Terminal.B);
        super.beforeDataRequest(userInfos);

        JSONObject object = new JSONObject();
        object.put("studioId",dataApi.getLoginInfo().getStudioId());
        object.put("operatorId",dataApi.getLoginInfo().getAdminId());

        dataApi.doRequest(RequestType.JSON,dataparams,object.toString(),dataheadrs).assetsSuccess(true);
        return dataApi.getBodyInJSON();
    }
}
