package com.xiaomai.cases.polar.finance.axf;

import com.alibaba.fastjson.JSONObject;
import com.xiaomai.basetest.BaseTestImpl;
import com.xiaomai.enums.ApiModule;
import com.xiaomai.enums.LoginAccount;
import com.xiaomai.enums.RequestType;
import com.xiaomai.enums.Terminal;
import org.testng.Assert;
import org.testng.annotations.BeforeMethod;
import org.testng.annotations.Test;

/**
 * @BelongsProject: xm-sportstest
 * @BelongsPackage: com.xiaomai.cases.polar.finance.axf
 * @Author: xuyamei
 * @CreateTime: 2024-12-25  16:15
 * @Description: 获取订购单扣款明细
 * @Version: 1.0
 */
public class TestListDeduction extends BaseTestImpl {
    AXFTools axfTools = new AXFTools();

    @BeforeMethod
    @Override
    public void beforeTest(){
        setTestInfo(ApiModule.Polar_Finance,"API_listDeduction", LoginAccount.GYM_PROD, Terminal.B,"xym");
        super.beforeTest();
    }

    @Test
    public void testListDeduction() {
        // 查询签约成功的列表数据 且有扣款数据
        String body = "{\"current\":0,\"size\":20,\"studioId\":\""+xmAppApi.getLoginInfo().getStudioId()+"\",\"brandId\":\""+xmAppApi.getLoginInfo().getBrandId()+"\",\"commodityCardType\":\"DEPOSIT_CARD\",\"voucherBusinessNo\":null,\"thirdOrderNo\":null,\"operatorId\":\""+xmAppApi.getLoginInfo().getAdminId()+"\"}";
        JSONObject response = axfTools.getAXFPageOrder(body);
        // 查询列表数据
        int total = response.getJSONObject("result").getJSONArray("records").size();
        String orderId = "";
        for (int i = 0; i < total; i++){
            double receivedAmount = response.getJSONObject("result").getJSONArray("records").getJSONObject(i).getDouble("receivedAmount");
            if (receivedAmount > 0){
                // 查询详情数据
                orderId = response.getJSONObject("result").getJSONArray("records").getJSONObject(i).getString("id");
                break;
            }
        }

        body = "{\"orderId\":\""+orderId+"\",\"studioId\":\""+xmAppApi.getLoginInfo().getStudioId()+"\",\"brandId\":\""+xmAppApi.getLoginInfo().getBrandId()+"\",\"operatorId\":\""+xmAppApi.getLoginInfo().getAdminId()+"\"}";

        xmAppApi.doRequest(RequestType.JSON,params,body,headers).assetsSuccess(true);
        response = xmAppApi.getBodyInJSON();
        // 验证扣款明细有数据
        Assert.assertEquals(response.getJSONArray("result").size()>0,true);
    }



}
